/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.LocalStore;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreComboChoiceComp;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.platform.BindingsHelper;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.host.AbstractHostStore;
import io.xpipe.ext.base.host.HostAddressGatewayStore;
import io.xpipe.ext.base.host.HostAddressStore;
import io.xpipe.ext.base.service.AbstractServiceStore;
import io.xpipe.ext.base.service.AbstractServiceStoreProvider;
import io.xpipe.ext.base.service.CustomServiceStore;
import io.xpipe.ext.base.service.ServiceProtocolType;
import io.xpipe.ext.base.service.ServiceProtocolTypeHelper;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class CustomServiceStoreProvider
extends AbstractServiceStoreProvider {
    @Override
    public DataStoreEntry getSyntheticParent(DataStoreEntry store) {
        CustomServiceStore c = (CustomServiceStore)store.getStore();
        if (c.getHost() == null || c.getHost().getStore() instanceof AbstractHostStore) {
            return null;
        }
        return super.getSyntheticParent(store);
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        CustomServiceStore c = (CustomServiceStore)store.getStore();
        if (c.getHost() != null && c.getHost().getStore() instanceof AbstractHostStore) {
            return c.getHost().get();
        }
        return super.getDisplayParent(store);
    }

    public int getOrderPriority() {
        return -1;
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.SERVICE;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        CustomServiceStore st = (CustomServiceStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty comboHost = new SimpleObjectProperty((Object)StoreComboChoiceComp.ComboValue.of((String)st.getAddress(), st.getHost()));
        SimpleObjectProperty gateway = new SimpleObjectProperty(st.getGateway());
        ObjectBinding hideGateway = BindingsHelper.map((ObservableValue)comboHost, c -> c == null || c.getRef() != null);
        comboHost.addListener((obs, o, n) -> {
            if (n != null && n.getRef() != null) {
                gateway.setValue(null);
            }
        });
        SimpleObjectProperty localPort = new SimpleObjectProperty((Object)st.getLocalPort());
        SimpleObjectProperty remotePort = new SimpleObjectProperty((Object)st.getRemotePort());
        SimpleObjectProperty serviceProtocolType = new SimpleObjectProperty((Object)st.getServiceProtocolType());
        SimpleBooleanProperty tunnelToLocalhost = new SimpleBooleanProperty(st.getTunnelToLocalhost() != null ? st.getTunnelToLocalhost() : true);
        BooleanBinding hideTunnelToLocalhost = Bindings.createBooleanBinding(() -> {
            HostAddressGatewayStore g;
            DataStore patt0$temp;
            return comboHost.get() == null || gateway.get() != null || (patt0$temp = ((StoreComboChoiceComp.ComboValue)comboHost.get()).getRef().getStore()) instanceof HostAddressGatewayStore && (g = (HostAddressGatewayStore)patt0$temp).getTunnelGateway() != null && !(g.getTunnelGateway().getStore() instanceof LocalStore);
        }, (Observable[])new Observable[]{comboHost, gateway});
        BooleanBinding hideLocalPort = Bindings.createBooleanBinding(() -> comboHost.get() == null || !tunnelToLocalhost.get(), (Observable[])new Observable[]{hideTunnelToLocalhost, tunnelToLocalhost});
        StoreComboChoiceComp hostChoice = new StoreComboChoiceComp(hostStore -> {
            HostAddress addr = hostStore.getHostAddress();
            return addr != null && !addr.isEmpty() ? addr.get() : null;
        }, entry, (Property)comboHost, HostAddressStore.class, n -> true, StoreViewState.get().getAllConnectionsCategory(), false);
        StoreChoiceComp gatewayChoice = new StoreChoiceComp(entry, (ObjectProperty)gateway, NetworkTunnelStore.class, ref -> !ref.get().equals((Object)DataStorage.get().local()), StoreViewState.get().getAllConnectionsCategory(), true);
        OptionsBuilder q = new OptionsBuilder().nameAndDescription("serviceHost").addComp((BaseRegionBuilder)hostChoice, (Property)comboHost).nonNull().nameAndDescription("gateway").addComp((BaseRegionBuilder)gatewayChoice, (Property)gateway).hide((ObservableValue)hideGateway).nameAndDescription("serviceRemotePort").addInteger((Property)remotePort).nonNull().sub(ServiceProtocolTypeHelper.choice((Property<ServiceProtocolType>)serviceProtocolType), (Property)serviceProtocolType).nonNull().nameAndDescription("tunnelToLocalhost").addToggle((Property)tunnelToLocalhost).hide((ObservableValue)hideTunnelToLocalhost).nameAndDescription("serviceLocalPort").addInteger((Property)localPort).hide((ObservableValue)hideLocalPort).bind(() -> ((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((AbstractServiceStore.AbstractServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)((CustomServiceStore.CustomServiceStoreBuilder)CustomServiceStore.builder().address(comboHost.get() != null ? ((StoreComboChoiceComp.ComboValue)comboHost.get()).getManualHost() : null)).host(comboHost.get() != null ? ((StoreComboChoiceComp.ComboValue)comboHost.get()).getRef() : null)).gateway((DataStoreEntryRef<NetworkTunnelStore>)((DataStoreEntryRef)gateway.get()))).localPort((Integer)localPort.get())).remotePort((Integer)remotePort.get())).serviceProtocolType((ServiceProtocolType)serviceProtocolType.get())).tunnelToLocalhost(tunnelToLocalhost.get())).build(), new Property[]{store});
        return q.buildDialog();
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return CustomServiceStore.builder().build();
    }

    public String getId() {
        return "customService";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(CustomServiceStore.class);
    }
}

