/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.host.HostAddressStore;
import io.xpipe.ext.base.service.AbstractServiceStore;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="fixedService")
@JsonDeserialize(builder=FixedServiceStoreBuilderImpl.class)
public class FixedServiceStore
extends AbstractServiceStore
implements FixedChildStore {
    private final DataStoreEntryRef<HostAddressStore> host;
    private final DataStoreEntryRef<? extends DataStore> displayParent;
    private final Boolean tunnelToLocalhost;

    @Override
    public String getAddress() {
        return null;
    }

    @Override
    public DataStoreEntryRef<NetworkTunnelStore> getGateway() {
        return null;
    }

    @Override
    public DataStoreEntryRef<HostAddressStore> getHost() {
        return this.host;
    }

    @Override
    public boolean licenseRequired() {
        return false;
    }

    public FixedChildStore merge(FixedChildStore other) {
        FixedServiceStore o = (FixedServiceStore)other;
        return ((FixedServiceStoreBuilder)this.toBuilder().tunnelToLocalhost(o.tunnelToLocalhost)).build();
    }

    @Override
    public void checkComplete() throws Throwable {
        super.checkComplete();
        Validators.nonNull(this.displayParent);
        Validators.nonNull((Object)this.displayParent.getStore());
    }

    public OptionalInt getFixedId() {
        return OptionalInt.of(this.getRemotePort());
    }

    @Override
    public boolean shouldTunnel() {
        return this.tunnelToLocalhost == null || this.tunnelToLocalhost != false;
    }

    @Generated
    protected FixedServiceStore(FixedServiceStoreBuilder<?, ?> b) {
        super(b);
        this.host = b.host;
        this.displayParent = b.displayParent;
        this.tunnelToLocalhost = b.tunnelToLocalhost;
    }

    @Generated
    public static FixedServiceStoreBuilder<?, ?> builder() {
        return new FixedServiceStoreBuilderImpl();
    }

    @Generated
    public FixedServiceStoreBuilder<?, ?> toBuilder() {
        return new FixedServiceStoreBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public DataStoreEntryRef<? extends DataStore> getDisplayParent() {
        return this.displayParent;
    }

    @Generated
    public Boolean getTunnelToLocalhost() {
        return this.tunnelToLocalhost;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedServiceStore)) {
            return false;
        }
        FixedServiceStore other = (FixedServiceStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$tunnelToLocalhost = this.getTunnelToLocalhost();
        Boolean other$tunnelToLocalhost = other.getTunnelToLocalhost();
        if (this$tunnelToLocalhost == null ? other$tunnelToLocalhost != null : !((Object)this$tunnelToLocalhost).equals(other$tunnelToLocalhost)) {
            return false;
        }
        DataStoreEntryRef<HostAddressStore> this$host = this.getHost();
        DataStoreEntryRef<HostAddressStore> other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        DataStoreEntryRef<? extends DataStore> this$displayParent = this.getDisplayParent();
        DataStoreEntryRef<? extends DataStore> other$displayParent = other.getDisplayParent();
        return !(this$displayParent == null ? other$displayParent != null : !this$displayParent.equals(other$displayParent));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FixedServiceStore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $tunnelToLocalhost = this.getTunnelToLocalhost();
        result = result * 59 + ($tunnelToLocalhost == null ? 43 : ((Object)$tunnelToLocalhost).hashCode());
        DataStoreEntryRef<HostAddressStore> $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        DataStoreEntryRef<? extends DataStore> $displayParent = this.getDisplayParent();
        result = result * 59 + ($displayParent == null ? 43 : $displayParent.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FixedServiceStore(super=" + super.toString() + ", host=" + String.valueOf(this.getHost()) + ", displayParent=" + String.valueOf(this.getDisplayParent()) + ", tunnelToLocalhost=" + this.getTunnelToLocalhost() + ")";
    }

    @Generated
    public static abstract class FixedServiceStoreBuilder<C extends FixedServiceStore, B extends FixedServiceStoreBuilder<C, B>>
    extends AbstractServiceStore.AbstractServiceStoreBuilder<C, B> {
        @Generated
        private DataStoreEntryRef<HostAddressStore> host;
        @Generated
        private DataStoreEntryRef<? extends DataStore> displayParent;
        @Generated
        private Boolean tunnelToLocalhost;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FixedServiceStoreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FixedServiceStore instance, FixedServiceStoreBuilder<?, ?> b) {
            b.host(instance.host);
            b.displayParent(instance.displayParent);
            b.tunnelToLocalhost(instance.tunnelToLocalhost);
        }

        @Generated
        public B host(DataStoreEntryRef<HostAddressStore> host) {
            this.host = host;
            return (B)this.self();
        }

        @Generated
        public B displayParent(DataStoreEntryRef<? extends DataStore> displayParent) {
            this.displayParent = displayParent;
            return (B)this.self();
        }

        @Generated
        public B tunnelToLocalhost(Boolean tunnelToLocalhost) {
            this.tunnelToLocalhost = tunnelToLocalhost;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FixedServiceStore.FixedServiceStoreBuilder(super=" + super.toString() + ", host=" + String.valueOf(this.host) + ", displayParent=" + String.valueOf(this.displayParent) + ", tunnelToLocalhost=" + this.tunnelToLocalhost + ")";
        }
    }

    @JsonTypeName(value="fixedService")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class FixedServiceStoreBuilderImpl
    extends FixedServiceStoreBuilder<FixedServiceStore, FixedServiceStoreBuilderImpl> {
        @Generated
        private FixedServiceStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected FixedServiceStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FixedServiceStore build() {
            return new FixedServiceStore(this);
        }
    }
}

