/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.action.AbstractAction;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.hub.action.HubLeafProvider;
import io.xpipe.app.hub.action.StoreAction;
import io.xpipe.app.hub.action.StoreActionCategory;
import io.xpipe.app.platform.ClipboardHelper;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.service.AbstractServiceStore;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public class ServiceCopyAddressHubLeafProvider
implements HubLeafProvider<AbstractServiceStore> {
    public StoreActionCategory getCategory() {
        return StoreActionCategory.CUSTOM;
    }

    public boolean isMajor() {
        return true;
    }

    public ObservableValue<String> getName(DataStoreEntryRef<AbstractServiceStore> store) {
        return AppI18n.observable((String)"copyAddress", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon(DataStoreEntryRef<AbstractServiceStore> store) {
        return new LabelGraphic.IconGraphic("mdi2c-content-copy");
    }

    public Class<AbstractServiceStore> getApplicableClass() {
        return AbstractServiceStore.class;
    }

    public AbstractAction createAction(DataStoreEntryRef<AbstractServiceStore> ref) {
        return ((Action.ActionBuilder)Action.builder().ref(ref)).build();
    }

    public String getId() {
        return "copyServiceAddress";
    }

    @JsonDeserialize(builder=ActionBuilderImpl.class)
    public static class Action
    extends StoreAction<AbstractServiceStore> {
        public void executeImpl() throws Exception {
            AbstractServiceStore serviceStore = (AbstractServiceStore)this.ref.getStore();
            serviceStore.startSessionIfNeeded();
            String full = serviceStore.getServiceProtocolType().formatAddress(serviceStore.getOpenTargetUrl());
            ClipboardHelper.copyUrl((String)full);
        }

        @Generated
        protected Action(ActionBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static ActionBuilder<?, ?> builder() {
            return new ActionBuilderImpl();
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class ActionBuilderImpl
        extends ActionBuilder<Action, ActionBuilderImpl> {
            @Generated
            private ActionBuilderImpl() {
            }

            @Override
            @Generated
            protected ActionBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Action build() {
                return new Action(this);
            }
        }

        @Generated
        public static abstract class ActionBuilder<C extends Action, B extends ActionBuilder<C, B>>
        extends StoreAction.StoreActionBuilder<AbstractServiceStore, C, B> {
            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "ServiceCopyAddressHubLeafProvider.Action.ActionBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

