/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.aws;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.app.util.Validators;
import io.xpipe.core.KeyValue;
import io.xpipe.ext.base.host.HostAddressSwitchStore;
import io.xpipe.ext.base.identity.IdentitySwitchStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.store.PauseableStore;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import io.xpipe.ext.proc.aws.a;
import io.xpipe.ext.proc.aws.l;
import io.xpipe.ext.proc.cloud.b;
import io.xpipe.ext.proc.cloud.d;
import io.xpipe.ext.proc.ssh.e;
import io.xpipe.ext.proc.ssh.g;
import io.xpipe.ext.proc.tunnel.i;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="awsEc2Instance")
@JsonDeserialize(builder=b.class)
public final class f
extends io.xpipe.ext.proc.cloud.b<io.xpipe.ext.proc.aws.b, c>
implements FixedChildStore,
NameableStore,
NetworkTunnelStore,
SelfReferentialStore,
ShellStore,
HostAddressSwitchStore,
PauseableStore,
StartableStore,
StoppableStore,
i {
    private final String instanceId;
    private final Boolean useSsm;

    @Override
    protected final Optional<g> buildBaseConfig() {
        try {
            if (this.useSsm != null && this.useSsm.booleanValue()) {
                Object object = ((l)((io.xpipe.ext.proc.aws.b)this.parent.getStore()).getParent().getStore()).view();
                ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
                arrayList.add(new KeyValue("ProxyCommand", ((a.a)((Object)object)).m(this.instanceId)));
                arrayList.add(new KeyValue("User", ((e)this).getUser().retrieveUsername()));
                object = this.getAdditionalOptions();
                if (object != null) {
                    arrayList.addAll(((g)object).dF().dQ());
                }
                return Optional.of(new g(new g.a(this.distinctConfigHostName(), arrayList)));
            }
            return Optional.empty();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    @Override
    protected final String distinctConfigHostName() {
        return super.distinctConfigHostName() + "_aws";
    }

    @Override
    public final g toConfigHost() {
        a.a a2 = ((l)((io.xpipe.ext.proc.aws.b)this.parent.getStore()).getParent().getStore()).view();
        boolean bl = a2.ae().ac().equals(io.xpipe.ext.proc.aws.a.W());
        if (bl && this.useSsm != null && this.useSsm.booleanValue()) {
            List<KeyValue> list = super.toConfigHost().dH().getFirst().dQ();
            list.removeIf(keyValue -> keyValue.getKey().equals("HostName"));
            list.removeIf(keyValue -> keyValue.getKey().equals("Port"));
            list.add(new KeyValue("ProxyCommand", a2.m(this.instanceId)));
            list.add(new KeyValue("User", ((e)this).getUser().retrieveUsername()));
            return new g(new g.a(this.distinctConfigHostName(), list));
        }
        return super.toConfigHost();
    }

    @Override
    protected final void adaptShellControl(ShellControl shellControl) {
        shellControl.withExceptionConverter(io.xpipe.ext.proc.aws.a.exceptionConverter());
        shellControl.requireLicensedFeature(LicenseProvider.get().getFeature("aws"));
    }

    @Override
    public final CommandBuilder buildBaseCommand() {
        if (this.useSsm != null && this.useSsm.booleanValue()) {
            this.refreshState(true);
            Object object = this.distinctConfigHostName();
            object = (String)(this.identity.unwrap().getUsername().hasUser() ? this.identity.unwrap().getUsername().retrieveUsername() + "@" : "") + (String)object;
            object = CommandBuilder.of().addQuoted((String)object);
            a.a a2 = ((l)((io.xpipe.ext.proc.aws.b)this.parent.getStore()).getParent().getStore()).view();
            object.environment(a2.af());
            return object;
        }
        return super.buildBaseCommand();
    }

    @Override
    protected final void refreshState(boolean bl) {
        Object object = ((l)((io.xpipe.ext.proc.aws.b)this.parent.getStore()).getParent().getStore()).view();
        if ((object = object.r("Name=instance-id,Values=" + this.instanceId)).isEmpty()) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Instance " + this.instanceId + " does not exist"));
        }
        if (object.size() != 1) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Ambiguous instance id " + this.instanceId));
        }
        object = (a.b)object.getFirst();
        object = ((c.a)((Object)((c.a)((Object)((d.a)((Object)((c.a)((Object)c.builder().instanceName(((a.b)object).getInstanceName()))).instanceType(((a.b)object).getInstanceType()))).address(HostAddress.of((String)((a.b)object).aj())))).state(((a.b)object).getState()))).build();
        f f2 = this;
        f2.setState((DataStoreState)((c)f2.getState()).mergeCopy((DataStoreState)object));
        if (bl && !"running".equals(((c)this.getState()).getState())) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Instance is not running"));
        }
    }

    @Override
    public final void checkComplete() {
        super.checkComplete();
        Validators.nonNull(this.parent);
        Validators.isType(this.parent, io.xpipe.ext.proc.aws.b.class);
        this.parent.checkComplete();
        Validators.nonNull((Object)this.instanceId);
        Validators.nonNull((Object)this.useSsm);
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.instanceId));
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (f)fixedChildStore;
        return ((a)this.toBuilder().identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    public final Optional<HostAddressSwitchStore> withAddress(String object) {
        object = ((c.a)((Object)((c)this.getState()).toBuilder().address(((c)this.getState()).getAddress().withValue(object)))).build();
        this.setState((DataStoreState)object);
        return Optional.empty();
    }

    public final String getName() {
        return ((c)this.getState()).getInstanceName();
    }

    @Override
    public final boolean supportsGateway() {
        return this.useSsm == null || this.useSsm == false;
    }

    @Override
    public final Class<c> getStateClass() {
        return c.class;
    }

    public final void pause() {
        LicenseProvider.get().getFeature("aws").throwIfUnsupported();
        a.a a2 = ((l)((io.xpipe.ext.proc.aws.b)this.parent.getStore()).getParent().getStore()).view();
        a2.p(this.instanceId);
        this.refreshState(false);
    }

    public final void start() {
        LicenseProvider.get().getFeature("aws").throwIfUnsupported();
        a.a a2 = ((l)((io.xpipe.ext.proc.aws.b)this.parent.getStore()).getParent().getStore()).view();
        a2.n(this.instanceId);
        for (int i2 = 0; i2 < 20; ++i2) {
            this.refreshState(false);
            boolean bl = "pending".equals(((c)this.getState()).getState());
            if (!bl) break;
            ThreadHelper.sleep((long)2000L);
        }
    }

    public final void stop() {
        LicenseProvider.get().getFeature("aws").throwIfUnsupported();
        a.a a2 = ((l)((io.xpipe.ext.proc.aws.b)this.parent.getStore()).getParent().getStore()).view();
        a2.o(this.instanceId);
        for (int i2 = 0; i2 < 25; ++i2) {
            this.refreshState(false);
            boolean bl = "stopping".equals(((c)this.getState()).getState());
            if (!bl) break;
            ThreadHelper.sleep((long)2000L);
        }
    }

    public final IdentitySwitchStore withIdentity(IdentityValue identityValue) {
        return ((a)this.toBuilder().identity(identityValue)).build();
    }

    @Generated
    protected f(a<?, ?> a2) {
        super(a2);
        this.instanceId = a2.instanceId;
        this.useSsm = a2.useSsm;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public final Boolean getUseSsm() {
        return this.useSsm;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof f)) {
            return false;
        }
        Object object2 = (f)object;
        if (!((f)object2).canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getUseSsm();
        Boolean bl = ((f)object2).getUseSsm();
        if (object == null ? bl != null : !object.equals(bl)) {
            return false;
        }
        object = this.getInstanceId();
        object2 = ((f)object2).getInstanceId();
        return !(object == null ? object2 != null : !object.equals(object2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof f;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getUseSsm();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getInstanceId();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "AwsEc2InstanceStore(super=" + super.toString() + ", instanceId=" + this.getInstanceId() + ", useSsm=" + this.getUseSsm() + ")";
    }

    @JsonDeserialize(builder=b.class)
    public static class c
    extends d {
        private final String instanceName;
        private final String instanceType;

        public c mergeCopy(DataStoreState object) {
            object = (c)((Object)object);
            d.a a2 = this.toBuilder();
            this.mergeBuilder((c)((Object)object), (a<?, ?>)a2);
            return ((a)a2).build();
        }

        protected void mergeBuilder(c c2, a<?, ?> a2) {
            super.mergeBuilder(c2, a2);
            a2.instanceName((String)c.useNewer((Object)this.instanceName, (Object)c2.instanceName));
            a2.instanceType((String)c.useNewer((Object)this.instanceType, (Object)c2.instanceType));
        }

        @Generated
        protected c(a<?, ?> a2) {
            super((d.a<?, ?>)a2);
            this.instanceName = a2.instanceName;
            this.instanceType = a2.instanceType;
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @Override
        @Generated
        public a<?, ?> toBuilder() {
            return new b().$fillValuesFrom(this);
        }

        @Generated
        public String getInstanceName() {
            return this.instanceName;
        }

        @Generated
        public String getInstanceType() {
            return this.instanceType;
        }

        @Override
        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof c)) {
                return false;
            }
            Object object2 = (c)((Object)object);
            if (!object2.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            object = this.getInstanceName();
            String string = object2.getInstanceName();
            if (object == null ? string != null : !object.equals(string)) {
                return false;
            }
            object = this.getInstanceType();
            object2 = object2.getInstanceType();
            return !(object == null ? object2 != null : !object.equals(object2));
        }

        @Override
        @Generated
        protected boolean canEqual(Object object) {
            return object instanceof c;
        }

        @Override
        @Generated
        public int hashCode() {
            int n2 = super.hashCode();
            String string = this.getInstanceName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            string = this.getInstanceType();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        @Generated
        public static abstract class a<C extends c, B extends a<C, B>>
        extends d.a<C, B> {
            @Generated
            private String instanceName;
            @Generated
            private String instanceType;

            @Override
            @Generated
            protected B $fillValuesFrom(C c2) {
                super.$fillValuesFrom(c2);
                a.$fillValuesFromInstanceIntoBuilder(c2, this);
                return (B)((Object)this.self());
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(c c2, a<?, ?> a2) {
                a2.instanceName(c2.instanceName);
                a2.instanceType(c2.instanceType);
            }

            @Generated
            public B instanceName(String string) {
                this.instanceName = string;
                return (B)((Object)this.self());
            }

            @Generated
            public B instanceType(String string) {
                this.instanceType = string;
                return (B)((Object)this.self());
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AwsEc2InstanceStore.State.StateBuilder(super=" + super.toString() + ", instanceName=" + this.instanceName + ", instanceType=" + this.instanceType + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<c, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final c build() {
                return new c(this);
            }
        }
    }

    @Generated
    public static abstract class a<C extends f, B extends a<C, B>>
    extends b.a<io.xpipe.ext.proc.aws.b, c, C, B> {
        @Generated
        private String instanceId;
        @Generated
        private Boolean useSsm;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(f f2, a<?, ?> a2) {
            a2.instanceId(f2.instanceId);
            a2.useSsm(f2.useSsm);
        }

        @Generated
        public B instanceId(String string) {
            this.instanceId = string;
            return (B)this.self();
        }

        @Generated
        public B useSsm(Boolean bl) {
            this.useSsm = bl;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AwsEc2InstanceStore.AwsEc2InstanceStoreBuilder(super=" + super.toString() + ", instanceId=" + this.instanceId + ", useSsm=" + this.useSsm + ")";
        }
    }

    @JsonTypeName(value="awsEc2Instance")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<f, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final f build() {
            return new f(this);
        }
    }
}

