/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.aws;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.core.AppInstallation;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.FixedHierarchyStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.process.CountDown;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.SecretManager;
import io.xpipe.app.secret.SecretQuery;
import io.xpipe.app.secret.SecretQueryResult;
import io.xpipe.app.secret.SecretQueryState;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.SecretValue;
import io.xpipe.core.UuidHelper;
import io.xpipe.ext.proc.aws.a;
import io.xpipe.ext.proc.aws.b;
import io.xpipe.ext.proc.aws.h;
import io.xpipe.ext.proc.aws.r;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import lombok.Generated;

@JsonTypeName(value="awsProfile")
@JsonDeserialize(builder=b.class)
public final class l
implements FixedChildStore,
FixedHierarchyStore,
SelfReferentialStore {
    private final DataStoreEntryRef<h> install;
    private final String name;
    private final c configDetails;
    private final Boolean sourceFromFile;
    private final String region;
    private final String accessKeyId;
    private final SecretRetrievalStrategy secretAccessKey;

    private Path prepareTempConfig() {
        if (!this.sourceFromFile.booleanValue()) {
            Object object = this.getSelfEntry().getName().replaceAll("[^\\w ]", "-");
            Path path = AppInstallation.ofCurrent().getCliExecutablePath();
            UUID uUID = UuidHelper.generateFromObject((Object[])new Object[]{this});
            SecretQuery secretQuery = this.secretAccessKey.query();
            UUID uUID2 = this.getSelfEntry().getUuid();
            secretQuery = new SecretQuery(){
                private /* synthetic */ SecretQuery aT;
                private /* synthetic */ l aU;
                {
                    this.aT = secretQuery;
                    l l3 = l2;
                    Objects.requireNonNull(l3);
                    this.aU = l3;
                }

                public final SecretQueryResult query(String string) {
                    if ((string = this.aT.query(string)).getState() != SecretQueryState.NORMAL) {
                        return string;
                    }
                    string = "{\n  \"Version\": 1,\n  \"AccessKeyId\": \"%s\",\n  \"SecretAccessKey\": \"%s\"\n}\n".formatted(this.aU.accessKeyId, string.getSecret().getSecretValue());
                    return new SecretQueryResult((SecretValue)InPlaceSecretValue.of((String)string), SecretQueryState.NORMAL);
                }

                public final Duration cacheDuration() {
                    return this.aT.cacheDuration();
                }

                public final boolean retryOnFail() {
                    return true;
                }

                public final boolean requiresUserInteraction() {
                    return this.aT.requiresUserInteraction();
                }
            };
            SecretManager.expectAskpass((UUID)uUID, (UUID)uUID2, List.of(secretQuery), (SecretQuery)SecretQuery.prompt((boolean)false), List.of(), List.of(), (CountDown)CountDown.of(), (boolean)true);
            object = "[profile " + (String)object + "]\nregion=" + this.getRegion() + "\ncredential_process = \"" + String.valueOf(path) + "\" askpass --request " + String.valueOf(uUID) + " --id " + String.valueOf(uUID2) + " \"Secret access key for profile " + (String)object + "\"\n";
            object = LocalShell.getShell().view().writeTextFileDeterministic(LocalShell.getShell().getSystemTemporaryDirectory().join(new String[]{"config"}), (String)object);
            return object.asLocalPath();
        }
        return null;
    }

    public final a.a view() {
        if (!this.sourceFromFile.booleanValue()) {
            String string = this.getSelfEntry().getName().replaceAll("[^\\w ]", "-");
            Path path = this.prepareTempConfig();
            return io.xpipe.ext.proc.aws.a.a(path).l(string);
        }
        return io.xpipe.ext.proc.aws.a.a(null).l(this.name);
    }

    public final void setEnvironment(ShellControl shellControl) {
        if (!this.sourceFromFile.booleanValue()) {
            String string = this.getSelfEntry().getName().replaceAll("[^\\w ]", "-");
            Path path = this.prepareTempConfig();
            shellControl.view().setEnvironmentVariable("AWS_PROFILE", string);
            shellControl.view().setEnvironmentVariable("AWS_CONFIG_FILE", path.toString());
        } else {
            shellControl.view().setEnvironmentVariable("AWS_PROFILE", this.name);
        }
        shellControl.view().setEnvironmentVariable("AWS_SHARED_CREDENTIALS_FILE", ((h)this.getInstall().getStore()).getCredentialsFilePath().toString());
    }

    public final String createScriptEnvironment(ShellControl shellControl) {
        Object object = "";
        if (!this.sourceFromFile.booleanValue()) {
            String string = this.getSelfEntry().getName().replaceAll("[^\\w ]", "-");
            Path path = this.prepareTempConfig();
            object = (String)object + shellControl.getShellDialect().getSetEnvironmentVariableCommand("AWS_PROFILE", string) + "\n";
            object = (String)object + shellControl.getShellDialect().getSetEnvironmentVariableCommand("AWS_CONFIG_FILE", path.toString()) + "\n";
        } else {
            object = (String)object + shellControl.getShellDialect().getSetEnvironmentVariableCommand("AWS_PROFILE", this.name) + "\n";
        }
        object = (String)object + shellControl.getShellDialect().getSetEnvironmentVariableCommand("AWS_SHARED_CREDENTIALS_FILE", ((h)this.getInstall().getStore()).getCredentialsFilePath().toString()) + "\n";
        return object;
    }

    public final boolean requiresMfa() {
        return this.configDetails != null && this.configDetails.mfaTimeout != null;
    }

    public final boolean removeLeftovers() {
        return false;
    }

    public final Optional<LicensedFeature> checkLicenseRequirement() {
        List<l> list;
        LicensedFeature licensedFeature = LicenseProvider.get().getFeature("aws");
        if (!licensedFeature.isSupported() && (list = DataStorage.get().getStoreEntries().stream().filter(dataStoreEntry -> dataStoreEntry.getStore() instanceof l && !DataStorage.get().getStoreChildren(dataStoreEntry).isEmpty()).sorted(Comparator.comparing(dataStoreEntry -> dataStoreEntry.getLastModified())).map(dataStoreEntry -> dataStoreEntry.getStore()).map(dataStore -> ((a)((l)dataStore).toBuilder().install(null)).build()).distinct().toList()).indexOf(((a)this.toBuilder().install(null)).build()) > 0) {
            return Optional.of(licensedFeature);
        }
        return Optional.empty();
    }

    public final boolean canManuallyRefresh() {
        return false;
    }

    public final List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() {
        if (this.requiresMfa()) {
            return List.of();
        }
        ArrayList<DataStoreEntryRef> arrayList = new ArrayList<DataStoreEntryRef>();
        arrayList.add(DataStoreEntry.createNew((String)"EC2 instances", ((b.a)io.xpipe.ext.proc.aws.b.builder().parent((DataStoreEntryRef<l>)this.getSelfEntry().ref())).build()).ref());
        arrayList.add(DataStoreEntry.createNew((String)"S3 buckets", ((r.a)r.builder().parent((DataStoreEntryRef<l>)this.getSelfEntry().ref())).build()).ref());
        return arrayList;
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        return fixedChildStore;
    }

    public final void checkComplete() {
        Validators.nonNull((Object)this.region);
        Validators.nonNull(this.install);
        Validators.isType(this.install, h.class);
        this.install.checkComplete();
        if (!this.sourceFromFile.booleanValue()) {
            Validators.nonNull((Object)this.accessKeyId);
            Validators.nonNull((Object)this.secretAccessKey);
            this.secretAccessKey.checkComplete();
            return;
        }
        Validators.nonNull((Object)this.name);
        Validators.nonNull((Object)this.configDetails);
    }

    public final OptionalInt getFixedId() {
        if (this.sourceFromFile == null || !this.sourceFromFile.booleanValue()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(Objects.hash(this.name));
    }

    @Generated
    protected l(a<?, ?> a2) {
        this.install = a2.install;
        this.name = a2.name;
        this.configDetails = a2.configDetails;
        this.sourceFromFile = a2.sourceFromFile;
        this.region = a2.region;
        this.accessKeyId = a2.accessKeyId;
        this.secretAccessKey = a2.secretAccessKey;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<h> getInstall() {
        return this.install;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public final c getConfigDetails() {
        return this.configDetails;
    }

    @Generated
    public final Boolean getSourceFromFile() {
        return this.sourceFromFile;
    }

    @Generated
    public final String getRegion() {
        return this.region;
    }

    @Generated
    public final String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Generated
    public final SecretRetrievalStrategy getSecretAccessKey() {
        return this.secretAccessKey;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof l)) {
            return false;
        }
        object = (l)object;
        Object object2 = this.getSourceFromFile();
        Object object3 = ((l)object).getSourceFromFile();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getInstall();
        object3 = ((l)object).getInstall();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getName();
        object3 = ((l)object).getName();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getConfigDetails();
        object3 = ((l)object).getConfigDetails();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getRegion();
        object3 = ((l)object).getRegion();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getAccessKeyId();
        object3 = ((l)object).getAccessKeyId();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getSecretAccessKey();
        object = ((l)object).getSecretAccessKey();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        Boolean bl = this.getSourceFromFile();
        int n2 = 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        Object object = this.getInstall();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getName();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getConfigDetails();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getRegion();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAccessKeyId();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getSecretAccessKey();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "AwsProfileStore(install=" + String.valueOf(this.getInstall()) + ", name=" + this.getName() + ", configDetails=" + String.valueOf(this.getConfigDetails()) + ", sourceFromFile=" + this.getSourceFromFile() + ", region=" + this.getRegion() + ", accessKeyId=" + this.getAccessKeyId() + ", secretAccessKey=" + String.valueOf(this.getSecretAccessKey()) + ")";
    }

    @JsonDeserialize(builder=a.class)
    public static final class c {
        private final Integer mfaTimeout;

        @Generated
        c(Integer n2) {
            this.mfaTimeout = n2;
        }

        @Generated
        public static a builder() {
            return new a();
        }

        @Generated
        public final Integer getMfaTimeout() {
            return this.mfaTimeout;
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof c)) {
                return false;
            }
            object = (c)object;
            Integer n2 = this.getMfaTimeout();
            object = ((c)object).getMfaTimeout();
            return !(n2 == null ? object != null : !((Object)n2).equals(object));
        }

        @Generated
        public final int hashCode() {
            Integer n2 = this.getMfaTimeout();
            int n3 = 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
            return n3;
        }

        @Generated
        public final String toString() {
            return "AwsProfileStore.ConfigDetails(mfaTimeout=" + this.getMfaTimeout() + ")";
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class a {
            @Generated
            private Integer mfaTimeout;

            @Generated
            a() {
            }

            @Generated
            public a mfaTimeout(Integer n2) {
                this.mfaTimeout = n2;
                return this;
            }

            @Generated
            public c build() {
                return new c(this.mfaTimeout);
            }

            @Generated
            public String toString() {
                return "AwsProfileStore.ConfigDetails.ConfigDetailsBuilder(mfaTimeout=" + this.mfaTimeout + ")";
            }
        }
    }

    @Generated
    public static abstract class a<C extends l, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<h> install;
        @Generated
        private String name;
        @Generated
        private c configDetails;
        @Generated
        private Boolean sourceFromFile;
        @Generated
        private String region;
        @Generated
        private String accessKeyId;
        @Generated
        private SecretRetrievalStrategy secretAccessKey;

        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(l l2, a<?, ?> a2) {
            a2.install(l2.install);
            a2.name(l2.name);
            a2.configDetails(l2.configDetails);
            a2.sourceFromFile(l2.sourceFromFile);
            a2.region(l2.region);
            a2.accessKeyId(l2.accessKeyId);
            a2.secretAccessKey(l2.secretAccessKey);
        }

        @Generated
        public B install(DataStoreEntryRef<h> dataStoreEntryRef) {
            this.install = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B name(String string) {
            this.name = string;
            return this.self();
        }

        @Generated
        public B configDetails(c c2) {
            this.configDetails = c2;
            return this.self();
        }

        @Generated
        public B sourceFromFile(Boolean bl) {
            this.sourceFromFile = bl;
            return this.self();
        }

        @Generated
        public B region(String string) {
            this.region = string;
            return this.self();
        }

        @Generated
        public B accessKeyId(String string) {
            this.accessKeyId = string;
            return this.self();
        }

        @Generated
        public B secretAccessKey(SecretRetrievalStrategy secretRetrievalStrategy) {
            this.secretAccessKey = secretRetrievalStrategy;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AwsProfileStore.AwsProfileStoreBuilder(install=" + String.valueOf(this.install) + ", name=" + this.name + ", configDetails=" + String.valueOf(this.configDetails) + ", sourceFromFile=" + this.sourceFromFile + ", region=" + this.region + ", accessKeyId=" + this.accessKeyId + ", secretAccessKey=" + String.valueOf(this.secretAccessKey) + ")";
        }
    }

    @JsonTypeName(value="awsProfile")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<l, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final l build() {
            return new l(this);
        }
    }
}

