/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.aws;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.ext.FileSystemStore;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ValidatableStore;
import io.xpipe.app.process.CountDown;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.secret.SecretInPlaceStrategy;
import io.xpipe.app.secret.SecretManager;
import io.xpipe.app.secret.SecretQuery;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.ext.base.host.AbstractHostStore;
import io.xpipe.ext.base.host.AbstractHostTransformStore;
import io.xpipe.ext.base.host.HostAddressGatewayStore;
import io.xpipe.ext.base.host.HostAddressStore;
import io.xpipe.ext.proc.aws.q;
import io.xpipe.ext.proc.d;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

@JsonTypeName(value="genericS3Bucket")
@JsonDeserialize(builder=b.class)
public final class v
implements FileSystemStore,
SelfReferentialStore,
ValidatableStore,
AbstractHostTransformStore,
HostAddressGatewayStore,
HostAddressStore,
d {
    private final DataStoreEntryRef<HostAddressGatewayStore> associatedHost;
    private final String address;
    private final Integer port;
    private final DataStoreEntryRef<NetworkTunnelStore> gateway;
    private final Boolean https;
    private final String accessKeyId;
    private final InPlaceSecretValue secretAccessKey;

    final String getHost() {
        Object object = this.getHostAddress().get();
        object = ((String)object).startsWith("s3://") || ((String)object).startsWith("http://") || ((String)object).startsWith("https://") ? object : "s3://" + (String)object;
        object = URI.create((String)object);
        return ((URI)object).getHost();
    }

    final String getSubPath() {
        Object object = this.getHostAddress().get();
        object = ((String)object).startsWith("s3://") || ((String)object).startsWith("http://") || ((String)object).startsWith("https://") ? object : "s3://" + (String)object;
        if (((URI)(object = URI.create((String)object))).getPath() != null && ((URI)object).getPath().length() > 1) {
            return ((URI)object).getPath().substring(1);
        }
        return null;
    }

    public final HostAddress getHostAddress() {
        if (this.associatedHost != null) {
            return ((HostAddressGatewayStore)this.associatedHost.getStore()).getHostAddress();
        }
        return HostAddress.of((String)this.getAddress());
    }

    public final void checkComplete() {
        if (this.associatedHost != null) {
            this.associatedHost.checkComplete();
        } else {
            Validators.nonNull((Object)this.address);
            Object object = this.address.startsWith("s3://") || this.address.startsWith("http://") || this.address.startsWith("https://") ? this.address : "s3://" + this.address;
            object = URI.create((String)object);
            Validators.nonNull((Object)((URI)object).getHost());
        }
        Validators.nonNull((Object)this.port);
        Validators.nonNull((Object)this.https);
        Validators.nonNull((Object)this.accessKeyId);
        Validators.nonNull((Object)this.secretAccessKey);
        if (this.gateway != null) {
            this.gateway.checkComplete();
        }
    }

    public final FileSystem createFileSystem() {
        this.startGatewayTunnelIfNeeded();
        boolean bl = this.useHttps();
        Object object = bl ? "https://" : "http://";
        object = this.getLocalGatewayTunnelPort() != -1 ? (String)object + "localhost:" + this.getLocalGatewayTunnelPort() : (String)object + this.getHost() + ":" + this.port;
        String string = this.getSubPath();
        ShellControl shellControl = ProcessControlProvider.get().createLocalProcessControl(true);
        shellControl.onInit(arg_0 -> this.lambda$createFileSystem$0((String)object, arg_0));
        shellControl.withInitSnippet(new ShellTerminalInitCommand(){
            private /* synthetic */ String bf;
            private /* synthetic */ v bg;
            {
                this.bf = string;
                v v3 = v2;
                Objects.requireNonNull(v3);
                this.bg = v3;
            }

            public final Optional<String> terminalContent(ShellControl object) {
                UUID uUID = UUID.randomUUID();
                SecretManager.expectAskpass((UUID)uUID, (UUID)this.bg.getSelfEntry().getUuid(), List.of(SecretInPlaceStrategy.builder().value(this.bg.secretAccessKey).build().query()), (SecretQuery)SecretQuery.prompt((boolean)true), List.of(), List.of(), (CountDown)CountDown.of(), (boolean)object.isInteractive());
                uUID = io.xpipe.ext.proc.util.a.a(object, uUID, this.bg.getSelfEntry().getUuid(), "Secret access key for " + this.bg.getSelfEntry().getName());
                object = object.getShellDialect();
                object = object.getSetEnvironmentVariableCommand("AWS_ACCESS_KEY_ID", this.bg.accessKeyId) + "\n" + object.getSetEnvironmentVariableCommand("AWS_ENDPOINT_URL", this.bf) + "\n" + object.setEnvironmentVariableFromScriptCommand("AWS_SECRET_ACCESS_KEY", (FilePath)uUID) + "\n" + object.getEchoCommand("Environment variables for the aws s3 cli commands have been set. For available commands, see https://docs.aws.amazon.com/cli/latest/reference/s3 and https://docs.aws.amazon.com/cli/latest/reference/s3api/", false);
                return Optional.of(object);
            }

            public final boolean canPotentiallyRunInDialect(ShellDialect shellDialect) {
                return true;
            }
        }, true);
        return new q(shellControl, string);
    }

    public final boolean useHttps() {
        boolean bl = this.https != null && this.https != false && (this.getGateway() == null || !((NetworkTunnelStore)this.getGateway().getStore()).requiresTunnel());
        return bl;
    }

    @Override
    public final String getGatewayTunnelTargetIp() {
        return this.getHostAddress().get();
    }

    @Override
    public final int getGatewayTunnelTargetPort() {
        return this.port;
    }

    public final boolean canConvertToAbstractHost() {
        return this.associatedHost == null;
    }

    public final AbstractHostStore createAbstractHostStore() {
        return AbstractHostStore.builder().host(this.getHost()).gateway(this.gateway).build();
    }

    public final AbstractHostTransformStore withNewParent(DataStoreEntryRef<AbstractHostStore> dataStoreEntryRef) {
        return ((a)((a)((a)this.toBuilder().address(null)).gateway(null)).associatedHost((DataStoreEntryRef<HostAddressGatewayStore>)dataStoreEntryRef.asNeeded())).build();
    }

    @Override
    public final DataStoreEntryRef<NetworkTunnelStore> getTunnelGateway() {
        if (this.associatedHost != null) {
            return ((HostAddressGatewayStore)this.associatedHost.getStore()).getTunnelGateway();
        }
        return this.gateway;
    }

    public final void validate() {
        FileSystem fileSystem = this.createFileSystem().open();
        if (fileSystem != null) {
            fileSystem.close();
        }
    }

    @Generated
    protected v(a<?, ?> a2) {
        this.associatedHost = a2.associatedHost;
        this.address = a2.address;
        this.port = a2.port;
        this.gateway = a2.gateway;
        this.https = a2.https;
        this.accessKeyId = a2.accessKeyId;
        this.secretAccessKey = a2.secretAccessKey;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<HostAddressGatewayStore> getAssociatedHost() {
        return this.associatedHost;
    }

    @Generated
    public final String getAddress() {
        return this.address;
    }

    @Generated
    public final Integer getPort() {
        return this.port;
    }

    @Generated
    public final DataStoreEntryRef<NetworkTunnelStore> getGateway() {
        return this.gateway;
    }

    @Generated
    public final Boolean getHttps() {
        return this.https;
    }

    @Generated
    public final String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Generated
    public final InPlaceSecretValue getSecretAccessKey() {
        return this.secretAccessKey;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof v)) {
            return false;
        }
        object = (v)object;
        Object object2 = this.getPort();
        Object object3 = ((v)object).getPort();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getHttps();
        object3 = ((v)object).getHttps();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getAssociatedHost();
        object3 = ((v)object).getAssociatedHost();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getAddress();
        object3 = ((v)object).getAddress();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getGateway();
        object3 = ((v)object).getGateway();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getAccessKeyId();
        object3 = ((v)object).getAccessKeyId();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getSecretAccessKey();
        object = ((v)object).getSecretAccessKey();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        Integer n2 = this.getPort();
        int n3 = 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
        Object object = this.getHttps();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAssociatedHost();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAddress();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getGateway();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAccessKeyId();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getSecretAccessKey();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        return n3;
    }

    @Generated
    public final String toString() {
        return "GenericS3BucketStore(associatedHost=" + String.valueOf(this.getAssociatedHost()) + ", address=" + this.getAddress() + ", port=" + this.getPort() + ", gateway=" + String.valueOf(this.getGateway()) + ", https=" + this.getHttps() + ", accessKeyId=" + this.getAccessKeyId() + ", secretAccessKey=" + String.valueOf(this.getSecretAccessKey()) + ")";
    }

    private /* synthetic */ void lambda$createFileSystem$0(String string, ShellControl shellControl) {
        shellControl.view().setEnvironmentVariable("AWS_ACCESS_KEY_ID", this.accessKeyId);
        shellControl.view().setEnvironmentVariable("AWS_ENDPOINT_URL", string);
        shellControl.view().setSensitiveEnvironmentVariable("AWS_SECRET_ACCESS_KEY", this.secretAccessKey.getSecretValue());
    }

    @Generated
    public static abstract class a<C extends v, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<HostAddressGatewayStore> associatedHost;
        @Generated
        private String address;
        @Generated
        private Integer port;
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> gateway;
        @Generated
        private Boolean https;
        @Generated
        private String accessKeyId;
        @Generated
        private InPlaceSecretValue secretAccessKey;

        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(v v2, a<?, ?> a2) {
            a2.associatedHost(v2.associatedHost);
            a2.address(v2.address);
            a2.port(v2.port);
            a2.gateway(v2.gateway);
            a2.https(v2.https);
            a2.accessKeyId(v2.accessKeyId);
            a2.secretAccessKey(v2.secretAccessKey);
        }

        @Generated
        public B associatedHost(DataStoreEntryRef<HostAddressGatewayStore> dataStoreEntryRef) {
            this.associatedHost = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B address(String string) {
            this.address = string;
            return this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return this.self();
        }

        @Generated
        public B gateway(DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef) {
            this.gateway = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B https(Boolean bl) {
            this.https = bl;
            return this.self();
        }

        @Generated
        public B accessKeyId(String string) {
            this.accessKeyId = string;
            return this.self();
        }

        @Generated
        public B secretAccessKey(InPlaceSecretValue inPlaceSecretValue) {
            this.secretAccessKey = inPlaceSecretValue;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "GenericS3BucketStore.GenericS3BucketStoreBuilder(associatedHost=" + String.valueOf(this.associatedHost) + ", address=" + this.address + ", port=" + this.port + ", gateway=" + String.valueOf(this.gateway) + ", https=" + this.https + ", accessKeyId=" + this.accessKeyId + ", secretAccessKey=" + String.valueOf(this.secretAccessKey) + ")";
        }
    }

    @JsonTypeName(value="genericS3Bucket")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<v, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final v build() {
            return new v(this);
        }
    }
}

