/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.dialect;

import io.xpipe.app.beacon.AppBeaconServer;
import io.xpipe.app.core.AppInstallation;
import io.xpipe.app.ext.FileEntry;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.NewLine;
import io.xpipe.app.process.ProcessExceptionConverter;
import io.xpipe.app.process.ScriptHelper;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialectAskpass;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellDumbMode;
import io.xpipe.app.process.ShellLaunchCommand;
import io.xpipe.app.process.ShellTemp;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.core.StreamCharset;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public abstract class e
implements ShellDialect {
    public static final String PAUSE_PROMPT = "Press enter to close this session ...";

    public boolean isCompatibleTo(ShellDialect shellDialect) {
        return shellDialect instanceof e;
    }

    public boolean isSourceCompatibleTo(ShellDialect shellDialect) {
        return this.equals(shellDialect) || shellDialect instanceof g;
    }

    public String setEnvironmentVariableFromScriptCommand(String string, FilePath filePath) {
        return "export " + string + "=$(" + String.valueOf(filePath) + ")";
    }

    public String unsetEnvironmentVariableCommand(String string) {
        return "unset " + string;
    }

    public CommandBuilder launchAsync(CommandBuilder commandBuilder, boolean bl) {
        return CommandBuilder.of().environment(commandBuilder.getEnvironmentVariables()).add(new String[]{"nohup"}).add(shellControl -> commandBuilder.buildBase(shellControl)).add(new String[]{"</dev/null"}).add(new String[]{"&>/dev/null"}).add(new String[]{"&", "disown"});
    }

    public String terminalLauncherScript(UUID uUID, String string, boolean bl) {
        int n2 = AppBeaconServer.get().getPort();
        Path path = AppInstallation.ofCurrent().getCliExecutablePath();
        String string2 = "echo \"Press [r] to restart or any other key to close this session ...\"\n%s\nif [ \"$PROMPT_KEY\" = \"r\" ]; then\n  unset PROMPT_KEY\n  continue\nfi\nunset PROMPT_KEY\n".formatted(this.readKeyCommand());
        String string3 = "if [ \"$?\" != 0 ]; then\n%s\nfi\n".formatted(string2.strip());
        return "while true\ndo\n'%s' terminal-wait --port %s --request %s\nr=$?\nif [ $r -ne 0 ]; then\n  %s\n  exit $r\nfi\n\nSCRIPT=\"$('%s' terminal-launch --port %s --request %s)\"\nr=$?\nif [ $r -ne 0 ]; then\n  %s\n  exit $r\nfi\n\nif [ -f \"$SCRIPT\" ]; then\n  . \"$SCRIPT\"\n  %s\n  exit 0\nelse\n  %s\n  exit 1\nfi\ndone\n".formatted(path, n2, uUID, bl ? string2 : string3, path, n2, uUID, bl ? string2 : string3, bl ? string2 : string3, this.getPauseCommand());
    }

    public String getCatchAllVariable() {
        return "\"$@\"";
    }

    public CommandControl queryFileSize(ShellControl shellControl, String string) {
        boolean bl = shellControl.view().getCachedPredicate("hasModernBsdStat", () -> shellControl.command(CommandBuilder.of().add(new String[]{"stat", "-L", "-f"}).addQuoted("%N").add(new String[]{"."})).executeAndCheck());
        boolean bl2 = shellControl.view().getCachedPredicate("hasModernLinuxStat", () -> shellControl.command(CommandBuilder.of().add(new String[]{"stat", "-L", "-c"}).addQuoted("%N").add(new String[]{"."})).executeAndCheck());
        if (bl2) {
            string = CommandBuilder.of().add(new String[]{"stat", "-c"}).addQuoted("%s").addFile(string);
            return shellControl.command((CommandBuilder)string);
        }
        if (bl) {
            string = CommandBuilder.of().add(new String[]{"stat", "-f"}).addQuoted("%z").addFile(string);
            return shellControl.command((CommandBuilder)string);
        }
        string = CommandBuilder.of().add(new String[]{"wc", "-c", "<"}).addFile(string);
        return shellControl.command((CommandBuilder)string);
    }

    public long queryDirectorySize(ShellControl stringArray, String string) {
        if ((stringArray = stringArray.command(CommandBuilder.of().add(new String[]{"du", "-s"}).addFile(string)).readStdoutAndStderr())[0].isEmpty() || stringArray[0].isBlank()) {
            return 0L;
        }
        if ((stringArray = stringArray[0].split("\\s+")).length < 2) {
            return 0L;
        }
        return Long.parseLong(stringArray[0]) << 10;
    }

    public CommandControl prepareUserTempDirectory(ShellControl shellControl, String string) {
        return shellControl.command(this.getMkdirsCommand(string) + " && chmod 700 " + this.fileArgument(string));
    }

    public FilePath getInitFileName(ShellControl shellControl, int n2) {
        return shellControl.getSystemTemporaryDirectory().join(new String[]{"xpipe-" + n2 + "." + this.getScriptFileEnding()});
    }

    public CommandControl directoryExists(ShellControl shellControl, String string) {
        return shellControl.command(String.format("test -d %s", this.fileArgument(string))).withExceptionConverter(this.exceptionConverter());
    }

    public CommandControl evaluateExpression(ShellControl shellControl, String object) {
        object = ((String)(object = ((String)object).replaceAll("[\"]", "\\\\$0"))).startsWith("~/") ? "~/\"" + ((String)object).substring(2) + "\"" : (((String)object).equals("~") ? "~" : "\"" + (String)object + "\"");
        return shellControl.command("echo " + (String)object);
    }

    public CommandControl resolveDirectory(ShellControl shellControl, String string) {
        return CommandBuilder.of().add(new String[]{"realpath"}).addFile(string).add(new String[]{"||"}).add(new String[]{"readlink", "-m"}).addFile(string).add(new String[]{"||"}).add(new String[]{"echo"}).addFile(string).build(shellControl);
    }

    public String prepareEnvironmentForCustomTerminalScripts() {
        return "set +u";
    }

    public String literalArgument(String string) {
        return "'" + string.replaceAll("'", "'\\\\''") + "'";
    }

    public String fileArgument(String string) {
        return "'" + string.replaceAll("'", "'\\\\''") + "'";
    }

    public String quoteArgument(String string) {
        string = string.replaceAll("[\"]", "\\$0");
        return "\"" + string + "\"";
    }

    public String prepareTerminalEnvironmentCommands() {
        return this.getSetEnvironmentVariableCommand("TERM", "xterm-256color") + "\n" + this.getSetEnvironmentVariableCommand("COLORTERM", "truecolor") + "\n" + this.unsetEnvironmentVariableCommand("NO_COLOR");
    }

    public String addToPathVariableCommand(List<String> object, boolean bl) {
        object = bl ? "$PATH:" + String.join((CharSequence)":", object) : String.join((CharSequence)":", object) + ":$PATH";
        return "export PATH=\"" + (String)object + "\"";
    }

    public String applyInitFileCommand(ShellControl object) {
        if ((object = this.getDefaultInitFiles((ShellControl)object)) == null || object.size() == 0) {
            return null;
        }
        boolean bl = AppPrefs.get() != null && AppPrefs.get().developerPrintInitFiles().get();
        return object.stream().map(string -> {
            String string2 = bl ? "echo \"Running %s with %s\"; ".formatted(string, this.getId()) : "";
            return String.format("if [ -f %s ]; then " + string2 + ". %s; fi", string, string, string);
        }).collect(Collectors.joining(this.getNewLine().getNewLineString()));
    }

    public String changeTitleCommand(String string) {
        String string2 = String.format("printf \"\\033]0;%s\\a\"", string);
        string = String.format("printf \"\\033]30;%s\\a\"", string);
        return string2 + ";" + string;
    }

    public CommandControl createStreamFileWriteCommand(ShellControl shellControl, String string, long l2) {
        boolean bl = shellControl.command(CommandBuilder.of().add(new String[]{"dd"}).add(new String[]{"ibs=1"}).add(new String[]{"count=0"}).add(new String[]{"of=/dev/null"}).add(new String[]{"if=/dev/null"}).add(new String[]{"iflag=fullblock"})).executeAndCheck();
        if (bl) {
            long l3 = l2 % 1024L;
            long l4 = l2 / 1024L;
            CommandBuilder commandBuilder = l4 > 0L ? CommandBuilder.of().add(new String[]{"dd"}).add(new String[]{"iflag=fullblock"}).add(new String[]{"ibs=" + 1024}).add(new String[]{"count=" + l4}).add(new String[]{"of=" + this.fileArgument(string)}) : CommandBuilder.of().add(new String[]{":", ">"}).addFile(string);
            shellControl = new io.xpipe.ext.proc.c(this, shellControl, l3 != 0L ? commandBuilder.add(new String[]{";"}).add(new String[]{"dd"}).add(new String[]{"iflag=fullblock"}).add(new String[]{"ibs=" + l3}).add(new String[]{"count=1"}).add(new String[]{">>"}).addFile(string) : commandBuilder, null){
                {
                    Objects.requireNonNull(e2);
                    super(shellControl, commandBuilder, null);
                }

                @Override
                public final void close() {
                    try {
                        try {
                            this.a.writeLine("");
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            super.close();
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throw throwable;
                    }
                }

                @Override
                public final io.xpipe.ext.proc.c l() {
                    if (this.running) {
                        return this;
                    }
                    io.xpipe.ext.proc.c c2 = super.l();
                    return c2;
                }

                @Override
                public final /* synthetic */ CommandControl start() {
                    return ((io.xpipe.ext.proc.c)this).l();
                }
            }.withExceptionConverter(this.exceptionConverter());
            shellControl.setExitTimeout(Duration.ofMillis(Long.MAX_VALUE));
            return shellControl;
        }
        shellControl = new io.xpipe.ext.proc.c(this, shellControl, CommandBuilder.ofString((String)String.format("cat > %s", this.fileArgument(string))), null){
            {
                Objects.requireNonNull(e2);
                super(shellControl, commandBuilder, null);
            }

            @Override
            public final void close() {
                try {
                    try {
                        this.closeStdin();
                        this.a.restart();
                    }
                    finally {
                        super.close();
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
            }

            @Override
            public final io.xpipe.ext.proc.c l() {
                if (this.running) {
                    return this;
                }
                io.xpipe.ext.proc.c c2 = super.l();
                return c2;
            }

            @Override
            public final /* synthetic */ CommandControl start() {
                return ((io.xpipe.ext.proc.c)this).l();
            }
        }.withExceptionConverter(this.exceptionConverter());
        shellControl.setExitTimeout(Duration.ofMillis(Long.MAX_VALUE));
        return shellControl;
    }

    public String getCdCommand(String string) {
        return "cd " + this.fileArgument(string);
    }

    public String getScriptFileEnding() {
        return "sh";
    }

    public String assembleCommand(String string, Map<String, String> object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : object.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append("=").append(this.literalArgument((String)entry.getValue())).append(" ");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public Stream<FileEntry> listFiles(FileSystem fileSystem, ShellControl shellControl, String string, boolean bl) {
        return io.xpipe.ext.proc.dialect.g.a(fileSystem, shellControl, FilePath.of((String)string), bl);
    }

    public Stream<String> listRoots(ShellControl shellControl) {
        return Stream.of("/");
    }

    public String prepareScriptContent(ShellControl shellControl, String string) {
        return "#!/usr/bin/env " + this.getExecutableName() + "\n" + string + "\n";
    }

    public String environmentVariable(String string) {
        return "$" + string;
    }

    public String getDiscardStdoutOperator() {
        return "> /dev/null";
    }

    public String getDiscardAllOperator() {
        return "> /dev/null 2>&1";
    }

    public String nullStdin(String string) {
        return string + " </dev/null";
    }

    public ShellDialectAskpass getAskpass() {
        return new io.xpipe.ext.proc.dialect.f(this);
    }

    public String getSetEnvironmentVariableCommand(String string, String string2) {
        return String.format("export %s=%s", string, this.fileArgument(string2));
    }

    public String getEchoCommand(String string, boolean bl) {
        return String.format("echo %s", this.fileArgument(string)) + (bl ? " 1>&2" : "");
    }

    public String getPrintVariableCommand(String string) {
        return "echo \"$" + string + "\"";
    }

    public CommandControl printUsernameCommand(ShellControl shellControl) {
        return shellControl.command("id -u -n");
    }

    public String getPrintStartEchoCommand(String string) {
        return "echo " + string.charAt(0) + "${INVALID}" + string.substring(1);
    }

    public Optional<String> executeRobustBootstrapOutputCommand(ShellControl object, String object2) {
        if (object.getTtyState().isPreservesOutput()) {
            Optional optional = object.command((String)object2).readStdoutIfPossible();
            return optional;
        }
        String string = UUID.randomUUID().toString();
        String string2 = UUID.randomUUID().toString();
        object2 = ((String)object2).startsWith("(") && ((String)object2).endsWith(")") ? ((String)object2).substring(1, ((String)object2).length() - 1) : object2;
        if (((Optional)(object = object.command((String)(object2 = "output=$(%s);echo \"%s${output}%s\"".formatted(object2, string.charAt(0) + "${INVALID}" + string.substring(1), string2.charAt(0) + "${INVALID}" + string2.substring(1)))).readStdoutIfPossible())).isEmpty()) {
            return object;
        }
        object2 = Pattern.compile(string + "(.*?)" + string2, 32);
        object = ((Pattern)object2).matcher((CharSequence)((Optional)object).get());
        if (((Matcher)object).find()) {
            return Optional.of(((Matcher)object).group(1).strip());
        }
        return Optional.empty();
    }

    public String getPrintExitCodeCommand(String string, String string2, String string3) {
        return String.format("echo %s%s${%s}%s", this.fileArgument(string), string2.charAt(0) + "${INVALID}" + string2.substring(1), this.getExitCodeVariable(), string3);
    }

    public int assignMissingExitCode() {
        return 160;
    }

    public CommandBuilder getOpenScriptCommand(String string) {
        return CommandBuilder.of().add(new String[]{this.getExecutableName(), "-c"}).addFile(string);
    }

    public String runScriptCommand(ShellControl shellControl, String string) {
        return this.fileArgument(string);
    }

    public String sourceScriptCommand(ShellControl shellControl, String string) {
        return "command -v " + this.getExecutableName() + " >/dev/null 2>&1 && . " + this.fileArgument(string);
    }

    public String executeCommandWithShell(String string) {
        return this.getExecutableName() + String.format(" -c %s", this.literalArgument(string));
    }

    public String getMkdirsCommand(String string) {
        return String.format("mkdir -p %s", this.fileArgument(string));
    }

    public CommandControl getFileReadCommand(ShellControl shellControl, String string) {
        return shellControl.command(String.format("dd ibs=1024 if=%s", this.fileArgument(string))).withExceptionConverter(this.exceptionConverter());
    }

    public String getPrintWorkingDirectoryCommand() {
        return "pwd";
    }

    public StreamCharset getTextCharset() {
        return StreamCharset.UTF8;
    }

    public CommandControl getFileCopyCommand(ShellControl shellControl, String string, String string2) {
        return shellControl.command(commandBuilder -> commandBuilder.add(new String[]{"cp", "-a"}).addFile(string).addFile(string2)).withExceptionConverter(this.exceptionConverter());
    }

    public CommandControl getFileMoveCommand(ShellControl shellControl, String string, String string2) {
        return shellControl.command(commandBuilder -> commandBuilder.add(new String[]{"mv", "-f"}).addFile(string).addFile(string2)).withExceptionConverter(this.exceptionConverter());
    }

    public CommandControl createTextFileWriteCommand(ShellControl shellControl, String string, String string2) {
        return this.createTextFileWriteCommand(shellControl, string, string2, null);
    }

    public CommandControl createScriptTextFileWriteCommand(ShellControl shellControl, String string, String string2) {
        return this.createTextFileWriteCommand(shellControl, string, string2, String.format("chmod +x %s", this.fileArgument(string2)));
    }

    public CommandControl deleteFileOrDirectory(ShellControl shellControl, String string) {
        return shellControl.command(String.format("rm -rf %s", this.fileArgument(string))).withExceptionConverter(this.exceptionConverter());
    }

    public String clearDisplayCommand() {
        return "clear || printf \"\\e[1;1H\\e[2J\"";
    }

    public ShellLaunchCommand getLaunchCommand() {
        return new ShellLaunchCommand(this){
            private /* synthetic */ e bu;
            {
                e e3 = e2;
                Objects.requireNonNull(e3);
                this.bu = e3;
            }

            public final String inlineCdCommand(String object) {
                object = ":;cd '" + (String)object + "';" + this.loginCommand() + ";" + this.bu.getPassthroughExitCommand();
                return this.bu.getExecutableName() + " -c \"" + (String)object + "\"";
            }

            public final List<String> localCommand() {
                return List.of(this.bu.getExecutableName(), "-l");
            }

            public final List<String> loginCommand(OsType.Any any) {
                return List.of(this.bu.getExecutableName(), "-l");
            }
        };
    }

    public ShellDumbMode getDumbMode() {
        return new ShellDumbMode(this){
            private /* synthetic */ e bu;
            {
                e e3 = e2;
                Objects.requireNonNull(e3);
                this.bu = e3;
            }

            public final void prepareImmediateDumbInit(ShellControl shellControl) {
                shellControl.writeLine("set +u");
            }

            public final void prepareDumbInit(ShellControl shellControl) {
                shellControl.writeLine(this.bu.getSetEnvironmentVariableCommand("NO_COLOR", "true"));
                shellControl.writeLine(this.bu.getSetEnvironmentVariableCommand("TERM", "dumb"));
                shellControl.writeLine(this.bu.getSetEnvironmentVariableCommand("LC_ALL", "C.UTF-8"));
                shellControl.writeLine(this.bu.getSetEnvironmentVariableCommand("LANG", "C.UTF-8"));
                shellControl.writeLine(this.bu.getSetEnvironmentVariableCommand("LANGUAGE", "C.UTF-8"));
            }
        };
    }

    public CommandControl createFileExistsCommand(ShellControl shellControl, String string) {
        return shellControl.command(String.format("test -f %s", this.fileArgument(string))).withExceptionConverter(this.exceptionConverter());
    }

    public CommandControl symbolicLink(ShellControl shellControl, String string, String string2) {
        return shellControl.command(CommandBuilder.of().add(new String[]{"ln", "-s", this.fileArgument(string2), this.fileArgument(string)}));
    }

    public CommandControl getFileDeleteCommand(ShellControl shellControl, String string) {
        return shellControl.command(commandBuilder -> commandBuilder.add(new String[]{"rm", "-f"}).addFile(string)).withExceptionConverter(this.exceptionConverter());
    }

    public CommandControl getFileTouchCommand(ShellControl shellControl, String string) {
        return shellControl.command(commandBuilder -> commandBuilder.add(new String[]{"touch"}).addFile(string)).withExceptionConverter(this.exceptionConverter());
    }

    public String whichCommand(ShellControl shellControl, String string) {
        return String.format("command -v %s", this.fileArgument(string));
    }

    public Charset determineCharset(ShellControl shellControl) {
        return StandardCharsets.UTF_8;
    }

    public NewLine getNewLine() {
        return NewLine.LF;
    }

    public abstract String getId();

    public boolean doesEchoInputByDefault() {
        return false;
    }

    protected String readKeyCommand() {
        return "read PROMPT_KEY";
    }

    public abstract List<String> getDefaultInitFiles(ShellControl var1);

    private CommandControl createTextFileWriteCommand(ShellControl shellControl, String object, String object2, String string) {
        String string2 = UUID.randomUUID().toString();
        String string3 = object;
        object = string3 + (string3.endsWith("\n") ? "" : "\n") + string2;
        object2 = "cat << '" + string2 + String.format("' > %s", this.fileArgument((String)object2)) + (String)(string != null ? " && " + string : "");
        return new io.xpipe.ext.proc.c(this, shellControl, CommandBuilder.ofString((String)object2), (String)object){
            private /* synthetic */ String bv;
            {
                this.bv = string;
                Objects.requireNonNull(e2);
                super(shellControl, commandBuilder);
            }

            @Override
            public final io.xpipe.ext.proc.c l() {
                if (this.running) {
                    return this;
                }
                io.xpipe.ext.proc.c c2 = super.l();
                c2.getParent().writeLine(this.bv);
                return c2;
            }

            @Override
            public final /* synthetic */ CommandControl start() {
                return ((io.xpipe.ext.proc.c)this).l();
            }
        };
    }

    private ProcessExceptionConverter exceptionConverter() {
        return new ProcessExceptionConverter(this){
            {
                Objects.requireNonNull(e2);
            }

            public final Throwable convert(Throwable throwable) {
                return ErrorEventFactory.expectedIfContains((Throwable)throwable, (String[])new String[]{"permission denied", "operation not permitted", "read-only file system", "No space left on device"});
            }
        };
    }

    public String getExitCodeVariable() {
        return "?";
    }

    public static class g
    extends e {
        @Override
        public boolean isSourceCompatibleTo(ShellDialect shellDialect) {
            return shellDialect instanceof e;
        }

        @Override
        public ShellDumbMode getDumbMode() {
            ShellDumbMode shellDumbMode = super.getDumbMode();
            return new ShellDumbMode(){
                private /* synthetic */ ShellDumbMode bw;
                {
                    this.bw = shellDumbMode;
                    Objects.requireNonNull(g2);
                }

                public final void prepareImmediateDumbInit(ShellControl shellControl) {
                    this.bw.prepareImmediateDumbInit(shellControl);
                }

                public final void prepareDumbInit(ShellControl shellControl) {
                    this.bw.prepareInlineShellSwitch(shellControl);
                    if (shellControl.isLocal() && shellControl.getOsType() == OsType.MACOS) {
                        shellControl.writeLine("eval $(/opt/homebrew/bin/brew shellenv)");
                    }
                }
            };
        }

        @Override
        public CommandBuilder launchAsync(CommandBuilder commandBuilder, boolean bl) {
            return CommandBuilder.of().add(new String[]{"{"}).add(shellControl -> this.assembleCommand("nohup", commandBuilder.buildEnvironmentVariables(shellControl))).add(shellControl -> commandBuilder.buildBase(shellControl)).add(new String[]{"</dev/null"}).add(new String[]{"&>/dev/null"}).add(new String[]{"&"}).add(new String[]{"}"}).add(new String[]{";", "sleep", "0.1", "||", "sleep", "1"});
        }

        @Override
        public String prepareScriptContent(ShellControl shellControl, String string) {
            return "#!/usr/bin/env " + this.getExecutableName() + "\n" + this.unsetEnvironmentVariableCommand("ENV") + "\n" + string + "\n";
        }

        @Override
        public ShellLaunchCommand getLaunchCommand() {
            ShellLaunchCommand shellLaunchCommand = super.getLaunchCommand();
            return new ShellLaunchCommand(){
                private /* synthetic */ ShellLaunchCommand bx;
                private /* synthetic */ g by;
                {
                    this.bx = shellLaunchCommand;
                    g g3 = g2;
                    Objects.requireNonNull(g3);
                    this.by = g3;
                }

                public final String inlineCdCommand(String string) {
                    return this.bx.inlineCdCommand(string);
                }

                public final List<String> localCommand() {
                    return this.bx.localCommand();
                }

                public final List<String> loginCommand(OsType.Any any) {
                    if (any == OsType.BSD || any == OsType.UNIX) {
                        return List.of(this.by.getExecutableName());
                    }
                    return this.bx.loginCommand(any);
                }
            };
        }

        @Override
        public String getId() {
            return "sh";
        }

        @Override
        public List<String> getDefaultInitFiles(ShellControl shellControl) {
            return List.of("/etc/profile", "~/.profile", "~/." + this.getExecutableName() + "rc");
        }

        public String getExecutableName() {
            return "sh";
        }

        public String queryVersion(ShellControl shellControl) {
            return null;
        }

        public String getPauseCommand() {
            return String.format("echo \"%s\"; read ans", e.PAUSE_PROMPT);
        }

        public String terminalInitCommand(ShellControl shellControl, String object, boolean bl) {
            object = "ENV=" + (String)object + " " + this.getExecutableName();
            shellControl = ScriptHelper.createExecScript((ShellDialect)this, (ShellControl)shellControl, (String)object);
            return this.getExecutableName() + " " + shellControl.toString();
        }

        public String getDisplayName() {
            return "sh";
        }

        @Generated
        public g() {
        }

        @Generated
        public String toString() {
            return "PosixDialect.Sh()";
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof g)) {
                return false;
            }
            return ((g)(object = (g)object)).canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object object) {
            return object instanceof g;
        }

        @Generated
        public int hashCode() {
            return 1;
        }
    }

    public static final class h
    extends e {
        @Override
        public final String whichCommand(ShellControl shellControl, String string) {
            boolean bl = shellControl.view().getCachedPredicate("commandExecutablePresent", () -> shellControl.view().fileExists(FilePath.of((String)"/usr/bin/command")));
            if (bl) {
                return String.format("/usr/bin/command -v %s", this.fileArgument(string));
            }
            return String.format("command -v %s", this.fileArgument(string));
        }

        @Override
        public final FilePath getInitFileName(ShellControl shellControl, int n2) {
            shellControl = ShellTemp.getSubDirectory((ShellControl)shellControl, (String[])new String[]{String.valueOf(n2), "zsh"});
            return shellControl.join(new String[]{".zshrc"});
        }

        @Override
        public final String prepareScriptContent(ShellControl shellControl, String string) {
            return "#!/usr/bin/env " + this.getExecutableName() + "\n" + this.unsetEnvironmentVariableCommand("ZDOTDIR") + "\n" + string + "\n";
        }

        @Override
        public final ShellDumbMode getDumbMode() {
            ShellDumbMode shellDumbMode = super.getDumbMode();
            return new ShellDumbMode(){
                private /* synthetic */ ShellDumbMode bw;
                {
                    this.bw = shellDumbMode;
                    Objects.requireNonNull(h2);
                }

                public final void prepareImmediateDumbInit(ShellControl shellControl) {
                    this.bw.prepareImmediateDumbInit(shellControl);
                }

                public final void prepareDumbInit(ShellControl shellControl) {
                    this.bw.prepareInlineShellSwitch(shellControl);
                    shellControl.writeLine("test -f ~/.zshrc && . ~/.zshrc");
                    shellControl.writeLine("zmodload -u zsh/stat");
                    if (shellControl.isLocal() && shellControl.getOsType() == OsType.MACOS) {
                        shellControl.writeLine("eval $(/opt/homebrew/bin/brew shellenv)");
                    }
                }
            };
        }

        @Override
        public final String getId() {
            return "zsh";
        }

        @Override
        protected final String readKeyCommand() {
            return "read -rsk;PROMPT_KEY=\"$REPLY\"";
        }

        @Override
        public final List<String> getDefaultInitFiles(ShellControl shellControl) {
            return List.of("~/.zshenv", "/etc/zprofile", "~/.zprofile", "~/.zshrc", "~/.zlogin");
        }

        public final String getExecutableName() {
            return "zsh";
        }

        public final String queryVersion(ShellControl shellControl) {
            return shellControl.command("echo \"zsh v$ZSH_VERSION\"").readStdoutOrThrow();
        }

        public final String getPauseCommand() {
            return String.format("echo \"%s\"; read -sk", e.PAUSE_PROMPT);
        }

        public final String terminalInitCommand(ShellControl shellControl, String object, boolean bl) {
            object = FilePath.of((String)object).getParent();
            object = "POWERLEVEL9K_INSTANT_PROMPT=off DISABLE_AUTO_UPDATE=true ZSH_DISABLE_COMPFIX=true ZDOTDIR=" + String.valueOf(object) + " zsh";
            shellControl = ScriptHelper.createExecScript((ShellDialect)ShellDialects.SH, (ShellControl)shellControl, (String)object);
            return "sh " + String.valueOf(shellControl);
        }

        public final String getDisplayName() {
            return "zsh";
        }

        @Generated
        public h() {
        }

        @Generated
        public final String toString() {
            return "PosixDialect.Zsh()";
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof h)) {
                return false;
            }
            return ((h)(object = (h)object)).d(this);
        }

        @Generated
        protected final boolean d(Object object) {
            return object instanceof h;
        }

        @Generated
        public final int hashCode() {
            return 1;
        }
    }

    public static final class b
    extends e {
        @Override
        public final String getId() {
            return "bash";
        }

        @Override
        protected final String readKeyCommand() {
            return "read -rs -n 1 PROMPT_KEY";
        }

        @Override
        public final List<String> getDefaultInitFiles(ShellControl shellControl) {
            FilePath filePath = shellControl.view().userHome();
            ArrayList<String> arrayList = new ArrayList<String>(List.of("/etc/profile", "~/.bashrc"));
            boolean bl = shellControl.view().fileExists(filePath.join(new String[]{".bash_profile"}));
            if (bl) {
                arrayList.add(1, "~/.bash_profile");
            } else {
                boolean bl2 = shellControl.view().fileExists(filePath.join(new String[]{".bash_login"}));
                if (bl2) {
                    arrayList.add(1, "~/.bash_login");
                } else {
                    arrayList.add(1, "~/.profile");
                }
            }
            return arrayList;
        }

        public final String getExecutableName() {
            return "bash";
        }

        public final String queryVersion(ShellControl shellControl) {
            return shellControl.command("echo \"bash v${BASH_VERSINFO[0]}.${BASH_VERSINFO[1]}.${BASH_VERSINFO[2]}\"").readStdoutOrThrow();
        }

        public final String getPauseCommand() {
            return String.format("read -rsp \"%s\" -n 1 key", e.PAUSE_PROMPT);
        }

        public final String terminalInitCommand(ShellControl shellControl, String string, boolean bl) {
            return "bash --rcfile " + string;
        }

        public final String getDisplayName() {
            return "bash";
        }

        @Generated
        public b() {
        }

        @Generated
        public final String toString() {
            return "PosixDialect.Bash()";
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof b)) {
                return false;
            }
            return ((b)(object = (b)object)).c(this);
        }

        @Generated
        protected final boolean c(Object object) {
            return object instanceof b;
        }

        @Generated
        public final int hashCode() {
            return 1;
        }
    }

    public static final class c
    extends g {
        @Override
        public final String executeCommandWithShell(String string) {
            return "sh" + String.format(" -c %s", this.fileArgument(string));
        }

        @Override
        public final ShellDumbMode getDumbMode() {
            return new ShellDumbMode(this){
                {
                    Objects.requireNonNull(c2);
                }

                public final void prepareInlineShellSwitch(ShellControl shellControl) {
                    ThreadHelper.sleep((long)500L);
                    shellControl.writeLine("setenv TERM dumb");
                    ThreadHelper.sleep((long)500L);
                    shellControl.writeLine("sh; exit");
                    ThreadHelper.sleep((long)500L);
                }

                public final void prepareDumbExit(ShellControl shellControl) {
                    shellControl.writeLine("exit");
                    ThreadHelper.sleep((long)500L);
                    shellControl.closeStdin();
                }
            };
        }

        @Override
        public final String prepareScriptContent(ShellControl shellControl, String string) {
            if (string.contains("askpass") || string.contains("SUDO_ASKPASS")) {
                return "#!/usr/bin/env sh\n" + this.unsetEnvironmentVariableCommand("ENV") + "\n" + string + "\n";
            }
            return "#!/usr/bin/env " + ((g)this).getExecutableName() + "\nsetenv ENV ''\n" + string + "\n";
        }

        @Override
        public final String getId() {
            return "csh";
        }

        @Override
        public final String getExecutableName() {
            return "csh";
        }

        @Override
        public final String terminalInitCommand(ShellControl shellControl, String object, boolean bl) {
            object = "ENV=" + (String)object + " sh";
            shellControl = ScriptHelper.createExecScript((ShellDialect)ShellDialects.SH, (ShellControl)shellControl, (String)object);
            return "sh " + shellControl.toString();
        }

        @Override
        public final String getDisplayName() {
            return "csh";
        }

        @Generated
        public c() {
        }

        @Override
        @Generated
        public final String toString() {
            return "PosixDialect.Csh()";
        }

        @Override
        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof c)) {
                return false;
            }
            return ((c)(object = (c)object)).canEqual(this);
        }

        @Override
        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof c;
        }

        @Override
        @Generated
        public final int hashCode() {
            return 1;
        }
    }

    public static final class d
    extends g {
        @Override
        public final String getId() {
            return "dash";
        }

        @Override
        public final String getExecutableName() {
            return "dash";
        }

        @Override
        public final String getDisplayName() {
            return "dash";
        }

        @Generated
        public d() {
        }

        @Override
        @Generated
        public final String toString() {
            return "PosixDialect.Dash()";
        }

        @Override
        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof d)) {
                return false;
            }
            return ((d)(object = (d)object)).canEqual(this);
        }

        @Override
        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof d;
        }

        @Override
        @Generated
        public final int hashCode() {
            return 1;
        }
    }

    public static final class a
    extends g {
        @Override
        public final String getId() {
            return "ash";
        }

        @Override
        public final String getExecutableName() {
            return "ash";
        }

        @Override
        public final String getDisplayName() {
            return "ash";
        }

        @Generated
        public a() {
        }

        @Override
        @Generated
        public final String toString() {
            return "PosixDialect.Ash()";
        }

        @Override
        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            return ((a)(object = (a)object)).canEqual(this);
        }

        @Override
        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof a;
        }

        @Override
        @Generated
        public final int hashCode() {
            return 1;
        }
    }

    public static final class e
    extends g {
        @Override
        public final String getId() {
            return "opnsense";
        }

        @Override
        public final String getExecutableName() {
            return "opnsense-shell";
        }

        @Override
        public final String getDisplayName() {
            return "opnsense";
        }

        @Override
        public final ShellDumbMode getDumbMode() {
            return new ShellDumbMode(this){
                {
                    Objects.requireNonNull(e2);
                }

                public final void prepareInlineShellSwitch(ShellControl shellControl) {
                    shellControl.writeLine("8");
                    ThreadHelper.sleep((long)500L);
                    shellControl.writeLine("export TERM=dumb");
                    ThreadHelper.sleep((long)500L);
                    shellControl.writeLine("sh; exit");
                    ThreadHelper.sleep((long)500L);
                }

                public final void prepareDumbExit(ShellControl shellControl) {
                    shellControl.writeLine("exit");
                    ThreadHelper.sleep((long)500L);
                    shellControl.writeLine("0");
                }
            };
        }

        @Generated
        public e() {
        }

        @Override
        @Generated
        public final String toString() {
            return "PosixDialect.Opnsense()";
        }

        @Override
        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof e)) {
                return false;
            }
            return ((e)(object = (e)object)).canEqual(this);
        }

        @Override
        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof e;
        }

        @Override
        @Generated
        public final int hashCode() {
            return 1;
        }
    }

    public static final class f
    extends g {
        @Override
        public final ShellDumbMode getDumbMode() {
            return new ShellDumbMode(this){
                {
                    Objects.requireNonNull(f2);
                }

                public final void prepareInlineShellSwitch(ShellControl shellControl) {
                    shellControl.writeLine("8");
                    ThreadHelper.sleep((long)500L);
                    shellControl.writeLine("export TERM=dumb");
                    ThreadHelper.sleep((long)500L);
                    shellControl.writeLine("sh; exit");
                    ThreadHelper.sleep((long)500L);
                }

                public final void prepareDumbExit(ShellControl shellControl) {
                    shellControl.writeLine("exit");
                    ThreadHelper.sleep((long)500L);
                    shellControl.writeLine("0");
                }
            };
        }

        @Override
        public final String getId() {
            return "pfsense";
        }

        @Override
        public final String getExecutableName() {
            return "pfsense-shell";
        }

        @Override
        public final String getDisplayName() {
            return "pfSense";
        }

        @Generated
        public f() {
        }

        @Override
        @Generated
        public final String toString() {
            return "PosixDialect.PfSense()";
        }

        @Override
        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof f)) {
                return false;
            }
            return ((f)(object = (f)object)).canEqual(this);
        }

        @Override
        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof f;
        }

        @Override
        @Generated
        public final int hashCode() {
            return 1;
        }
    }
}

