/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.docker;

import com.fasterxml.jackson.databind.JsonNode;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.CommandView;
import io.xpipe.app.process.CommandViewBase;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.core.FilePath;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.docker.f;
import io.xpipe.ext.proc.docker.h;
import io.xpipe.ext.proc.docker.t;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class c
extends CommandViewBase {
    public c(ShellControl shellControl) {
        super(shellControl);
    }

    private static String f(String string) {
        return string.replaceAll("%2F", "");
    }

    private static <T extends Throwable> T b(T t2) {
        return (T)ErrorEventFactory.expectedIfContains(t2, (String[])new String[]{"No such container:", "is the docker daemon running?", "this error may indicate that the docker daemon is not running", "the docker client must be run with elevated privileges to connect", "is not running", "OCI runtime exec failed"});
    }

    private static ElevationFunction G(String string) {
        return ElevationFunction.cached((String)"dockerRequiresElevation", (ElevationFunction)new ElevationFunction(string){
            private /* synthetic */ String bI;
            {
                this.bI = string;
            }

            public final String getPrefix() {
                return "docker";
            }

            public final boolean isSpecified() {
                return true;
            }

            public final boolean apply(ShellControl shellControl) {
                if (shellControl.getOsType() == OsType.WINDOWS) {
                    return false;
                }
                CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"docker"});
                if (this.bI != null) {
                    commandBuilder.add(new String[]{"--context"}).addQuoted(this.bI);
                }
                commandBuilder.add(new String[]{"version"});
                return !shellControl.command(commandBuilder).executeAndCheck();
            }
        });
    }

    public c ay() {
        this.shellControl.start();
        return this;
    }

    protected CommandControl build(Consumer<CommandBuilder> consumer) {
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"docker"});
        consumer.accept(commandBuilder);
        return this.shellControl.command(commandBuilder).withErrorFormatter(c::f).withExceptionConverter(c::b);
    }

    public boolean R() {
        return this.shellControl.command("docker --help").withErrorFormatter(c::f).withExceptionConverter(c::b).executeAndCheck();
    }

    public String ab() {
        return this.build(commandBuilder -> commandBuilder.add(new String[]{"--version"})).readStdoutOrThrow().replace("version ", "v").replaceAll(",.+", "");
    }

    public e H(String string) {
        return new e(this, string);
    }

    public c I(String string) {
        return new c(this, string);
    }

    public a J(String string) {
        return new a(this, string);
    }

    public b a(String string, List<FilePath> list) {
        return new b(this, string, list);
    }

    public d az() {
        return new d(this);
    }

    public /* synthetic */ CommandView start() {
        return this.ay();
    }

    public final class e
    extends CommandView {
        private final String bW;
        private /* synthetic */ c bK;

        public e(c c2, String string) {
            c c3 = c2;
            Objects.requireNonNull(c3);
            this.bK = c3;
            this.bW = string;
        }

        protected final CommandControl build(Consumer<CommandBuilder> consumer) {
            return this.bK.build(commandBuilder -> {
                commandBuilder.add(new String[]{"--context"}).addQuoted(this.bW);
                consumer.accept((CommandBuilder)commandBuilder);
            }).elevated(c.G(this.bW));
        }

        protected final ShellControl getShellControl() {
            return this.bK.getShellControl();
        }

        public final e aX() {
            this.bK.shellControl.start();
            return this;
        }

        public final String aY() {
            AtomicReference<String> atomicReference = new AtomicReference<String>();
            AtomicReference<String> atomicReference2 = new AtomicReference<String>();
            try (CommandControl commandControl = this.build(commandBuilder -> commandBuilder.add(new String[]{"version"})).start();){
                String[] stringArray = commandControl.readStdoutAndStderr();
                atomicReference.set(stringArray[0]);
                atomicReference2.set(stringArray[1]);
                long l2 = commandControl.getExitCode();
                if (l2 != 0L) {
                    throw ProcessOutputException.of((String)commandControl.getDisplayCommand(), (long)l2, (String[])new String[]{(String)atomicReference2.get()});
                }
            }
            return (String)atomicReference.get();
        }

        public final /* synthetic */ CommandView start() {
            return this.aX();
        }
    }

    public class c
    extends CommandView {
        private final String bQ;
        private /* synthetic */ c bK;

        public c(c c2, String string) {
            c c3 = c2;
            Objects.requireNonNull(c3);
            this.bK = c3;
            this.bQ = string;
        }

        protected CommandControl build(Consumer<CommandBuilder> consumer) {
            return this.bK.build(commandBuilder -> {
                commandBuilder.add(new String[]{"--context"}).addQuoted(this.bQ);
                commandBuilder.add(new String[]{"container"});
                consumer.accept((CommandBuilder)commandBuilder);
            }).elevated(c.G(this.bQ));
        }

        protected ShellControl getShellControl() {
            return this.bK.getShellControl();
        }

        public c aN() {
            this.bK.shellControl.start();
            return this;
        }

        public Optional<String> d(String string2, String string3) {
            string2 = this.build(commandBuilder -> commandBuilder.add(new String[]{"inspect"}).add(object -> {
                object = ShellDialects.isPowershell((ShellControl)object) ? "'" : "\"";
                return "--format=" + (String)object + "{{index (index .Config.Labels \\\"" + string3 + "\\\")}}" + (String)object;
            }).addQuoted(string2));
            return string2.readStdoutIfPossible().filter(string -> !string.isBlank());
        }

        public List<a> aO() {
            List<a> list;
            block10: {
                ProcessOutputException processOutputException = this.build(commandBuilder -> commandBuilder.add(new String[]{"ls -a --format=\"{{.Names}};{{.Image}};{{.Status}}\""})).start();
                try {
                    String string2 = processOutputException.readStdoutOrThrow();
                    if (string2.contains("PROTECTION MODE ENABLED!")) {
                        throw ProcessOutputException.of((String)processOutputException.getDisplayCommand(), (long)1L, (String[])new String[]{string2});
                    }
                    list = string2.lines().filter(string -> string.split(";").length == 3).map(string -> new a(string.split(";")[0], string.split(";")[1], string.split(";")[2])).filter(a2 -> !a2.aP().isBlank()).toList();
                    if (processOutputException == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (processOutputException != null) {
                            try {
                                processOutputException.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProcessOutputException processOutputException2) {
                        processOutputException = processOutputException2;
                        if (processOutputException2.getOutput().contains("unknown flag: --format")) {
                            throw (ProcessOutputException)ErrorEventFactory.expected((Throwable)ProcessOutputException.withPrefix((String)"Unsupported legacy docker version", (ProcessOutputException)processOutputException));
                        }
                        throw processOutputException;
                    }
                }
                processOutputException.close();
            }
            return list;
        }

        public ShellControl O(String string) {
            ShellControl shellControl = this.bK.shellControl.subShell();
            shellControl.setDumbOpen((ShellOpenFunction)this.b(string, false));
            shellControl.setTerminalOpen((ShellOpenFunction)this.b(string, true));
            return shellControl.withExceptionConverter(c::b).elevated(c.G(this.bQ));
        }

        private 1 b(String string, boolean bl) {
            return new ShellOpenFunction(){
                private /* synthetic */ boolean aH;
                private /* synthetic */ String aG;
                private /* synthetic */ c bR;
                {
                    this.aH = bl;
                    this.aG = string;
                    c c3 = c2;
                    Objects.requireNonNull(c3);
                    this.bR = c3;
                }

                public final CommandBuilder prepareWithoutInitCommand() {
                    1 v0 = this;
                    return this.bR.a(this.aH).addQuoted(this.aG).add(shellControl -> {
                        boolean bl;
                        if (shellControl.getOsType() == OsType.WINDOWS && (bl = this.bR.S(v0.aG).contains("\"Platform\": \"windows\""))) {
                            return ShellDialects.CMD.getLaunchCommand().loginCommand();
                        }
                        return c.P(v0.aG);
                    });
                }

                public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                    if (string == null) {
                        throw new NullPointerException("command is marked non-null but is null");
                    }
                    return this.bR.a(this.aH).addQuoted(this.aG).add(new String[]{string});
                }
            };
        }

        private static String P(String string) {
            if (string.contains("gitea")) {
                return "sh";
            }
            return ShellDialects.SH.getLaunchCommand().loginCommand();
        }

        public CommandBuilder a(boolean bl) {
            return CommandBuilder.of().add(new String[]{"docker", "container", "exec", bl ? "-it" : "-i"});
        }

        public void g(String string) {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"start"}).addQuoted(string)).execute();
        }

        public void h(String string) {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"stop"}).addQuoted(string)).execute();
        }

        public void Q(String string) {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"pause"}).addQuoted(string)).execute();
        }

        public void R(String string) {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"unpause"}).addQuoted(string)).execute();
        }

        public String K(String string) {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"ls", "-a", "-f", "name=\"^" + string + "$\"", "--format=\"{{.Status}}\""})).readStdoutOrThrow();
        }

        public String S(String string) {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"inspect"}).addQuoted(string)).readStdoutOrThrow();
        }

        public String T(String string) {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"port"}).addQuoted(string)).readStdoutOrThrow();
        }

        public CommandControl U(String string) {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"attach"}).addQuoted(string));
        }

        public CommandControl j(String string) {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"logs"}).add(new String[]{"-f"}).addQuoted(string));
        }

        public /* synthetic */ CommandView start() {
            return this.aN();
        }

        public static final class a {
            private final String bS;
            private final String bT;
            private final String bU;

            @Generated
            public a(String string, String string2, String string3) {
                this.bS = string;
                this.bT = string2;
                this.bU = string3;
            }

            @Generated
            public final String aP() {
                return this.bS;
            }

            @Generated
            public final String aQ() {
                return this.bT;
            }

            @Generated
            public final String aR() {
                return this.bU;
            }

            @Generated
            public final boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof a)) {
                    return false;
                }
                object = (a)object;
                String string = this.aP();
                String string2 = ((a)object).aP();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return false;
                }
                string = this.aQ();
                string2 = ((a)object).aQ();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return false;
                }
                string = this.aR();
                object = ((a)object).aR();
                return !(string == null ? object != null : !string.equals(object));
            }

            @Generated
            public final int hashCode() {
                String string = this.aP();
                int n2 = 59 + (string == null ? 43 : string.hashCode());
                String string2 = this.aQ();
                n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
                string2 = this.aR();
                n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
                return n2;
            }

            @Generated
            public final String toString() {
                return "DockerCommandView.Container.ContainerEntry(name=" + this.aP() + ", image=" + this.aQ() + ", status=" + this.aR() + ")";
            }
        }
    }

    public final class io.xpipe.ext.proc.docker.c$a
    extends CommandView {
        private final String bJ;
        private /* synthetic */ c bK;

        public io.xpipe.ext.proc.docker.c$a(c c2, String string) {
            c c3 = c2;
            Objects.requireNonNull(c3);
            this.bK = c3;
            this.bJ = string;
        }

        protected final CommandControl build(Consumer<CommandBuilder> consumer) {
            return this.bK.build(commandBuilder -> {
                commandBuilder.add(new String[]{"--context"}).addQuoted(this.bJ);
                commandBuilder.add(new String[]{"compose"});
                consumer.accept((CommandBuilder)commandBuilder);
            }).elevated(c.G(this.bJ));
        }

        protected final ShellControl getShellControl() {
            return this.bK.getShellControl();
        }

        public final io.xpipe.ext.proc.docker.c$a aA() {
            this.bK.shellControl.start();
            return this;
        }

        public final List<a> e(DataStoreEntryRef<t> dataStoreEntryRef) {
            Object object;
            block13: {
                f.a a2 = null;
                ProcessOutputException processOutputException = this.build(commandBuilder -> commandBuilder.add(new String[]{"ls", "-a", "--format", "json"})).start();
                try {
                    Object object2 = processOutputException.readStdoutOrThrow();
                    JsonNode jsonNode = JacksonMapper.getDefault().readTree((String)object2);
                    object2 = new ArrayList();
                    for (int i2 = 0; i2 < jsonNode.size(); ++i2) {
                        Object object3 = jsonNode.get(i2);
                        String string2 = object3.required("Name").asText();
                        String string3 = object3.required("Status").asText();
                        object3 = object3.has("ConfigFiles") ? object3.required("ConfigFiles").asText() : "";
                        object3 = Arrays.stream(((String)object3).split(",")).map(string -> string.strip()).map(string -> {
                            if (string.isEmpty()) {
                                return "docker-compose.yml";
                            }
                            return string;
                        }).toList();
                        boolean bl = (object3 = object3.stream().map(FilePath::of).toList()).stream().anyMatch(filePath -> !filePath.isAbsolute());
                        if (bl) {
                            if (a2 == null) {
                                a2 = f.f(dataStoreEntryRef);
                            }
                            c.a a3 = null;
                            for (c.a a4 : a2.aZ()) {
                                String string4 = a2.ba().get(a4);
                                if (string4 == null || !string4.equals(string2) || (a4 = a2.bb().get(a4)) == null) continue;
                                a3 = a4;
                                break;
                            }
                            if (a3 == null) continue;
                            Iterator<c.a> iterator = a3;
                            object3 = object3.stream().map(filePath2 -> {
                                if (filePath2.isAbsolute()) {
                                    return filePath2;
                                }
                                return iterator.join(new String[]{filePath2.toString()});
                            }).toList();
                        }
                        boolean bl2 = this.bK.shellControl.getOsType() == OsType.WINDOWS && ((FilePath)object3.getFirst()).startsWith("/");
                        boolean bl3 = object3.stream().anyMatch(filePath -> filePath.startsWith("/data/"));
                        ((ArrayList)object2).add(new a(string2, string3, (List<FilePath>)object3, bl3 ? h.PORTAINER : (bl2 ? h.WSL : null)));
                    }
                    object = object2;
                    if (processOutputException == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (processOutputException != null) {
                            try {
                                processOutputException.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProcessOutputException processOutputException2) {
                        processOutputException = processOutputException2;
                        if (processOutputException2.getOutput().contains("docker: 'compose' is not a docker command.") || processOutputException.getOutput().contains("unknown shorthand flag: 'a' in -a") || processOutputException.getOutput().contains("unknown docker command: \"compose compose\"")) {
                            return List.of();
                        }
                        throw processOutputException;
                    }
                }
                processOutputException.close();
            }
            return object;
        }

        public final String K(String string) {
            string = this.build(commandBuilder -> commandBuilder.add(new String[]{"ls", "-a", "--filter", "name=\"^" + string + "$\"", "--format=json"})).readStdoutOrThrow();
            string = JacksonMapper.getDefault().readTree(string);
            if (!string.isArray() || string.size() != 1) {
                return null;
            }
            return string.get(0).required("Status").asText();
        }

        public final /* synthetic */ CommandView start() {
            return this.aA();
        }

        public static final class a {
            private final String bL;
            private final String status;
            private final List<FilePath> configFiles;
            private final h restriction;

            @Generated
            public a(String string, String string2, List<FilePath> list, h h2) {
                this.bL = string;
                this.status = string2;
                this.configFiles = list;
                this.restriction = h2;
            }

            @Generated
            public final String aB() {
                return this.bL;
            }

            @Generated
            public final String getStatus() {
                return this.status;
            }

            @Generated
            public final List<FilePath> aC() {
                return this.configFiles;
            }

            @Generated
            public final h aD() {
                return this.restriction;
            }

            @Generated
            public final boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof a)) {
                    return false;
                }
                object = (a)object;
                Object object2 = this.aB();
                Object object3 = ((a)object).aB();
                if (object2 == null ? object3 != null : !object2.equals(object3)) {
                    return false;
                }
                object2 = this.getStatus();
                object3 = ((a)object).getStatus();
                if (object2 == null ? object3 != null : !object2.equals(object3)) {
                    return false;
                }
                object2 = this.aC();
                object3 = ((a)object).aC();
                if (object2 == null ? object3 != null : !object2.equals(object3)) {
                    return false;
                }
                object2 = this.aD();
                object = ((a)object).aD();
                return !(object2 == null ? object != null : !object2.equals(object));
            }

            @Generated
            public final int hashCode() {
                String string = this.aB();
                int n2 = 59 + (string == null ? 43 : string.hashCode());
                Object object = this.getStatus();
                n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
                object = this.aC();
                n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
                object = this.aD();
                n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
                return n2;
            }

            @Generated
            public final String toString() {
                return "DockerCommandView.Compose.ComposeProjectEntry(name=" + this.aB() + ", status=" + this.getStatus() + ", configFiles=" + String.valueOf(this.aC()) + ", restriction=" + String.valueOf((Object)this.aD()) + ")";
            }
        }
    }

    public final class b
    extends CommandView {
        private final String bM;
        private final List<FilePath> bN;
        private /* synthetic */ c bK;

        public b(c c2, String string, List<FilePath> list) {
            c c3 = c2;
            Objects.requireNonNull(c3);
            this.bK = c3;
            this.bM = string;
            this.bN = list;
        }

        public final List<a> a(List<a.a> object) {
            if (((Optional)(object = object.stream().filter(a2 -> a2.aC().equals(this.bN)).findFirst())).isEmpty()) {
                return this.aF();
            }
            Object object2 = this.aG();
            Pattern pattern = Pattern.compile("^name: (.+)$", 8);
            object2 = pattern.matcher((CharSequence)object2);
            if (((Matcher)object2).find() && !((String)(object2 = ((Matcher)object2).group(1))).equals(((a.a)((Optional)object).get()).aB())) {
                return this.N(((a.a)((Optional)object).get()).aB());
            }
            return this.aF();
        }

        protected final CommandControl build(Consumer<CommandBuilder> consumer) {
            return this.bK.build(commandBuilder -> {
                commandBuilder.add(new String[]{"--context"}).addQuoted(this.bM);
                commandBuilder.add(new String[]{"compose"});
                for (FilePath filePath : this.bN) {
                    commandBuilder.add(new String[]{"-f"}).addFile(filePath);
                }
                consumer.accept((CommandBuilder)commandBuilder);
            }).elevated(c.G(this.bM));
        }

        protected final ShellControl getShellControl() {
            return this.bK.getShellControl();
        }

        public final b aE() {
            this.bK.shellControl.start();
            return this;
        }

        public final List<a> aF() {
            try (CommandControl commandControl = this.build(commandBuilder -> commandBuilder.add(new String[]{"ps", "-a", "--format", "json"})).start();){
                ArrayList<a> arrayList = commandControl.readStdoutOrThrow();
                if (!((String)((Object)arrayList)).startsWith("[")) {
                    arrayList = "[" + ((String)((Object)arrayList)).lines().collect(Collectors.joining(",")) + "]";
                }
                JsonNode jsonNode = JacksonMapper.getDefault().readTree((String)((Object)arrayList));
                arrayList = new ArrayList<a>();
                for (int i2 = 0; i2 < jsonNode.size(); ++i2) {
                    Object object = jsonNode.get(i2);
                    String string = object.required("Name").asText();
                    object = (object = object.get("Status")) != null ? object.asText() : null;
                    arrayList.add(new a(string, (String)object));
                }
                ArrayList<a> arrayList2 = arrayList;
                return arrayList2;
            }
        }

        public final List<a> N(String string) {
            ArrayList<a> arrayList = new ArrayList<a>();
            Object object = new c(this.bK.shellControl).I(this.bM).aO();
            object = object.iterator();
            while (object.hasNext()) {
                c.a a2 = (c.a)object.next();
                Optional<String> optional = this.bK.I(this.bM).d(a2.aP(), "com.docker.compose.project");
                if (optional.isEmpty() || !optional.get().equals(string)) continue;
                arrayList.add(new a(a2.aP(), a2.aR()));
            }
            return arrayList;
        }

        public final String aG() {
            CommandControl commandControl = this.build(commandBuilder -> commandBuilder.add(new String[]{"config"}));
            return commandControl.readStdoutOrThrow();
        }

        public final void aH() {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"unpause"})).executeAndCheck();
            this.build(commandBuilder -> commandBuilder.add(new String[]{"start"})).execute();
        }

        public final void aI() {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"stop"})).execute();
        }

        public final void aJ() {
            this.build(commandBuilder -> commandBuilder.add(new String[]{"pause"})).execute();
        }

        public final CommandControl aK() {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"logs", "-f"}));
        }

        public final /* synthetic */ CommandView start() {
            return this.aE();
        }

        public static final class a {
            private final String bO;
            private final String bP;

            @Generated
            public a(String string, String string2) {
                this.bO = string;
                this.bP = string2;
            }

            @Generated
            public final String aL() {
                return this.bO;
            }

            @Generated
            public final String aM() {
                return this.bP;
            }

            @Generated
            public final boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof a)) {
                    return false;
                }
                object = (a)object;
                String string = this.aL();
                String string2 = ((a)object).aL();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return false;
                }
                string = this.aM();
                object = ((a)object).aM();
                return !(string == null ? object != null : !string.equals(object));
            }

            @Generated
            public final int hashCode() {
                String string = this.aL();
                int n2 = 59 + (string == null ? 43 : string.hashCode());
                String string2 = this.aM();
                n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
                return n2;
            }

            @Generated
            public final String toString() {
                return "DockerCommandView.ComposeProject.Service(name=" + this.aL() + ", status=" + this.aM() + ")";
            }
        }
    }

    public final class d
    extends CommandView {
        private /* synthetic */ c bK;

        public d(c c2) {
            c c3 = c2;
            Objects.requireNonNull(c3);
            this.bK = c3;
        }

        public final String Y(String string) {
            return this.build(commandBuilder -> commandBuilder.add(new String[]{"inspect"}).addQuoted(string)).readStdoutOrThrow();
        }

        protected final CommandControl build(Consumer<CommandBuilder> consumer) {
            return this.bK.build(commandBuilder -> {
                commandBuilder.add(new String[]{"context"});
                consumer.accept((CommandBuilder)commandBuilder);
            }).elevated(c.G(null));
        }

        protected final ShellControl getShellControl() {
            return this.bK.getShellControl();
        }

        public final d aS() {
            this.bK.shellControl.start();
            return this;
        }

        public final List<a> aT() {
            Object object2 = this.build(commandBuilder -> commandBuilder.add(new String[]{"ls", "--format=\"{{.Name}};{{.Description}};{{.Current}}\""}));
            object2 = object2.readStdoutOrThrow();
            ArrayList<a> arrayList = new ArrayList<a>();
            ((String)object2).lines().forEach(object -> {
                if (((String[])(object = object.split(";"))).length != 3) {
                    return;
                }
                boolean bl = "true".equals(object[2]);
                String string = object[0];
                object = object[1];
                object = object.replace("DOCKER_HOST based ", "");
                arrayList.add(new a(string, (String)object, bl));
            });
            return arrayList;
        }

        public final /* synthetic */ CommandView start() {
            return this.aS();
        }

        public static final class a {
            private final String bV;
            private final String description;
            private final boolean current;

            @Generated
            public a(String string, String string2, boolean bl) {
                this.bV = string;
                this.description = string2;
                this.current = bl;
            }

            @Generated
            public final String aU() {
                return this.bV;
            }

            @Generated
            public final String aV() {
                return this.description;
            }

            @Generated
            public final boolean aW() {
                return this.current;
            }

            @Generated
            public final boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof a)) {
                    return false;
                }
                object = (a)object;
                if (this.aW() != ((a)object).aW()) {
                    return false;
                }
                String string = this.aU();
                String string2 = ((a)object).aU();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return false;
                }
                string = this.aV();
                object = ((a)object).aV();
                return !(string == null ? object != null : !string.equals(object));
            }

            @Generated
            public final int hashCode() {
                int n2 = 59 + (this.aW() ? 79 : 97);
                String string = this.aU();
                n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
                string = this.aV();
                n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
                return n2;
            }

            @Generated
            public final String toString() {
                return "DockerCommandView.Context.ContextEntry(name=" + this.aU() + ", description=" + this.aV() + ", current=" + this.aW() + ")";
            }
        }
    }
}

