/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.git;

import com.fasterxml.jackson.databind.JsonNode;
import io.xpipe.app.core.AppCache;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.AppLayoutModel;
import io.xpipe.app.core.AppResources;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.core.mode.AppOperationMode;
import io.xpipe.app.core.window.AppDialog;
import io.xpipe.app.core.window.AppMainWindow;
import io.xpipe.app.ext.PrefsProvider;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.issue.ErrorAction;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.platform.PlatformInit;
import io.xpipe.app.platform.PlatformThread;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.prefs.SyncMode;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandSupport;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ProcessControl;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.WorkingDirectoryFunction;
import io.xpipe.app.secret.EncryptionToken;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStorageSecret;
import io.xpipe.app.storage.DataStorageSyncHandler;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.StorageElement;
import io.xpipe.app.terminal.TerminalLaunch;
import io.xpipe.app.util.AsktextAlert;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.Hyperlinks;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.FailableRunnable;
import io.xpipe.core.FailableSupplier;
import io.xpipe.core.FilePath;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.g;
import io.xpipe.ext.proc.git.a;
import io.xpipe.ext.proc.git.b;
import io.xpipe.ext.proc.git.d;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.apache.commons.io.FileUtils;

public final class c
implements DataStorageSyncHandler {
    private final Set<DataStoreEntry> cG = new HashSet<DataStoreEntry>();
    private final Set<DataStoreEntry> cH = new HashSet<DataStoreEntry>();
    private final Set<DataStoreCategory> cI = new HashSet<DataStoreCategory>();
    private final Set<DataStoreCategory> cJ = new HashSet<DataStoreCategory>();
    private final Map<Path, DataStorageSecret> cK = new HashMap<Path, DataStorageSecret>();
    private final AppLayoutModel.QueueEntry cL;
    private String cM;
    private boolean cN;
    private boolean cO;
    private boolean cP;
    private ShellControl cQ;
    private Path cR;
    private boolean enabled;
    private String cS;
    private b cT;
    private boolean cU;
    private boolean cV;
    private String cW;
    private boolean cX;
    private boolean cY;
    private boolean cZ;
    private UUID da;
    private final SyncMode db;

    public c() {
        AppLayoutModel.QueueEntry queueEntry;
        this.cL = queueEntry = new AppLayoutModel.QueueEntry(AppI18n.observable((String)"gitSyncPull", (Object[])new Object[0]), (LabelGraphic)new LabelGraphic.IconGraphic("mdi2s-source-branch-refresh"), () -> Boolean.TRUE);
        this.cN = false;
        this.cO = false;
        this.cP = false;
        this.enabled = false;
        this.db = (SyncMode)AppPrefs.get().syncMode().getValue();
    }

    private void bg() {
        ObservableList observableList = AppLayoutModel.get().getQueueEntries();
        if (!observableList.contains((Object)this.cL)) {
            observableList.add((Object)this.cL);
        }
    }

    private void bh() {
        ObservableList observableList = AppLayoutModel.get().getQueueEntries();
        observableList.remove((Object)this.cL);
    }

    private void p(CommandBuilder commandBuilder) {
        this.cQ.command(commandBuilder).execute();
    }

    private void a(FailableRunnable<Exception> object) {
        try {
            object.run();
            return;
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return;
        }
    }

    private boolean q(CommandBuilder commandBuilder) {
        return this.cQ.command(commandBuilder).executeAndCheck();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean bi() {
        try {
            block14: {
                var1_1 /* !! */  = this;
                if (OsType.ofLocal() == OsType.MACOS) {
                    CommandSupport.isInPathOrThrow((ShellControl)var1_1 /* !! */ .cQ, (String)"git", (String)"Git command-line client", null);
                    try {
                        var1_1 /* !! */ .p(CommandBuilder.of().add(new String[]{"git"}));
                    }
                    catch (ProcessOutputException v0) {
                        var1_1 /* !! */  = v0;
                        if (!v0.getOutput().contains("xcode-select")) ** GOTO lbl16
                        throw (ProcessOutputException)ErrorEventFactory.expected((Throwable)ProcessOutputException.withPrefix((String)"Git command-line tools are not available but required. You can install them via one of these methods:\n- Run \"xcode-select --install\" to install Xcode command-line tools which include git\n- Run \"brew install git\" to install it via homebrew\n\nFor more details, see https://git-scm.com/download/mac.\n", (ProcessOutputException)var1_1 /* !! */ ));
                    }
                } else {
                    var1_2 = var1_1 /* !! */ .cQ.view().isInPath("git", false);
                    if (!var1_2) {
                        var1_3 = "Git command-line tools are not available in the PATH but are required to use git sync. For more details, see https://git-scm.com/downloads.";
                        throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException(var1_3));
                    }
                }
lbl16:
                // 4 sources

                if (OsType.ofLocal() == OsType.WINDOWS && (var1_5 = (var1_4 = CommandBuilder.of().add(new String[]{"git", "config", "--global", "--get-all"}).addQuoted("safe.directory").build(this.cQ).sensitive().readStdoutIfPossible()).isEmpty() != false || ((String)var1_4.get()).lines().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, am(java.lang.String ), (Ljava/lang/String;)Z)((c)this)) != false)) {
                    CommandBuilder.of().add(new String[]{"git", "config", "--global", "--add"}).addQuoted("safe.directory").addQuoted(this.cR.toString()).build(this.cQ).executeAndCheck();
                }
                if (!(var1_6 = Files.exists(this.cR.resolve(".git"), new LinkOption[0]))) {
                    this.p(CommandBuilder.of().add(new String[]{"git", "init"}));
                } else {
                    try {
                        Files.deleteIfExists(this.cR.resolve(".git").resolve("index.lock"));
                    }
                    catch (Exception v1) {
                        var1_7 = v1;
                        ErrorEventFactory.fromThrowable((Throwable)v1).omit().expected().handle();
                    }
                    try {
                        this.p(CommandBuilder.of().add(new String[]{"git", "reset"}));
                    }
                    catch (ProcessOutputException v2) {
                        var1_8 = v2;
                        if (!v2.getOutput().contains("fatal: index file corrupt")) break block14;
                        this.cQ.view().deleteFileIfPossible(FilePath.of((Path)this.cR).join(new String[]{".git", "index"}));
                        this.p(CommandBuilder.of().add(new String[]{"git", "reset"}));
                    }
                }
            }
            this.p(CommandBuilder.of().add(new String[]{"git", "config", "--local"}).addQuoted("pull.rebase").addQuoted("false"));
            this.p(CommandBuilder.of().add(new String[]{"git", "config", "--local"}).addQuoted("core.autocrlf").addQuoted("false"));
            return true;
        }
        catch (Exception v3) {
            var1_9 = v3;
            ErrorEventFactory.fromThrowable((Throwable)v3).handle();
            this.enabled = false;
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean bj() {
        if (this.cT == null) {
            return false;
        }
        c.d(this.cT);
        try {
            var1_1 = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "remote", "get-url"}).addQuoted("remote-storage")).readStdoutIfPossible();
            var2_4 = this.cT.be();
            if (var1_1.isEmpty() || !((String)var1_1.get()).equals(var2_4)) {
                this.q(CommandBuilder.of().add(new String[]{"git", "remote", "remove"}).addQuoted("remote-storage"));
                this.p(CommandBuilder.of().add(new String[]{"git", "remote", "add"}).addQuoted("remote-storage").addQuoted(var2_4));
            }
        }
        catch (Exception v0) {
            var1_2 = v0;
            ErrorEventFactory.fromThrowable((Throwable)v0).handle();
            this.enabled = false;
            return false;
        }
        if (this.bv()) {
            return true;
        }
        while (true) {
            try {
                this.cQ.command(a.a(this.cQ, CommandBuilder.of().add(new String[]{"git", "fetch", "remote-storage"}))).execute();
                return true;
            }
            catch (ProcessOutputException var1_3) {
                var2_4 = c.e(this.cT);
                var3_5 = new AtomicBoolean();
                var4_6 = new AtomicBoolean();
                var2_4 = ErrorEventFactory.fromThrowable((Throwable)ProcessOutputException.withSuffix((String)var2_4, (ProcessOutputException)var1_3));
                var5_7 = this.cT;
                if (!(var5_7 instanceof b.a)) ** GOTO lbl-1000
                var5_7 = (b.a)var5_7;
                if (var1_3.getOutput().contains("does not appear to be a git repository")) {
                    var5_7 = ErrorAction.translated((String)"gitRepoCreateBare", (FailableSupplier)(FailableSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, a(io.xpipe.ext.proc.git.b$a java.util.concurrent.atomic.AtomicBoolean ), ()Ljava/lang/Boolean;)((c)this, (b.a)var5_7, (AtomicBoolean)var3_5));
                    var2_4.customAction((ErrorAction)var5_7);
                    var1_1 = ErrorAction.translated((String)"gitRepoEnablePlain", (FailableSupplier)(FailableSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, g(java.util.concurrent.atomic.AtomicBoolean ), ()Ljava/lang/Boolean;)((c)this, (AtomicBoolean)var4_6));
                    var2_4.customAction((ErrorAction)var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    var5_7 = ErrorAction.translated((String)"gitRepoTryAgain", (FailableSupplier)(FailableSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, f(java.util.concurrent.atomic.AtomicBoolean ), ()Ljava/lang/Boolean;)((AtomicBoolean)var3_5));
                    var2_4.customAction((ErrorAction)var5_7);
                }
                var2_4.documentationLink(DocumentationLink.SYNC).expected().handle();
                if (!var4_6.get()) continue;
                return true;
                if (this.enabled && var3_5.get()) continue;
                this.enabled = false;
                return false;
            }
            catch (Exception v1) {
                var1_1 = v1;
                ErrorEventFactory.fromThrowable((Throwable)v1).handle();
                this.enabled = false;
                return false;
            }
            break;
        }
    }

    private static void d(b b2) {
        boolean bl = b2 instanceof b.c;
        SshIdentityStrategy sshIdentityStrategy = (SshIdentityStrategy)((g)PrefsProvider.get(g.class)).x().getValue();
        if (!bl && sshIdentityStrategy != null && !(sshIdentityStrategy instanceof NoIdentityStrategy)) {
            ErrorEventFactory.fromMessage((String)"You are using an HTTP git URL but have specified an SSH identity option for it. Are you using the correct URL type? Alternatively, remove the git SSH identity option.").expected().handle();
        }
    }

    private static String e(b object) {
        boolean bl = object instanceof b.c;
        String string = "- Your SSH identity setting is correct and functional";
        object = "Unable to fetch from remote repository %s\n\nPlease make sure that:\n- You have the correct repository URL\n- Your repository URL matches the rules regarding a .git suffix (Some remotes require a .git suffix, some require it to be omitted, others do not care)\n- Your configured git user has the necessary access right via credentials or a token\n- You have internet connectivity\n%s\n".formatted(((b)object).be(), bl ? string : "");
        return object;
    }

    private boolean bk() {
        try {
            if (!this.cP) {
                Path path = this.cR.resolve("README.md");
                Files.writeString(path, (CharSequence)"Waiting for push ...", new OpenOption[0]);
                this.a(path);
                this.e(path.getFileName().toString(), "Initial commit with");
            }
            this.p(CommandBuilder.of().add(new String[]{"git", "push", "--force", "-u", "remote-storage", "HEAD"}));
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return false;
        }
    }

    private static boolean ab(String string) {
        boolean bl = AppDialog.confirm((String)"gitVaultTitle", (ObservableValue)AppI18n.observable((String)("gitVault" + string + "Content"), (Object[])new Object[0]));
        return bl;
    }

    private boolean bl() {
        try {
            FileUtils.cleanDirectory((File)this.cR.toFile());
            FileUtils.forceMkdir((File)this.cR.resolve("data").toFile());
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return false;
        }
    }

    private boolean bm() {
        try {
            this.cQ.command(CommandBuilder.of().add(new String[]{"git", "reset", "--hard"}).addQuoted("remote-storage/" + this.cS)).execute();
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return false;
        }
    }

    private boolean b(boolean bl) {
        try {
            Optional optional;
            if (bl) {
                c c2 = this;
                c2.p(a.a(c2.cQ, CommandBuilder.of().add(new String[]{"git", "fetch", "--all"})));
            }
            if ((optional = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "rev-parse", "--abbrev-ref", "--symbolic-full-name"}).addQuoted("@{u}")).readStdoutIfPossible()).isEmpty()) {
                c c3 = this;
                boolean bl2 = c3.q(a.a(c3.cQ, CommandBuilder.of().add(new String[]{"git", "remote", "set-head"}).addQuoted("remote-storage").add(new String[]{"-a"})));
                if (bl2) {
                    String string = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "symbolic-ref", "--short", "refs/remotes/remote-storage/HEAD"})).readStdoutOrThrow();
                    this.cS = string.replace("remote-storage/", "");
                    bl2 = true;
                } else {
                    this.cS = "master";
                    bl2 = false;
                }
                this.q(CommandBuilder.of().add(new String[]{"git", "branch", "-u", "remote-storage/" + this.cS}));
                return bl2;
            }
            this.cS = ((String)optional.get()).replace("remote-storage/", "");
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return false;
        }
    }

    private void bn() {
        if (DataStorage.get() == null) {
            return;
        }
        Path path = ((b.a)this.cT).bf();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        boolean bl = !Files.exists(path.resolve("stores"), new LinkOption[0]) && !Files.exists(path.resolve("categories"), new LinkOption[0]);
        if (bl) {
            return;
        }
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            Object object3;
            Iterable<Object> iterable2;
            ArrayList arrayList;
            this.beforeStorageSave();
            try (Object object2 = Files.exists(path.resolve("stores"), new LinkOption[0]) ? Files.list(path.resolve("stores")) : Stream.empty();){
                arrayList = new ArrayList(object2.toList());
            }
            for (Iterable<Object> iterable2 : new ArrayList(arrayList)) {
                if (!FileUtils.isEmptyDirectory((File)iterable2.toFile())) continue;
                arrayList.remove(iterable2);
            }
            object2 = DataStorage.get().getStoreEntries().stream().filter(dataStoreEntry -> DataStorage.get().shouldSync(dataStoreEntry) && arrayList.stream().noneMatch(path -> path.getFileName().toString().equals(dataStoreEntry.getUuid().toString()))).toList();
            iterable2 = object2.iterator();
            while (iterable2.hasNext()) {
                object2 = (DataStoreEntry)iterable2.next();
                object2.deleteFromDisk();
                this.handleDeletion(object2.getDirectory(), object2.getName());
            }
            object2 = Files.exists(path.resolve("categories"), new LinkOption[0]) ? Files.list(path.resolve("categories")) : Stream.empty();
            try {
                iterable2 = new ArrayList(object2.toList());
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
            for (Object object3 : new ArrayList(iterable2)) {
                if (!FileUtils.isEmptyDirectory((File)object3.toFile())) continue;
                iterable2.remove(object3);
            }
            object2 = DataStorage.get().getStoreCategories().stream().filter(dataStoreCategory -> DataStorage.get().shouldSync(dataStoreCategory) && iterable2.stream().noneMatch(path -> path.getFileName().toString().equals(dataStoreCategory.getUuid().toString()))).toList();
            object3 = object2.iterator();
            while (object3.hasNext()) {
                object2 = (DataStoreCategory)object3.next();
                object2.deleteFromDisk();
                this.handleDeletion(object2.getDirectory(), object2.getName());
            }
            object3 = this.cR.resolve("data");
            FileUtils.deleteQuietly((File)object3.toFile());
            Files.createDirectories((Path)object3, new FileAttribute[0]);
            if (Files.exists(path.resolve("data"), new LinkOption[0])) {
                FileUtils.copyDirectoryToDirectory((File)path.resolve("data").toFile(), (File)this.cR.toFile());
                this.bu();
            }
            path = Files.list((Path)((Object)path));
            try {
                object2 = path.filter(path -> Files.isRegularFile(path, new LinkOption[0])).toList();
            }
            finally {
                if (path != null) {
                    path.close();
                }
            }
            path = object2.iterator();
            while (path.hasNext()) {
                object2 = (Path)path.next();
                FileUtils.copyToDirectory((File)object2.toFile(), (File)this.cR.toFile());
            }
            for (Object object2 : arrayList) {
                object3 = this.cR.resolve("stores");
                FileUtils.copyDirectoryToDirectory((File)object2.toFile(), (File)object3.toFile());
            }
            for (Object object2 : iterable2) {
                object3 = this.cR.resolve("categories");
                FileUtils.copyDirectoryToDirectory((File)object2.toFile(), (File)object3.toFile());
            }
            DataStorage.get().reloadContent();
            for (Object object2 : arrayList) {
                object3 = DataStorage.get().getStoreEntryIfPresent(UUID.fromString(object2.getFileName().toString()));
                if (!((Optional)object3).isPresent()) continue;
                this.handleEntry((DataStoreEntry)((Optional)object3).get(), true, false);
            }
            for (Object object2 : iterable2) {
                object3 = DataStorage.get().getStoreCategoryIfPresent(UUID.fromString(object2.getFileName().toString()));
                if (!((Optional)object3).isPresent()) continue;
                this.handleCategory((DataStoreCategory)((Optional)object3).get(), true, false);
            }
            this.da = this.bo().orElse(null);
            this.afterStorageSave(false, false);
        }));
    }

    private Optional<UUID> bo() {
        Object object = ((b.a)this.cT).bf();
        if (Files.exists((Path)(object = object.resolve("sync_id")), new LinkOption[0])) {
            try {
                object = Files.readString((Path)object);
                object = UUID.fromString((String)object);
                return Optional.of(object);
            }
            catch (Exception exception) {
                object = exception;
                ErrorEventFactory.fromThrowable((Throwable)exception).omit().expected().handle();
            }
        }
        return Optional.empty();
    }

    private void c(boolean bl) {
        try {
            Optional optional;
            if (this.bv()) {
                this.bn();
                return;
            }
            boolean bl2 = this.b(bl);
            if (bl2 && ((optional = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "rev-list", "HEAD..remote-storage/" + this.cS, "--count"})).readStdoutIfPossible()).isEmpty() || !((String)optional.get()).equals("0"))) {
                optional = this.cQ.command(a.a(this.cQ, CommandBuilder.of().add(new String[]{"git", "pull", "--strategy-option", "theirs", "remote-storage", "HEAD"})));
                String[] stringArray = optional.readStdoutAndStderr();
                stringArray = (String[])Arrays.stream(stringArray).map(string2 -> string2.lines().filter(string -> !string.contains("CRLF will be replaced by LF the next time Git touches it")).collect(Collectors.joining("\n"))).toArray(String[]::new);
                long l2 = optional.getExitCode();
                if (l2 != 0L) {
                    throw ProcessOutputException.of((String)optional.getDisplayCommand(), (long)l2, (String[])stringArray);
                }
                this.cW = this.bq().orElse(null);
            }
            if (bl2 && bl && DataStorage.get() != null) {
                DataStorage.get().reloadContent();
            }
            return;
        }
        catch (ProcessOutputException processOutputException) {
            ProcessOutputException processOutputException2 = processOutputException;
            c c2 = this;
            String string = processOutputException2.getOutput();
            if (string.contains("The following untracked working tree files would be overwritten by merge") && c2.ac(string)) {
                c2.c(true);
            }
            if (string.contains("Your local changes to the following files would be overwritten by merge:\n\tvaultversion\nPlease commit your changes or stash them before you merge.\n")) {
                c c3 = c2;
                c3.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
                    c c2 = this;
                    c2.p(a.a(c2.cQ, CommandBuilder.of().add(new String[]{"git", "checkout", "remote-storage/" + this.cS, "--", "vaultversion"})));
                }));
                c2.c(false);
            }
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            AtomicBoolean atomicBoolean2 = new AtomicBoolean();
            string = ErrorEventFactory.fromMessage((String)string);
            ErrorAction errorAction = ErrorAction.translated((String)"gitRepoTerminalOpen", () -> {
                TerminalLaunch.builder().title("Git Vault").command((ProcessControl)LocalShell.getShell()).directory(FilePath.of((Path)this.cR)).launch();
                return Boolean.FALSE;
            });
            ErrorAction errorAction2 = ErrorAction.translated((String)"gitRepoOverwriteLocal", () -> {
                if (!c.ab("OverwriteLocal")) {
                    return Boolean.FALSE;
                }
                if (this.bl() && this.bi() && this.bj()) {
                    atomicBoolean.set(true);
                    atomicBoolean2.set(true);
                } else {
                    atomicBoolean2.set(false);
                }
                return Boolean.TRUE;
            });
            ErrorAction errorAction3 = ErrorAction.translated((String)"gitRepoOverwriteLocal", () -> {
                if (!c.ab("OverwriteLocal")) {
                    return Boolean.FALSE;
                }
                if (this.bm()) {
                    atomicBoolean.set(true);
                    atomicBoolean2.set(true);
                } else {
                    atomicBoolean2.set(false);
                }
                return Boolean.TRUE;
            });
            ErrorAction errorAction4 = ErrorAction.translated((String)"gitRepoForcePush", () -> {
                if (!c.ab("ForcePush")) {
                    return Boolean.FALSE;
                }
                if (this.bk()) {
                    atomicBoolean2.set(true);
                    atomicBoolean.set(true);
                } else {
                    atomicBoolean2.set(false);
                }
                return Boolean.TRUE;
            });
            ErrorAction errorAction5 = ErrorAction.translated((String)"gitRepoDisable", () -> {
                atomicBoolean2.set(false);
                return Boolean.TRUE;
            });
            if (processOutputException2.getOutput().contains("Your local changes to the following files would be overwritten by merge") || processOutputException2.getOutput().contains("Automatic merge failed; fix conflicts and then commit the result")) {
                string.customAction(errorAction3);
                string.customAction(errorAction4);
            } else if (processOutputException2.getOutput().contains("refusing to merge unrelated histories") || processOutputException2.getOutput().contains("You have divergent branches and need to specify how to reconcile them")) {
                string.customAction(errorAction2);
                string.customAction(errorAction4);
            }
            string.expected();
            string.customAction(errorAction);
            string.customAction(errorAction5);
            string.handle();
            if (!atomicBoolean2.get()) {
                c2.enabled = false;
            }
            if (atomicBoolean.get()) {
                c2.c(true);
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
        }
    }

    private boolean ac(String object) {
        Object object2 = new AtomicBoolean();
        object = ((String)object).lines().dropWhile(arg_0 -> c.a((AtomicBoolean)object2, arg_0)).map(string -> {
            string = string.strip();
            try {
                return this.cR.resolve((String)string);
            }
            catch (InvalidPathException invalidPathException) {
                return null;
            }
        }).filter(path -> path != null && Files.exists(path, new LinkOption[0])).toList();
        try {
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (Path)object.next();
                FileUtils.forceDelete((File)object2.toFile());
            }
            return true;
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return false;
        }
    }

    private void bp() {
        this.cX = true;
        if (this.db == SyncMode.MANUAL) {
            return;
        }
        if (this.bv()) {
            return;
        }
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            try {
                CommandBuilder commandBuilder = a.a(this.cQ, CommandBuilder.of().add(new String[]{"git", "push"}).add(new String[]{"remote-storage", "HEAD:" + this.cS}));
                this.cQ.command(commandBuilder).execute();
                return;
            }
            catch (ProcessOutputException processOutputException) {
                this.cX = false;
                if (AppCache.getBoolean((String)"gitRepoWritePermissionsIgnore", (boolean)false)) {
                    return;
                }
                AtomicBoolean atomicBoolean = new AtomicBoolean();
                ErrorAction errorAction = ErrorAction.translated((String)"gitRepoTryAgain", () -> {
                    atomicBoolean.set(true);
                    return Boolean.TRUE;
                });
                ErrorAction errorAction2 = ErrorAction.translated((String)"gitRepoDontWarn", () -> {
                    AppCache.update((String)"gitRepoWritePermissionsIgnore", (Object)Boolean.TRUE);
                    return Boolean.TRUE;
                });
                ErrorEventFactory.fromThrowable((Throwable)processOutputException).description("Unable to write to remote repository").customAction(errorAction).customAction(errorAction2).expected().handle();
                if (atomicBoolean.get()) {
                    this.bp();
                    return;
                }
                return;
            }
        }));
    }

    public final void pullManually() {
        if (!this.enabled) {
            return;
        }
        this.c(false);
    }

    public final void pushManually() {
        if (!this.enabled) {
            return;
        }
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            this.bt();
            this.d(false);
        }));
    }

    public final void reset() {
        if (this.cQ != null) {
            this.cQ.close();
        }
    }

    public final boolean validateConnection() {
        block11: {
            Object object = (String)AppPrefs.get().storageGitRemote().get();
            Optional<b> optional = b.aa((String)object);
            if (optional.isEmpty()) {
                throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException("Unrecognized git remote url: " + (String)object));
            }
            c.d(optional.get());
            if (optional.get() instanceof b.a) {
                return true;
            }
            object = ProcessControlProvider.get().createLocalProcessControl(true).start();
            try {
                Object object2 = object;
                object2.command(a.a((ShellControl)object2, CommandBuilder.of().add(new String[]{"git", "ls-remote"}).addQuoted(optional.get().be()))).execute();
                if (object == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessOutputException processOutputException) {
                    String string = c.e(optional.get());
                    ErrorEventFactory.fromThrowable((Throwable)ProcessOutputException.withSuffix((String)string, (ProcessOutputException)processOutputException)).documentationLink(DocumentationLink.SYNC).expected().handle();
                    return false;
                }
                catch (Exception exception) {
                    object = exception;
                    ErrorEventFactory.fromThrowable((Throwable)exception).handle();
                    return false;
                }
            }
            object.close();
        }
        return true;
    }

    public final boolean supportsSync() {
        return this.enabled;
    }

    public final boolean hasExternalStoredCredentials() {
        return this.cV;
    }

    public final void init() {
        this.cR = DataStorage.getStorageDirectory();
        try {
            FileUtils.forceMkdir((File)this.cR.toFile());
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).terminal(true).build().handle();
            this.enabled = false;
            return;
        }
        this.cT = b.aa((String)AppPrefs.get().storageGitRemote().get()).orElse(null);
        Object object = this.cT;
        if (object instanceof b.a && ((b.a)(object = (b.a)object)).bf().equals(this.cR)) {
            this.cT = null;
        }
        this.cU = ((g)PrefsProvider.get(g.class)).u().get();
        this.enabled = AppPrefs.get().enableGitStorage().get();
        this.cP = Files.exists(this.cR.resolve(".git"), new LinkOption[0]);
        if (this.enabled) {
            this.cQ = ProcessControlProvider.get().createLocalProcessControl(true);
            this.cQ.setWorkingDirectory(WorkingDirectoryFunction.fixed((FilePath)FilePath.of((String)this.cR.toString())));
            try {
                this.cQ.start();
            }
            catch (Exception exception) {
                object = exception;
                ErrorEventFactory.fromThrowable((Throwable)exception).handle();
                this.enabled = false;
                return;
            }
        }
        try {
            object = this.enabled ? this.cQ : LocalShell.getShell();
            object = object.command(CommandBuilder.of().add(new String[]{"git", "config", "--list"})).sensitive().readStdoutIfPossible();
            this.cV = ((Optional)object).map(string -> string.contains("credential.")).orElse(Boolean.FALSE);
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).build().handle();
            this.enabled = false;
        }
        if (this.enabled && OsType.ofLocal() == OsType.MACOS && (object = (SshIdentityStrategy)((g)PrefsProvider.get(g.class)).x().getValue()) != null && !(object instanceof NoIdentityStrategy)) {
            PlatformInit.init((boolean)true);
            object = null;
            while (object == null) {
                object = AppMainWindow.get();
                ThreadHelper.sleep((long)50L);
            }
            boolean bl = object.getStage().isShowing();
            if (!bl) {
                PlatformThread.runLaterIfNeededBlocking(() -> c.a((AppMainWindow)object));
            }
        }
    }

    public final void prepareGpgIfNeeded() {
        if (!this.enabled) {
            return;
        }
        try {
            a.r(this.cQ);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).build().handle();
            return;
        }
    }

    public final Optional<String> bq() {
        try {
            Optional optional = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "rev-parse", "HEAD"})).readStdoutIfPossible();
            return optional;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return Optional.empty();
        }
    }

    public final Optional<String> br() {
        try {
            Optional optional = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "rev-parse", "HEAD~1"})).readStdoutIfPossible();
            return optional;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return Optional.empty();
        }
    }

    public final String bs() {
        String string = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "rev-list", "--max-parents=0", "HEAD"})).readStdoutOrThrow();
        return string;
    }

    public final void retrieveSyncedData() {
        if (!this.enabled) {
            return;
        }
        if (this.bi() && this.bj()) {
            this.cN = true;
            if (this.db != SyncMode.MANUAL) {
                this.c(false);
            } else {
                this.b(false);
            }
            c c2 = this;
            c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
                boolean bl = d.bM();
                if (bl) {
                    this.enabled = false;
                }
            }));
            if (!this.enabled) {
                return;
            }
            c2 = this;
            c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
                try {
                    this.cQ.command(CommandBuilder.of().add(new String[]{"git", "commit"})).execute();
                    return;
                }
                catch (ProcessOutputException processOutputException) {
                    Object object = processOutputException;
                    object = processOutputException.getOutput();
                    if (((String)object).contains("Author identity unknown")) {
                        boolean bl;
                        Optional optional = this.cQ.command("git log -1 --pretty=format:'%an'").readStdoutIfPossible();
                        if (optional.isEmpty()) {
                            optional = AsktextAlert.query((String)"Enter username that should be used as the git commit author", null);
                        }
                        Optional optional2 = this.cQ.command("git log -1 --pretty=format:'%ae'").readStdoutIfPossible();
                        if (optional.isPresent() && optional2.isEmpty()) {
                            optional2 = AsktextAlert.query((String)"Enter email address for the git commit author", null);
                        }
                        if (optional.isPresent() && !((String)optional.get()).isBlank() && optional2.isPresent() && !((String)optional2.get()).isBlank() && (bl = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "config", "--global", "user.email"}).addQuoted((String)optional2.get())).executeAndCheck() && this.cQ.command(CommandBuilder.of().add(new String[]{"git", "config", "--global", "user.name"}).addQuoted((String)optional.get())).executeAndCheck())) {
                            return;
                        }
                        String string = "No git commit author information has been set but is required to create commits. Please configure your name and email for your git commits on the command-line as shown below or in the settings menu and restart XPipe.\n\n" + (String)object;
                        throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException(string));
                    }
                    return;
                }
            }));
            if (!this.enabled) {
                return;
            }
            this.bp();
            this.cW = this.bq().orElse(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void refreshRemoteData() {
        boolean bl;
        if (!this.enabled) {
            return;
        }
        if (this.cT == null) {
            return;
        }
        if (AppOperationMode.isInShutdown()) {
            return;
        }
        if (this.db != SyncMode.INSTANT) {
            return;
        }
        try {
            boolean bl2;
            Object object = this;
            if (((c)object).bv()) {
                Optional<UUID> optional = ((c)object).bo();
                if (!optional.isPresent()) return;
                if (optional.get().equals(((c)object).da)) return;
                bl2 = true;
            } else {
                Optional optional = ((c)object).cQ.command(a.a(((c)object).cQ, CommandBuilder.of().add(new String[]{"git", "ls-remote"}).addQuoted(((c)object).cT.be()).addQuoted("refs/heads/" + ((c)object).cS))).sensitive().readStdoutIfPossible();
                if (optional.isEmpty()) return;
                String[] stringArray = ((String)optional.get()).split("\\s+");
                if (stringArray.length != 2) return;
                if (!stringArray[1].equals("refs/heads/" + ((c)object).cS)) {
                    return;
                }
                String string2 = stringArray[0];
                object = ((c)object).cQ.command(CommandBuilder.of().add(new String[]{"git", "cat-file", "-t"}).addQuoted(string2)).sensitive().readStdoutIfPossible();
                if (((Boolean)(object = ((Optional)object).map(string -> string.equals("commit")).orElse(Boolean.FALSE))).booleanValue()) return;
                bl2 = true;
            }
            bl = bl2;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).expected().omit().handle();
            return;
        }
        if (!bl) {
            return;
        }
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            this.bg();
            this.c(true);
            this.bh();
        }));
    }

    public final void afterStorageLoad() {
        if (this.enabled) {
            c c2 = this;
            c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
                c c2 = this;
                Path iterable2 = c2.cR.resolve("data");
                FileUtils.forceMkdir((File)iterable2.toFile());
                if (!FileUtils.isEmptyDirectory((File)iterable2.toFile())) {
                    List<Path> list;
                    try (Stream<Path> stream = Files.walk(iterable2, new FileVisitOption[0]);){
                        list = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).toList();
                    }
                    for (Path path2 : list) {
                        if (!path2.toString().endsWith(".enc")) continue;
                        try {
                            String string = Files.readString(path2);
                            string = DataStorageSecret.deserialize((JsonNode)JacksonMapper.getDefault().readTree(string));
                            if (string == null || !string.getEncryptedToken().canDecrypt()) continue;
                            Object object = string.getInternalSecret().getSecretRaw();
                            Path path3 = Path.of(path2.toString().substring(0, path2.toString().length() - 4), new String[0]);
                            byte[] byArray = object;
                            object = path3;
                            File file = path3.toFile();
                            if (!file.canWrite() && file.setWritable(true, true)) {
                                try {
                                    Files.write((Path)object, byArray, new OpenOption[0]);
                                }
                                finally {
                                    file.setWritable(false, true);
                                }
                            } else {
                                Files.write((Path)object, byArray, new OpenOption[0]);
                            }
                            c2.cK.put(path3, (DataStorageSecret)string);
                        }
                        catch (Exception exception) {
                            ErrorEventFactory.fromThrowable((String)("Failed to decrypt data file " + String.valueOf(path2)), (Throwable)exception).handle();
                        }
                    }
                }
                boolean bl = !this.cZ;
                this.cZ = true;
                if (bl && this.bv()) {
                    this.bn();
                }
            }));
        }
    }

    public final void beforeStorageSave() {
        if (!this.enabled) {
            return;
        }
        this.cG.clear();
        this.cG.addAll(this.cH);
        this.cH.clear();
        this.cI.clear();
        this.cI.addAll(this.cJ);
        this.cJ.clear();
        try {
            Object object;
            c c2 = this;
            Path path = c2.cR.resolve("leak_detection");
            if (!Files.exists(path, new LinkOption[0]) && !((Optional)(object = c2.cQ.view().findProgram("ssh-keygen"))).isEmpty()) {
                object = CommandBuilder.of().add(new String[]{"ssh-keygen -q -t rsa -b 4096 -C \"Dummy key for leak detection\" -f"}).addQuoted(path.toString()).add(shellControl -> {
                    if (ShellDialects.isPowershell((ShellControl)shellControl)) {
                        return "-N '\"\"'";
                    }
                    return "-N \"\"";
                });
                c2.cQ.command((CommandBuilder)object).execute();
                object = Files.readString(path);
                object = (String)object + "\n\n# This is a dummy key, designed to allow your git provider to detect potential leaks of\n# this repository, for example if it is made public accidentally.\n# Most git providers should warn you if you have a secret key stored in a\n# publicly accessible repository. They all pretty much are able to detect SSH keys.\n";
                Files.writeString(path, (CharSequence)object, new OpenOption[0]);
                FileUtils.deleteQuietly((File)Path.of(String.valueOf(path) + ".pub", new String[0]).toFile());
                c2.a(path);
                c2.e(path.getFileName().toString(), "Create");
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
        }
        c c3 = this;
        c3.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            try {
                this.cM = this.cQ.command(CommandBuilder.of().add(new String[]{"git", "status"})).sensitive().readStdoutOrThrow();
                return;
            }
            catch (Exception exception) {
                if (!AppOperationMode.isInShutdown()) {
                    throw exception;
                }
                return;
            }
        }));
    }

    private void bt() {
        boolean bl = this.db != SyncMode.INSTANT;
        if (bl) {
            Object object = this.cW != null ? this.cW : this.bs();
            String string2 = this.cW != null ? "Sync changes" : "Initial commit";
            Object object2 = string2;
            string2 = object;
            object = this;
            Optional<String> optional = ((c)object).bq();
            if (optional.isEmpty() || optional.get().equals(string2)) {
                return;
            }
            optional = ((c)object).br();
            if (!optional.isPresent() || !string2.equals(optional.get())) {
                optional = ((c)object).cQ.command(CommandBuilder.of().add(new String[]{"git", "log", "--format=\"%B\"", "--reverse"}).addQuoted(string2 + "..HEAD")).readStdoutOrThrow();
                optional = ((String)((Object)optional)).lines().filter(string -> !string.isEmpty()).map(string -> "- " + string).collect(Collectors.joining("\n"));
                long l2 = ((String)((Object)optional)).lines().count();
                object2 = (String)object2 + "\nSquashed commit of the following " + l2 + " changes:\n" + (String)((Object)optional);
                ((c)object).cQ.command(CommandBuilder.of().add(new String[]{"git", "reset", "--soft"}).addQuoted(string2)).execute();
                string2 = ((c)object).cQ.view().writeTextFileDeterministic(((c)object).cQ.getSystemTemporaryDirectory().join(new String[]{"git-msg.txt"}), (String)object2);
                ((c)object).cQ.command(CommandBuilder.of().add(new String[]{"git", "commit", "-F"}).addFile((FilePath)string2)).execute();
            }
        }
    }

    public final void afterStorageSave(boolean bl, boolean bl2) {
        if (!this.enabled) {
            return;
        }
        boolean bl3 = !this.cY;
        this.cY = true;
        Optional<String> optional = this.bq();
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl4 = this.bu();
            boolean bl5 = false;
            Path path = this.cR.resolve("preferences.json");
            if (Files.exists(path, new LinkOption[0])) {
                this.a(path);
                bl5 = this.e(path.getFileName().toString(), "Update");
            }
            boolean bl6 = false;
            Path path2 = this.cR.resolve("vaultkey");
            if (Files.exists(path2, new LinkOption[0])) {
                this.a(path2);
                bl6 = this.e(path2.getFileName().toString(), "Update");
            }
            boolean bl7 = false;
            Path path3 = this.cR.resolve("vaultversion");
            if (Files.exists(path3, new LinkOption[0])) {
                this.a(path3);
                bl7 = this.e(path3.getFileName().toString(), "Update");
            }
            boolean bl8 = false;
            Path path4 = this.cR.resolve("users.json");
            if (Files.exists(path4, new LinkOption[0])) {
                this.a(path4);
                bl8 = this.e(path4.getFileName().toString(), "Update");
            }
            boolean bl9 = false;
            Path path5 = this.cR.resolve("icons");
            if (Files.exists(path5, new LinkOption[0])) {
                this.a(path5);
                bl9 = this.e(path5.getFileName().toString(), "Update");
            }
            boolean bl10 = false;
            Path path6 = this.cR.resolve("notes.md");
            if (Files.exists(path6, new LinkOption[0])) {
                this.a(path6);
                bl10 = this.e(path6.getFileName().toString(), "Update");
            }
            if (!this.cN) {
                return;
            }
            path6 = this.cR.resolve("README.md");
            boolean bl11 = Files.exists(path6, new LinkOption[0]);
            bl4 = this.cO || bl4 || bl5 || bl6 || bl7 || bl8 || bl9 || bl10;
            if (bl4 && bl11) {
                Files.writeString(path6, (CharSequence)this.bw(), new OpenOption[0]);
                this.a(path6);
                this.e(path6.getFileName().toString(), "Update");
            }
            if (!bl11) {
                Files.writeString(path6, (CharSequence)this.bw(), new OpenOption[0]);
                this.a(path6);
                this.e(path6.getFileName().toString(), "Create");
                bl4 = true;
            }
            bl5 = optional.isEmpty() || !((String)optional.get()).equals(this.cW);
            bl6 = !this.cJ.equals(this.cI);
            bl3 = bl3 || this.db == SyncMode.INSTANT || bl2 && this.db == SyncMode.SESSION;
            boolean bl12 = bl3 || optional.isEmpty() || bl6;
            bl12 = bl && this.cX && bl5 && bl4 && bl12;
            if (bl12) {
                this.bt();
                this.d(false);
            }
            if (!bl11) {
                c c2 = this;
                if (c2.cT != null && !(c2.cT instanceof b.a)) {
                    Hyperlinks.open((String)c2.cT.bd());
                }
            }
        }));
    }

    public final void handleEntry(DataStoreEntry dataStoreEntry, boolean bl, boolean bl2) {
        if (!this.enabled) {
            return;
        }
        boolean bl3 = DataStorage.get().shouldSync(dataStoreEntry);
        if (bl3 && this.cH.add(dataStoreEntry)) {
            this.cO = true;
        }
        if (bl3 && (bl2 || this.a((StorageElement)dataStoreEntry))) {
            this.a(dataStoreEntry.getShareableFiles());
            this.e(DataStorage.get().getStorePath(dataStoreEntry).toString(), bl ? "Update" : "Add");
            this.cO = true;
            return;
        }
        if (!bl3 && this.cG.contains(dataStoreEntry)) {
            this.b(dataStoreEntry.getShareableFiles());
            this.e(DataStorage.get().getStorePath(dataStoreEntry).toString(), "Remove");
            this.cO = true;
        }
    }

    public final void handleCategory(DataStoreCategory dataStoreCategory, boolean bl, boolean bl2) {
        if (!this.enabled) {
            return;
        }
        boolean bl3 = DataStorage.get().shouldSync(dataStoreCategory);
        if (bl3 && this.cJ.add(dataStoreCategory)) {
            this.cO = true;
        }
        if (bl3 && (bl2 || this.a((StorageElement)dataStoreCategory))) {
            this.a(dataStoreCategory.getShareableFiles());
            this.e("category " + dataStoreCategory.getName(), bl ? "Update" : "Add");
            this.cO = true;
            return;
        }
        if (!bl3 && this.cI.contains(dataStoreCategory)) {
            this.b(dataStoreCategory.getShareableFiles());
            this.e("category " + dataStoreCategory.getName(), "Remove");
            this.cO = true;
        }
    }

    public final void handleDeletion(Path path, String string) {
        if (!this.enabled) {
            return;
        }
        string = this.cG.stream().filter(dataStoreEntry -> dataStoreEntry.getUuid().toString().equals(string)).findFirst().map(StorageElement::getName).or(() -> this.cI.stream().filter(dataStoreCategory -> dataStoreCategory.getUuid().toString().equals(string)).findFirst().map(StorageElement::getName)).orElse(string);
        this.b(path);
        this.e(string, "Remove");
    }

    public final Path getDirectory() {
        return this.cR;
    }

    public final List<Path> getSavedDataFiles() {
        List<Path> list;
        block10: {
            if (!this.enabled) {
                return List.of();
            }
            Object object = this.getDirectory().resolve("data");
            if (!Files.exists((Path)object, new LinkOption[0])) {
                return List.of();
            }
            object = Files.walk((Path)object, new FileVisitOption[0]);
            try {
                List<Path> list2 = object.toList();
                list = list2.stream().filter(path -> Files.isRegularFile(path, new LinkOption[0]) && !path.getFileName().toString().endsWith(".enc")).toList();
                if (object == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    object = iOException;
                    ErrorEventFactory.fromThrowable((Throwable)iOException).handle();
                    return List.of();
                }
            }
            object.close();
        }
        return list;
    }

    public final Path getDataFile(Path path) {
        Path path2 = this.getDirectory().resolve("data");
        return path2.resolve(path);
    }

    public final Path addDataFile(Path path, Path path2, boolean bl) {
        Path path3 = this.cR.resolve("data");
        if (!path2.startsWith(path3)) {
            throw new IllegalArgumentException("Target path is not in sync data dir");
        }
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            Object object = Files.readAllBytes(path);
            object = c.a(object);
            if (Files.exists(path2, new LinkOption[0])) {
                if (!path.equals(path2)) {
                    Files.delete(path2);
                }
                this.cK.remove(path2);
            }
            FileUtils.forceMkdir((File)path2.getParent().toFile());
            if (!path.equals(path2)) {
                Files.write(path2, object, new OpenOption[0]);
            }
            path = Path.of(String.valueOf(path2) + ".enc", new String[0]);
            bl = bl && DataStorageUserHandler.getInstance().getActiveUser() != null;
            DataStorageSecret dataStorageSecret = DataStorageSecret.ofSecret((SecretValue)InPlaceSecretValue.of((byte[])object), (EncryptionToken)(bl ? EncryptionToken.ofUser() : EncryptionToken.ofVaultKey()));
            object = JacksonMapper.getDefault().writeValueAsString((Object)dataStorageSecret);
            Files.writeString(path, (CharSequence)object, new OpenOption[0]);
            this.cK.put(path2, dataStorageSecret);
            this.cQ.command(CommandBuilder.of().add(new String[]{"git", "add"}).addFile(path.toString())).execute();
            this.e(path2.getFileName().toString(), "Update");
        }));
        return path2;
    }

    private static byte[] a(byte[] byArray) {
        String string = new String(byArray, StandardCharsets.UTF_8);
        if (string.contains("PRIVATE KEY-----")) {
            return (string.strip().replaceAll("\r\n", "\n") + "\n").getBytes(StandardCharsets.UTF_8);
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean bu() {
        var1_1 = this.cR.resolve("data");
        FileUtils.forceMkdir((File)var1_1.toFile());
        if (FileUtils.isEmptyDirectory((File)var1_1.toFile())) {
            return false;
        }
        var2_3 = Files.walk((Path)var1_1, new FileVisitOption[0]);
        try {
            var1_1 = var2_3.filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, c(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).toList();
        }
        finally {
            if (var2_3 != null) {
                var2_3.close();
            }
        }
        var2_4 = false;
        var1_1 = var1_1.iterator();
        while (var1_1.hasNext()) {
            var3_6 = (Path)var1_1.next();
            if (var3_6.toString().endsWith(".enc")) continue;
            var4_7 = Path.of(String.valueOf(var3_6) + ".enc", new String[0]);
            var7_11 = Files.size(var3_6);
            if (var7_11 > 1000000L) {
                if (Files.exists(var4_7, new LinkOption[0])) {
                    Files.delete(var4_7);
                }
                this.cQ.command(CommandBuilder.of().add(new String[]{"git", "add"}).addFile(var3_6.toString())).execute();
                var2_4 = this.e(var3_6.getFileName().toString(), "Update") != false || var2_4 != false;
                continue;
            }
            var5_8 /* !! */  = this.cK.get(var3_6);
            if (var5_8 /* !! */  == null && Files.exists(var4_7, new LinkOption[0])) continue;
            try {
                var6_9 /* !! */  = Files.readAllBytes(var3_6);
                var6_9 /* !! */  = c.a(var6_9 /* !! */ );
                var6_9 /* !! */  = (byte[])(var5_8 /* !! */  != null && var5_8 /* !! */ .getEncryptedToken().canDecrypt() != false ? DataStorageSecret.ofSecret((SecretValue)InPlaceSecretValue.of((byte[])var6_9 /* !! */ ), (EncryptionToken)var5_8 /* !! */ .getEncryptedToken()) : DataStorageSecret.ofCurrentSecret((SecretValue)InPlaceSecretValue.of((byte[])var6_9 /* !! */ )));
                if (var5_8 /* !! */  == null) ** GOTO lbl-1000
                v0 = var5_8 /* !! */ ;
                if (v0.requiresRewrite(v0.getEncryptedToken().isUser() != false || var5_8 /* !! */ .getEncryptedToken().canDecrypt() == false)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = var7_12 = false;
                }
                if (var5_8 /* !! */  != null && !var7_12 && Arrays.equals(var5_8 /* !! */ .getSecret(), var6_9 /* !! */ .getSecret())) continue;
                var5_8 /* !! */  = JacksonMapper.getDefault().writeValueAsString((Object)var6_9 /* !! */ .serialize(true));
                Files.writeString(var4_7, (CharSequence)var5_8 /* !! */ , new OpenOption[0]);
                this.cK.put(var3_6, (DataStorageSecret)var6_9 /* !! */ );
                this.cQ.command(CommandBuilder.of().add(new String[]{"git", "add"}).addFile(var4_7.toString())).execute();
                var2_4 = this.e(var3_6.getFileName().toString(), "Update") != false || var2_4 != false;
            }
            catch (Exception var6_10) {
                ErrorEventFactory.fromThrowable((String)("Failed to encrypt data file " + String.valueOf(var3_6)), (Throwable)var6_10).handle();
            }
        }
        return var2_4;
    }

    private boolean bv() {
        return this.cT instanceof b.a && this.cU;
    }

    private void d(boolean bl) {
        if (this.bv()) {
            Optional<UUID> optional = this.bo();
            if (optional.isPresent() && !optional.get().equals(this.da)) {
                this.bn();
            }
            c c2 = this;
            c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
                Path path = ((b.a)this.cT).bf();
                if (Files.exists(path, new LinkOption[0])) {
                    Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(FileUtils::deleteQuietly);
                }
                Files.createDirectories(path, new FileAttribute[0]);
                Path path2 = AppSystemInfo.ofCurrent().getTemp().resolve("xpipe-sync.tar");
                this.cQ.command(CommandBuilder.of().add(new String[]{"git", "archive"}).add(new String[]{"--format", "tar", "--output"}).addFile(path2).add(new String[]{"HEAD"})).execute();
                this.cQ.command(CommandBuilder.of().add(new String[]{"tar", "-f"}).addFile(path2).add(new String[]{"-C"}).addFile(path).add(new String[]{"-x"})).execute();
                this.da = UUID.randomUUID();
                Files.writeString(path.resolve("sync_id"), (CharSequence)this.da.toString(), new OpenOption[0]);
            }));
            return;
        }
        try {
            this.a(bl, false);
            this.bh();
            return;
        }
        catch (ProcessOutputException processOutputException) {
            boolean bl2 = bl;
            ProcessOutputException processOutputException2 = processOutputException;
            c c3 = this;
            String string = processOutputException2.getOutput();
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            string = ErrorEventFactory.fromMessage((String)string);
            ErrorAction errorAction = ErrorAction.translated((String)"gitRepoOverwriteLocal", () -> {
                if (!c.ab("OverwriteLocal")) {
                    return Boolean.FALSE;
                }
                if (this.bm()) {
                    atomicBoolean.set(true);
                } else {
                    atomicBoolean.set(false);
                }
                return Boolean.TRUE;
            });
            ErrorAction errorAction2 = ErrorAction.translated((String)"gitRepoForcePush", () -> {
                if (!c.ab("ForcePush")) {
                    return Boolean.FALSE;
                }
                this.d(true);
                atomicBoolean.set(true);
                return Boolean.TRUE;
            });
            ErrorAction errorAction3 = ErrorAction.translated((String)"gitRepoDisable", () -> {
                atomicBoolean.set(false);
                return Boolean.TRUE;
            });
            if (c3.cX && !bl2 && processOutputException2.getOutput().contains("Updates were rejected because the remote contains work that you")) {
                string.customAction(errorAction2);
            }
            if (processOutputException2.getOutput().contains("By default, updating the current branch in a non-bare repository")) {
                string.documentationLink(DocumentationLink.SYNC_LOCAL);
            } else {
                string.customAction(errorAction);
            }
            string.customAction(errorAction3);
            string.expected();
            string.handle();
            if (!atomicBoolean.get()) {
                c3.enabled = false;
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return;
        }
    }

    private void a(boolean bl, boolean bl2) {
        try {
            CommandBuilder commandBuilder = a.a(this.cQ, CommandBuilder.of().add(new String[]{"git", "push"}).addIf(bl, new String[]{"--force"}).add(new String[]{"remote-storage", "HEAD:" + this.cS}));
            this.cQ.command(commandBuilder).execute();
            this.cW = this.bq().orElse(null);
            return;
        }
        catch (ProcessOutputException processOutputException) {
            if (!bl2 && !AppOperationMode.isInShutdown()) {
                try {
                    this.bg();
                    this.c(true);
                    this.bh();
                    this.a(bl, true);
                    return;
                }
                catch (Exception exception) {
                    processOutputException.addSuppressed((Throwable)exception);
                    throw processOutputException;
                }
            }
            throw processOutputException;
        }
    }

    private boolean a(StorageElement storageElement) {
        String string3 = storageElement instanceof DataStoreEntry ? "stores" : "categories";
        int n2 = this.cM.lines().map(string -> string.strip()).anyMatch(string2 -> string2.equals(string3 + "/"));
        if (n2 != 0) {
            return true;
        }
        n2 = this.cM.indexOf(storageElement.getUuid().toString());
        if (n2 == -1) {
            return false;
        }
        n2 = this.cM.lines().anyMatch(string -> string.contains(storageElement.getUuid().toString()) && Arrays.stream(storageElement.getShareableFiles()).map(path -> path.getFileName().toString()).anyMatch(string2 -> string.contains((CharSequence)string2))) ? 1 : 0;
        boolean bl = this.cM.lines().anyMatch(string -> string.endsWith(storageElement.getUuid().toString() + "/"));
        return n2 != 0 || bl;
    }

    private void a(Path ... pathArray) {
        if (!this.enabled) {
            return;
        }
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"git"}).add(new String[]{"add"});
        for (Path path : pathArray) {
            commandBuilder.addFile(path.toString());
        }
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> this.q(commandBuilder)));
    }

    private void b(Path ... pathArray) {
        if (!this.enabled) {
            return;
        }
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"git"}).add(new String[]{"rm"}).add(new String[]{"-r"}).add(new String[]{"--cached"});
        for (Path path : pathArray) {
            commandBuilder.addFile(path.toString());
        }
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> this.q(commandBuilder)));
    }

    private boolean e(String object, String string) {
        if (!this.enabled) {
            return false;
        }
        try {
            object = string + " " + object;
            c c2 = this;
            c2.p(a.a(c2.cQ, CommandBuilder.of().add(new String[]{"git", "commit", "-m"}).addQuoted(object).discardStdoutOutput()));
            return true;
        }
        catch (ProcessOutputException processOutputException) {
            object = processOutputException;
            if (processOutputException.getOutput().contains("gpg failed to sign the data")) {
                string = "GPG signing of commit failed";
                object = ProcessOutputException.withPrefix((String)"GPG signing of commit failed", (ProcessOutputException)((Object)object));
                ErrorEventFactory.fromThrowable((Throwable)object).handle();
                this.enabled = false;
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return false;
        }
    }

    private void a(UUID uUID, Consumer<DataStoreCategory> consumer) {
        this.cJ.stream().filter(dataStoreCategory -> dataStoreCategory.getParentCategory().equals(uUID)).sorted((dataStoreCategory, dataStoreCategory2) -> {
            int n2 = dataStoreCategory.getName().compareToIgnoreCase(dataStoreCategory2.getName());
            if (n2 != 0) {
                return -n2;
            }
            return dataStoreCategory.getUuid().compareTo(dataStoreCategory2.getUuid());
        }).forEach(consumer);
    }

    private void a(int n2, DataStoreCategory dataStoreCategory, List<String> list) {
        list.add("  ".repeat(n2) + "- [**" + dataStoreCategory.getName() + "**](categories/" + String.valueOf(dataStoreCategory.getUuid()) + ")");
        this.a(dataStoreCategory.getUuid(), arg_0 -> this.a(++n2, list, arg_0));
    }

    private void a(DataStoreCategory dataStoreCategory2, List<String> list, AtomicBoolean atomicBoolean) {
        Object object = dataStoreCategory2.getName();
        Object object2 = dataStoreCategory2;
        while ((object2 = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(object2.getParentCategory()).orElse(null)) != null) {
            object = object2.getName() + " / " + (String)object;
        }
        list.add("**" + (String)object + "**");
        list.add("");
        object = new AtomicBoolean(false);
        Consumer<DataStoreEntry> consumer = arg_0 -> this.a((AtomicBoolean)object, list, atomicBoolean, arg_0);
        UUID uUID = dataStoreCategory2.getUuid();
        object2 = this;
        object2.cH.stream().filter(dataStoreEntry -> dataStoreEntry.getCategoryUuid().equals(uUID) && DataStorage.get().getDefaultDisplayParent(dataStoreEntry).isEmpty()).sorted((dataStoreEntry, dataStoreEntry2) -> {
            Optional optional = DataStorage.get().getStoreCategoryIfPresent(dataStoreEntry.getCategoryUuid());
            Optional optional2 = DataStorage.get().getStoreCategoryIfPresent(dataStoreEntry2.getCategoryUuid());
            if (optional.isEmpty() || optional2.isEmpty()) {
                return 0;
            }
            int n2 = ((DataStoreCategory)optional.get()).getName().compareToIgnoreCase(((DataStoreCategory)optional2.get()).getName());
            if (n2 != 0) {
                return n2;
            }
            return DataStorage.get().getStorePath(dataStoreEntry).toString().compareToIgnoreCase(DataStorage.get().getStorePath(dataStoreEntry2).toString());
        }).forEach(consumer);
        if (!((AtomicBoolean)object).get()) {
            list.add("empty");
        }
        list.add("");
        this.a(dataStoreCategory2.getUuid(), (DataStoreCategory dataStoreCategory) -> this.a((DataStoreCategory)dataStoreCategory, list, atomicBoolean));
    }

    private void a(int n2, DataStoreEntry object, List<String> list, AtomicBoolean atomicBoolean) {
        list.add("  ".repeat(n2) + "- [**" + object.getName() + "**](stores/" + String.valueOf(object.getUuid()) + ")");
        atomicBoolean.set(true);
        DataStoreEntry dataStoreEntry3 = object;
        object = arg_0 -> this.a(++n2, list, atomicBoolean, arg_0);
        Object object2 = dataStoreEntry3;
        object2 = DataStorage.get().getStoreChildren(object2);
        object2.stream().filter(dataStoreEntry -> !dataStoreEntry.isPerUserStore()).sorted((dataStoreEntry, dataStoreEntry2) -> {
            DataStoreCategory dataStoreCategory = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(dataStoreEntry.getCategoryUuid()).orElseThrow();
            DataStoreCategory dataStoreCategory2 = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(dataStoreEntry2.getCategoryUuid()).orElseThrow();
            int n2 = dataStoreCategory.getName().compareToIgnoreCase(dataStoreCategory2.getName());
            if (n2 != 0) {
                return n2;
            }
            return DataStorage.get().getStorePath(dataStoreEntry).toString().compareToIgnoreCase(DataStorage.get().getStorePath(dataStoreEntry2).toString());
        }).forEach((Consumer<DataStoreEntry>)object);
    }

    private String bw() {
        try {
            Object object = new ArrayList<String>();
            object.add("- **Connections**");
            this.a(DataStorage.ALL_CONNECTIONS_CATEGORY_UUID, (DataStoreCategory dataStoreCategory) -> this.a(1, (DataStoreCategory)dataStoreCategory, (List<String>)object));
            object.add("- **Scripts**");
            this.a(DataStorage.ALL_SCRIPTS_CATEGORY_UUID, (DataStoreCategory dataStoreCategory) -> this.a(1, (DataStoreCategory)dataStoreCategory, (List<String>)object));
            object.add("- **Identities**");
            this.a(DataStorage.ALL_IDENTITIES_CATEGORY_UUID, (DataStoreCategory dataStoreCategory) -> this.a(1, (DataStoreCategory)dataStoreCategory, (List<String>)object));
            object.add("- **Macros**");
            this.a(DataStorage.ALL_MACROS_CATEGORY_UUID, (DataStoreCategory dataStoreCategory) -> this.a(1, (DataStoreCategory)dataStoreCategory, (List<String>)object));
            object = String.join((CharSequence)"\n", object);
            if (((String)object).isEmpty()) {
                object = "No categories were shared. Please make sure that all categories that you want to commit are designated to be shared.";
            }
            Object object2 = new AtomicBoolean();
            Object object3 = new ArrayList();
            this.a(DataStorage.ALL_CONNECTIONS_CATEGORY_UUID, arg_0 -> this.c(object3, (AtomicBoolean)object2, arg_0));
            this.a(DataStorage.ALL_SCRIPTS_CATEGORY_UUID, arg_0 -> this.b(object3, (AtomicBoolean)object2, arg_0));
            this.a(DataStorage.ALL_IDENTITIES_CATEGORY_UUID, arg_0 -> this.a(object3, (AtomicBoolean)object2, arg_0));
            object3 = String.join((CharSequence)"\n", object3);
            if (!((AtomicBoolean)object2).get()) {
                object3 = "No connections were shared. Please make sure that some categories are shared and the connections are sharable. Anything related to the local machine for example is not sharable.";
            }
            AtomicReference<String> atomicReference = new AtomicReference<String>("");
            AppResources.with((String)AppResources.MAIN_MODULE, (String)(((AtomicBoolean)object2).get() ? "misc/vault.md" : "misc/vault_empty.md"), path -> atomicReference.set(Files.readString(path)));
            object2 = atomicReference.get();
            return ((String)object2).formatted(object, object3);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    private /* synthetic */ void a(List list, AtomicBoolean atomicBoolean, DataStoreCategory dataStoreCategory) {
        this.a(dataStoreCategory, (List<String>)list, atomicBoolean);
    }

    private /* synthetic */ void b(List list, AtomicBoolean atomicBoolean, DataStoreCategory dataStoreCategory) {
        this.a(dataStoreCategory, (List<String>)list, atomicBoolean);
    }

    private /* synthetic */ void c(List list, AtomicBoolean atomicBoolean, DataStoreCategory dataStoreCategory) {
        this.a(dataStoreCategory, (List<String>)list, atomicBoolean);
    }

    private /* synthetic */ void a(int n2, List list, AtomicBoolean atomicBoolean, DataStoreEntry dataStoreEntry) {
        this.a(n2, dataStoreEntry, list, atomicBoolean);
    }

    private /* synthetic */ void a(AtomicBoolean atomicBoolean, List list, AtomicBoolean atomicBoolean2, DataStoreEntry dataStoreEntry) {
        atomicBoolean.set(true);
        this.a(0, dataStoreEntry, list, atomicBoolean2);
    }

    private /* synthetic */ void a(int n2, List list, DataStoreCategory dataStoreCategory) {
        this.a(n2, dataStoreCategory, list);
    }

    private static /* synthetic */ boolean c(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    private static /* synthetic */ void a(AppMainWindow appMainWindow) {
        appMainWindow.show();
        appMainWindow.getStage().hide();
    }

    private static /* synthetic */ boolean a(AtomicBoolean atomicBoolean, String string) {
        return !atomicBoolean.getAndSet(string.contains("The following untracked working tree files would be overwritten by merge"));
    }

    private static /* synthetic */ Boolean f(AtomicBoolean atomicBoolean) {
        atomicBoolean.set(true);
        return Boolean.TRUE;
    }

    private /* synthetic */ Boolean g(AtomicBoolean atomicBoolean) {
        AppPrefs.get().setFromExternal((ObservableValue)((g)PrefsProvider.get(g.class)).u(), (Object)Boolean.TRUE);
        this.cU = true;
        atomicBoolean.set(true);
        return Boolean.TRUE;
    }

    private /* synthetic */ Boolean a(b.a a2, AtomicBoolean atomicBoolean) {
        c c2 = this;
        c2.a((FailableRunnable<Exception>)((FailableRunnable)() -> this.cQ.command(CommandBuilder.of().add(new String[]{"git", "init", "--bare"}).addFile(a2.bf())).execute()));
        atomicBoolean.set(true);
        return Boolean.TRUE;
    }

    private /* synthetic */ boolean am(String string) {
        return string.equals(this.cR.toString());
    }
}

