/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.k8s;

import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.CommandView;
import io.xpipe.app.process.CommandViewBase;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.storage.ContextualFileReference;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.k8s.e;
import io.xpipe.ext.proc.k8s.j;
import io.xpipe.ext.proc.k8s.l;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import lombok.NonNull;

public class i
extends CommandViewBase {
    public i(ShellControl shellControl) {
        super(shellControl);
    }

    private static <T extends Throwable> T b(T t2) {
        return (T)ErrorEventFactory.expectedIfContains(t2, (String[])new String[]{"You must be logged in to the server", "connect: connection refused", "Error from server (Forbidden)", "Error from server (NotFound)", "A connection attempt failed because the connected party did not properly respond after a period of time", "No connection could be made because the target machine actively refused it", "OCI runtime exec failed", "no such host", "Timeout occurred"});
    }

    public i cu() {
        this.shellControl.start();
        return this;
    }

    protected ElevationFunction cv() {
        return ElevationFunction.cached((String)"k8sRequiresElevation", (ElevationFunction)new ElevationFunction(this){
            {
                Objects.requireNonNull(i2);
            }

            public final String getPrefix() {
                return "kubectl";
            }

            public final boolean isSpecified() {
                return true;
            }

            public final boolean apply(ShellControl shellControl) {
                if (shellControl.getOsType() == OsType.WINDOWS) {
                    return false;
                }
                CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"kubectl", "config", "current-context"});
                return !shellControl.command(commandBuilder).withExceptionConverter(i::b).executeAndCheck();
            }
        });
    }

    protected CommandControl build(Consumer<CommandBuilder> consumer) {
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"kubectl"});
        consumer.accept(commandBuilder);
        return this.shellControl.command(commandBuilder).withExceptionConverter(i::b).elevated(this.cv());
    }

    public boolean R() {
        boolean bl = this.shellControl.command("kubectl --help").withExceptionConverter(i::b).executeAndCheck();
        boolean bl2 = this.cw();
        return bl && bl2;
    }

    public boolean cw() {
        Boolean bl = this.shellControl.view().findProgram("kubectl").map(filePath -> !filePath.startsWith("/mnt")).orElse(Boolean.TRUE);
        return bl;
    }

    public String ab() {
        String string = this.shellControl.command("kubectl version --client=true").withExceptionConverter(i::b).readStdoutOrThrow();
        Object object = Pattern.compile("GitVersion:\"(.+?)\"");
        if (((Matcher)(object = ((Pattern)object).matcher(string))).find()) {
            return "kubectl " + ((Matcher)object).group(1);
        }
        object = Pattern.compile("Client Version: (.+)");
        if (((Matcher)(object = ((Pattern)object).matcher(string))).find()) {
            return "kubectl " + ((Matcher)object).group(1);
        }
        return null;
    }

    public String f(FilePath filePath) {
        Object object = CommandBuilder.of().add(new String[]{"kubectl"});
        if (filePath != null) {
            object.add(new String[]{"--kubeconfig"}).addFile(filePath);
        }
        object.add(new String[]{"config", "current-context"});
        filePath = this.shellControl.command(object).withExceptionConverter(i::b).elevated(this.cv()).start();
        try {
            object = filePath.readStdoutOrThrow();
            String string = object;
            return string;
        }
        finally {
            if (filePath != null) {
                filePath.close();
            }
        }
    }

    public List<String> cx() {
        try (CommandControl commandControl = this.shellControl.command("kubectl config get-contexts -o name").withExceptionConverter(i::b).elevated(this.cv()).start();){
            String string2 = commandControl.readStdoutOrThrow();
            List<String> list = string2.lines().filter(string -> !string.isEmpty()).toList();
            return list;
        }
    }

    public List<String> cy() {
        try (CommandControl commandControl = this.shellControl.command("kubectl config view --minify -o jsonpath=\"{..namespace}\"").withExceptionConverter(i::b).elevated(this.cv()).start();){
            Object object = commandControl.readStdoutOrThrow();
            if (((String)object).isEmpty()) {
                List<String> list = List.of();
                return list;
            }
            String[] stringArray = ((String)object).split("\\s+");
            object = Arrays.asList(stringArray);
            return object;
        }
    }

    public a a(ContextualFileReference contextualFileReference, String string, String string2) {
        return new a(this, contextualFileReference, string, string2);
    }

    public /* synthetic */ CommandView start() {
        return this.cu();
    }

    public class a
    extends CommandView {
        private final ContextualFileReference dY;
        private final String dZ;
        private final String ea;
        private /* synthetic */ i eb;

        public a(i i2, ContextualFileReference contextualFileReference, String string, String string2) {
            i i3 = i2;
            Objects.requireNonNull(i3);
            this.eb = i3;
            this.dY = contextualFileReference;
            this.dZ = string;
            this.ea = string2;
        }

        public String cz() {
            String string = this.build(commandBuilder -> commandBuilder.add(new String[]{"config", "view", "--minify", "-o", "jsonpath=\"{.clusters[].name}\""})).readStdoutOrThrow();
            return string;
        }

        protected CommandControl build(Consumer<CommandBuilder> consumer) {
            return this.eb.build(commandBuilder -> {
                this.B((CommandBuilder)commandBuilder);
                consumer.accept((CommandBuilder)commandBuilder);
            });
        }

        protected ShellControl getShellControl() {
            return this.eb.getShellControl();
        }

        public a cA() {
            this.eb.shellControl.start();
            return this;
        }

        protected void B(CommandBuilder commandBuilder) {
            CommandBuilder commandBuilder2 = CommandBuilder.of();
            commandBuilder2.add(new String[]{"--context"}).addQuoted(this.dZ);
            if (this.ea != null) {
                commandBuilder2.add(new String[]{"--namespace"}).addQuoted(this.ea);
            }
            if (this.dY != null) {
                commandBuilder2.add(new String[]{"--kubeconfig"}).addFile(arg_0 -> ((ContextualFileReference)this.dY).toAbsoluteFilePath(arg_0));
            }
            commandBuilder.add(1, commandBuilder2);
        }

        public String ax(String string) {
            string = this.build(commandBuilder -> commandBuilder.add(new String[]{"describe", "pod"}).addQuoted(string));
            return string.readStdoutOrThrow();
        }

        public String ay(String string) {
            string = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "pod"}).addQuoted(string).add(new String[]{"-o", "yaml"}));
            return string.readStdoutOrThrow();
        }

        public void az(String string) {
            string = this.eb.shellControl.view().writeTextFileDeterministic(this.eb.shellControl.getSystemTemporaryDirectory().join(new String[]{"pod.yml"}), string);
            this.build(arg_0 -> a.a((FilePath)string, arg_0)).execute();
        }

        public boolean cB() {
            Object object;
            try {
                object = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "nodes", "-o=json", "--request-timeout", "5s"}));
                object = object.readStdoutOrThrow();
            }
            catch (ProcessOutputException processOutputException) {
                ProcessOutputException processOutputException2 = processOutputException;
                if (processOutputException.getOutput().contains("nodes is forbidden")) {
                    return false;
                }
                throw processOutputException2;
            }
            return !((String)object).contains("minikube") && !((String)object).contains("rancher") && !((String)object).contains("Rancher") && !((String)object).contains("k3s") && !((String)object).contains("k3d") && !((String)object).contains("K0s") && !((String)object).contains("kubeadm") && !((String)object).contains("microk8s") && !((String)object).contains("MicroK8s");
        }

        public List<DataStoreEntryRef<l>> h(DataStoreEntryRef<e> object) {
            CommandControl commandControl = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "pods", "-o=\"custom-columns=NAMESPACE:.metadata.namespace,NAME:.metadata.name,STATUS:.status.phase\""}));
            commandControl = commandControl.start();
            try {
                String string2 = commandControl.readStdoutOrThrow();
                object = string2.lines().skip(1L).map(string -> string.split("\\s+")).map(stringArray -> {
                    object = new l((DataStoreEntryRef<e>)object, stringArray[1]);
                    DataStoreEntry dataStoreEntry = DataStoreEntry.createNew((String)object.getPodName(), (DataStore)object);
                    object = ((l.c.a)((Object)((Object)((l.c.a)((Object)((Object)((l.c)object.getState()).toBuilder().podState(stringArray[2])))).running("Running".equals(stringArray[2]))))).build();
                    dataStoreEntry.setStorePersistentState((DataStoreState)object);
                    return dataStoreEntry.ref();
                }).toList();
                return object;
            }
            finally {
                if (commandControl != null) {
                    commandControl.close();
                }
            }
        }

        public List<DataStoreEntryRef<j>> a(DataStoreEntryRef<l> object) {
            Object object2 = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "pods", ((l)object.getStore()).getPodName(), "-o"}).addQuoted("jsonpath={.status.phase}"));
            object2 = object2.readStdoutOrThrow();
            object2 = ((l.c.a)((Object)((l.c.a)((Object)((l.c)((l)object.getStore()).getState()).toBuilder().podState((String)object2))).running("Running".equals(object2)))).build();
            ((l)object.getStore()).setState((DataStoreState)object2);
            object2 = this.build(commandBuilder -> commandBuilder.add(new String[]{"get", "pods"}).addQuoted(((l)object.getStore()).getPodName()).add(new String[]{"--output"}).addQuoted("custom-columns=Namespace:.metadata.namespace,Containers:.spec.containers[*].name,Status:.status.phase,Image:.spec.containers[*].image"));
            object2 = object2.start();
            try {
                String string2 = object2.readStdoutOrThrow();
                object = string2.lines().skip(1L).map(string -> string.split("\\s+")).flatMap(stringArray -> {
                    List<String> list = Arrays.stream(stringArray[1].split(",")).toList();
                    List<String> list2 = Arrays.stream(stringArray[3].split(",")).toList();
                    return IntStream.range(0, list.size()).mapToObj(n2 -> {
                        object = new j((DataStoreEntryRef<l>)object, (String)list.get(n2));
                        list = DataStoreEntry.createNew((String)object.getContainerName(), (DataStore)object);
                        stringArray = ((ContainerStoreState.ContainerStoreStateBuilder)((ContainerStoreState)object.getState()).toBuilder().containerState(stringArray[2]).running(Boolean.valueOf("Running".equals(stringArray[2])))).imageName((String)list2.get(Math.min(n2, list2.size() - 1))).build();
                        object.setState((DataStoreState)stringArray);
                        list.setStorePersistentState((DataStoreState)stringArray);
                        return list.ref();
                    });
                }).toList();
                return object;
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        }

        public ShellControl j(String string, String string2) {
            ShellControl shellControl = this.eb.shellControl.subShell();
            shellControl.setDumbOpen((ShellOpenFunction)this.a(string, string2, false));
            shellControl.setTerminalOpen((ShellOpenFunction)this.a(string, string2, true));
            return shellControl.withExceptionConverter(i::b).elevated(this.eb.cv());
        }

        private 1 a(String string, String string2, boolean bl) {
            return new ShellOpenFunction(){
                private /* synthetic */ String ec;
                private /* synthetic */ String ed;
                private /* synthetic */ boolean aH;
                private /* synthetic */ a ee;
                {
                    this.ec = string;
                    this.ed = string2;
                    this.aH = bl;
                    a a3 = a2;
                    Objects.requireNonNull(a3);
                    this.ee = a3;
                }

                public final CommandBuilder prepareWithoutInitCommand() {
                    return this.ee.b(this.ec, this.ed, this.aH).add(new String[]{"--"}).add(new String[]{ShellDialects.SH.getLaunchCommand().loginCommand()});
                }

                public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                    if (string == null) {
                        throw new NullPointerException("command is marked non-null but is null");
                    }
                    return this.ee.b(this.ec, this.ed, this.aH).add(new String[]{"--"}).add(new String[]{string});
                }
            };
        }

        public CommandBuilder b(String string, String string2, boolean bl) {
            string = CommandBuilder.of().add(new String[]{"kubectl", "exec", "-i"}).addIf(bl, new String[]{"-t"}).addQuoted(string).add(new String[]{"--container"}).addQuoted(string2);
            this.B((CommandBuilder)string);
            return string;
        }

        public /* synthetic */ CommandView start() {
            return this.cA();
        }

        private static /* synthetic */ void a(FilePath filePath, CommandBuilder commandBuilder) {
            commandBuilder.add(new String[]{"apply", "-f"}).addFile(filePath);
        }
    }
}

