/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.k8s;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ContainerImageStore;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.proc.k8s.e;
import io.xpipe.ext.proc.k8s.g;
import io.xpipe.ext.proc.k8s.l;
import java.util.Objects;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="k8sContainer")
@JsonDeserialize(builder=b.class)
public final class j
implements ContainerImageStore,
FixedChildStore,
ShellStore,
StatefulDataStore<ContainerStoreState> {
    private final DataStoreEntryRef<l> pod;
    private final String containerName;

    public j(DataStoreEntryRef<l> dataStoreEntryRef, String string) {
        this.pod = dataStoreEntryRef;
        this.containerName = string;
    }

    public final Class<ContainerStoreState> getStateClass() {
        return ContainerStoreState.class;
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.containerName));
    }

    public final void checkComplete() {
        Validators.nonNull(this.pod);
        Validators.isType(this.pod, l.class);
        this.pod.checkComplete();
        Validators.nonNull((Object)this.containerName);
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(this){
            private /* synthetic */ j ef;
            {
                j j3 = j2;
                Objects.requireNonNull(j3);
                this.ef = j3;
            }

            public final ShellControl control(ShellControl shellControl) {
                shellControl = ((e)((l)this.ef.pod.getStore()).getCluster().getStore()).commandView(shellControl).j(((l)this.ef.pod.getStore()).getPodName(), this.ef.containerName);
                shellControl.withSourceStore((DataStore)this.ef);
                shellControl.withShellStateInit((StatefulDataStore)this.ef);
                shellControl.onStartupFail(throwable -> {
                    if (throwable instanceof LicenseRequiredException) {
                        return;
                    }
                    boolean bl = throwable.getMessage() == null || !throwable.getMessage().contains("OCI runtime exec failed");
                    if (!bl) {
                        this.ef.setState((DataStoreState)((ContainerStoreState)this.ef.getState()).toBuilder().shellMissing(Boolean.TRUE).build());
                    }
                });
                if (((e.c)((e)((l)this.ef.getPod().getStore()).getCluster().getStore()).getState()).isEnterprise()) {
                    shellControl.requireLicensedFeature(LicenseProvider.get().getFeature("k8sCommercial"));
                }
                return shellControl;
            }

            public final ShellStore getParentStore() {
                return (ShellStore)((g)((e)((l)this.ef.getPod().getStore()).getCluster().getStore()).getCmd().getStore()).getHost().getStore();
            }
        };
    }

    public final String getImageName() {
        return ((ContainerStoreState)this.getState()).getImageName();
    }

    @Generated
    protected j(a<?, ?> a2) {
        this.pod = a2.pod;
        this.containerName = a2.containerName;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<l> getPod() {
        return this.pod;
    }

    @Generated
    public final String getContainerName() {
        return this.containerName;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof j)) {
            return false;
        }
        object = (j)object;
        Object object2 = this.getPod();
        DataStoreEntryRef<l> dataStoreEntryRef = ((j)object).getPod();
        if (object2 == null ? dataStoreEntryRef != null : !object2.equals(dataStoreEntryRef)) {
            return false;
        }
        object2 = this.getContainerName();
        object = ((j)object).getContainerName();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<l> dataStoreEntryRef = this.getPod();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        String string = this.getContainerName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "K8sContainerStore(pod=" + String.valueOf(this.getPod()) + ", containerName=" + this.getContainerName() + ")";
    }

    @Generated
    public static abstract class a<C extends j, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<l> pod;
        @Generated
        private String containerName;

        @Generated
        public B pod(DataStoreEntryRef<l> dataStoreEntryRef) {
            this.pod = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B containerName(String string) {
            this.containerName = string;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "K8sContainerStore.K8sContainerStoreBuilder(pod=" + String.valueOf(this.pod) + ", containerName=" + this.containerName + ")";
        }
    }

    @JsonTypeName(value="k8sContainer")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<j, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final j build() {
            return new j(this);
        }
    }
}

