/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.proxmox;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.process.BaseElevationHandler;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableFunction;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.proxmox.i;
import io.xpipe.ext.proc.proxmox.j;
import io.xpipe.ext.proc.proxmox.l;
import io.xpipe.ext.proc.ssh.g;
import io.xpipe.ext.proc.vm.d;
import io.xpipe.ext.proc.vm.e;
import io.xpipe.ext.proc.vm.h;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="proxmoxContainer")
@JsonDeserialize(builder=b.class)
public final class f
extends i<h> {
    @Override
    protected final e<?> withUseGatewayOption(Boolean bl) {
        return ((a)this.toBuilder().dontUseGateway(bl)).build();
    }

    public final boolean isConfiguredForSsh() {
        return this.port != null && this.identity != null && this.identity.unwrap().getPassword() != null && this.identity.unwrap().getSshIdentity() != null;
    }

    public final CommandControl createLxcTerminalCommand() {
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"pct", "exec", "" + this.getVmid(), "--", "su", "-l"});
        return ((ShellStore)this.getHypervisorHost().getStore()).standaloneControl().command(commandBuilder);
    }

    public final ShellControl createLxcShell() {
        Object object = new ShellOpenFunction(this){
            private /* synthetic */ f eP;
            {
                f f3 = f2;
                Objects.requireNonNull(f3);
                this.eP = f3;
            }

            public final CommandBuilder prepareWithoutInitCommand() {
                CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"pct", "exec", "" + this.eP.getVmid(), "--", "su", "-l"});
                if (this.eP.identity != null && this.eP.identity.unwrap().getUsername().hasUser()) {
                    commandBuilder.addQuoted(this.eP.identity.unwrap().getUsername().retrieveUsername());
                }
                return commandBuilder;
            }

            public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                if (string == null) {
                    throw new NullPointerException("command is marked non-null but is null");
                }
                CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"pct", "exec", "" + this.eP.getVmid(), "--", "su", "-l"});
                if (this.eP.identity != null && this.eP.identity.unwrap().getUsername().hasUser()) {
                    commandBuilder.addQuoted(this.eP.identity.unwrap().getUsername().retrieveUsername());
                }
                return commandBuilder.add(new String[]{"-c"}).addLiteral(string);
            }
        };
        ShellControl shellControl = ((ShellStore)this.getHypervisorHost().getStore()).standaloneControl().subShell();
        shellControl.setDumbOpen((ShellOpenFunction)object);
        shellControl.setTerminalOpen((ShellOpenFunction)object);
        shellControl.elevated(j.cv()).withSourceStore((DataStore)this);
        if (this.identity != null && this.identity.unwrap().getPassword() != null) {
            f f2 = this;
            shellControl.setElevationHandler(new BaseElevationHandler((DataStore)f2, f2.identity.unwrap().getPassword()).orElse(shellControl.getElevationHandler()));
        }
        shellControl.onInit(shellControl2 -> {
            shellControl2 = shellControl.getOriginalShellDialect();
            h h2 = (h)this.getState();
            shellControl = ((h.a)((Object)((Object)((h.a)((Object)((Object)((h.a)((Object)((Object)((h.a)((Object)((Object)h2.toBuilder().osType(shellControl.getOsType())))).shellDialect((ShellDialect)(shellControl2.isMarkerDialect() ? h2.getShellDialect() : shellControl2))))).running(Boolean.TRUE)))).osName(shellControl.getOsName())))).build();
            this.setState((h)shellControl.asNeeded());
        });
        shellControl.onStartupFail(throwable -> {
            if (throwable instanceof LicenseRequiredException) {
                return;
            }
            boolean bl = throwable.getMessage() == null || !throwable.getMessage().contains("Failed to exec");
            if (!bl) {
                h.a<?, ?> a2 = ((h)this.getState()).toBuilder();
                a2.reachable(Boolean.TRUE);
                this.setState((h)a2.build().asNeeded());
            }
        });
        object = ((l)this.getInstall().getStore()).checkLicenseRequirement();
        if (((Optional)object).isPresent()) {
            shellControl.requireLicensedFeature((LicensedFeature)((Optional)object).get());
        }
        return shellControl;
    }

    @Override
    public final ShellControl createGuestShell() {
        boolean bl = this.isConfiguredForSsh();
        boolean bl2 = Boolean.TRUE.equals(((h)this.getState()).getReachable());
        if (bl && bl2) {
            return super.createGuestShell();
        }
        return this.createLxcShell();
    }

    @Override
    public final boolean isLocallyTunnelable() {
        if (!this.isConfiguredForSsh()) {
            return false;
        }
        return super.isLocallyTunnelable();
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (f)fixedChildStore;
        return ((a)((a)this.toBuilder().name(fixedChildStore.name)).identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    @Override
    public final void checkComplete() {
        Validators.nonNull(this.getHypervisorHost());
        Validators.isType(this.getHypervisorHost(), ShellStore.class);
        ((ShellStore)this.getHypervisorHost().getStore()).checkComplete();
        if (this.identity != null) {
            this.identity.checkComplete();
            this.identity.checkCompleteUser();
            this.identity.checkCompletePassword();
            this.identity.checkCompleteSshIdentity();
        }
        g.bd(this.additionalOptions);
        Validators.nonNull(this.install);
        Validators.isType(this.install, l.class);
        this.install.checkComplete();
    }

    @Override
    public final FailableFunction<CommandBuilder, Boolean, Exception> guestExecPredicate(ShellControl shellControl) {
        return commandBuilder -> {
            commandBuilder = commandBuilder.add(0, new String[]{"pct", "exec", "" + this.vmid, "--"});
            boolean bl = shellControl.command(commandBuilder).elevated(j.cv()).executeAndCheck();
            return bl;
        };
    }

    @Override
    public final Class<h> getStateClass() {
        return h.class;
    }

    @Override
    public final void prepareGuestShell(ShellControl shellControl) {
        Optional<LicensedFeature> optional = ((l)this.getInstall().getStore()).checkLicenseRequirement();
        if (optional.isPresent()) {
            shellControl.requireLicensedFeature(optional.get());
        }
    }

    @Override
    public final void updateGuestState(ShellControl shellControl) {
        this.refreshRunningState(shellControl);
        if (!((h)this.getState()).getRunning().booleanValue()) {
            this.setCache("reachableCheck", null);
            return;
        }
        h.a<?, ?> a2 = ((h)this.getState()).toBuilder();
        if (this.getCustomIp() == null || !this.getCustomIp().use()) {
            Optional<String> optional = j.b(shellControl, this.vmid);
            if (optional.isEmpty()) {
                this.setState(((h.a)((Object)((h.a)((Object)a2.ip(null))).reachable(Boolean.FALSE))).build());
                return;
            }
            a2.ip(optional.get());
            this.setState(a2.build());
        }
        boolean bl = (Boolean)this.getCache("reachableCheck", Boolean.class, Boolean.FALSE) != false || io.xpipe.ext.proc.network.g.b(shellControl, this.getEffectiveIp(), this.getPort() != null ? this.getPort() : 22);
        this.setCache("reachableCheck", bl);
        a2.reachable(bl);
        if (!bl) {
            OsType.Any any = this.guestExecPredicate(shellControl);
            any = io.xpipe.ext.proc.util.f.a(any);
            a2.reachable(d.a(this, shellControl, any));
        }
        this.setState(a2.build());
    }

    private void refreshRunningState(ShellControl object) {
        Object object2 = (h)this.getState();
        object2 = ((h)((Object)object2)).toBuilder();
        ((h.a)((Object)object2)).stateString((object = j.e((ShellControl)object, this.vmid)) != null ? ((String)object).toLowerCase() : null);
        boolean bl = "RUNNING".equals(object);
        if (!bl) {
            this.setCache("reachableCheck", null);
        }
        ((h.a)((Object)object2)).running(bl);
        this.setState(((h.a)((Object)object2)).build());
    }

    public final void start() {
        ((l)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((l)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"pct", "start", "" + this.vmid})).elevated(j.cv()).execute();
        this.refreshRunningState(shellControl);
    }

    public final void stop() {
        ((l)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((l)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"pct", "stop", "" + this.vmid})).elevated(j.cv()).execute();
        this.refreshRunningState(shellControl);
    }

    public final void pause() {
        ((l)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((l)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"pct", "suspend", "" + this.vmid})).elevated(j.cv()).execute();
        this.refreshRunningState(shellControl);
    }

    @Generated
    protected f(a<?, ?> a2) {
        super(a2);
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof f)) {
            return false;
        }
        f f2 = (f)object;
        if (!f2.canEqual(this)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof f;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "ProxmoxContainerStore(super=" + super.toString() + ")";
    }

    @Generated
    public static abstract class a<C extends f, B extends a<C, B>>
    extends i.a<h, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(f f2, a<?, ?> a2) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ProxmoxContainerStore.ProxmoxContainerStoreBuilder(super=" + super.toString() + ")";
        }
    }

    @JsonTypeName(value="proxmoxContainer")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<f, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final f build() {
            return new f(this);
        }
    }
}

