/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.proxmox;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableFunction;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.network.g;
import io.xpipe.ext.proc.proxmox.i;
import io.xpipe.ext.proc.proxmox.j;
import io.xpipe.ext.proc.proxmox.l;
import io.xpipe.ext.proc.proxmox.u;
import io.xpipe.ext.proc.util.f;
import io.xpipe.ext.proc.vm.d;
import io.xpipe.ext.proc.vm.e;
import io.xpipe.ext.proc.vm.h;
import java.util.Optional;
import lombok.Generated;

@JsonTypeName(value="proxmoxVm")
@JsonDeserialize(builder=b.class)
public final class s
extends i<u> {
    @Override
    public final void checkComplete() {
        super.checkComplete();
        Validators.nonNull(this.install);
        Validators.isType(this.install, l.class);
        this.install.checkComplete();
    }

    @Override
    protected final e<?> withUseGatewayOption(Boolean bl) {
        return ((a)this.toBuilder().dontUseGateway(bl)).build();
    }

    public final CommandControl monitorCommand() {
        return ((ShellStore)((l)this.getInstall().getStore()).getHost().getStore()).getOrStartSession().command(commandBuilder -> commandBuilder.add(new String[]{"qm", "monitor", "" + this.getVmid()})).elevated(j.cv());
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (s)fixedChildStore;
        return ((a)((a)this.toBuilder().name(fixedChildStore.name)).identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    @Override
    public final FailableFunction<CommandBuilder, Boolean, Exception> guestExecPredicate(ShellControl shellControl) {
        return commandBuilder -> {
            if (((Optional)(shellControl = shellControl.command(commandBuilder = commandBuilder.add(0, new String[]{"qm", "guest", "exec", "" + this.vmid, "--"})).elevated(j.cv()).readStdoutIfPossible())).isEmpty()) {
                return Boolean.FALSE;
            }
            shellControl = JacksonMapper.getDefault().readTree((String)((Optional)shellControl).get());
            if (!shellControl.isObject() || !shellControl.has("exitcode")) {
                return Boolean.FALSE;
            }
            int n2 = shellControl.required("exitcode").asInt();
            return n2 == 0;
        };
    }

    @Override
    public final Class<u> getStateClass() {
        return u.class;
    }

    @Override
    public final void prepareGuestShell(ShellControl shellControl) {
        Optional<LicensedFeature> optional = ((l)this.getInstall().getStore()).checkLicenseRequirement();
        if (optional.isPresent()) {
            shellControl.requireLicensedFeature(optional.get());
        }
    }

    @Override
    protected final Exception createReachableException() {
        Exception exception = super.createReachableException();
        ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)exception).documentationLink(DocumentationLink.PROXMOX_NETWORKING));
        return exception;
    }

    @Override
    public final void updateGuestState(ShellControl shellControl) {
        this.refreshRunningState(shellControl);
        if (!((u)this.getState()).getRunning().booleanValue()) {
            this.setCache("reachableCheck", null);
            return;
        }
        h.a a2 = ((u)this.getState()).toBuilder();
        if (this.getCustomIp() == null || !this.getCustomIp().use()) {
            j.a(shellControl, this.vmid);
            Object object = j.c(shellControl, this.vmid);
            if (((Optional)object).isEmpty()) {
                this.setState(((u.a)((Object)((u.a)((Object)a2.ip(null))).reachable(Boolean.FALSE))).build());
                object = new IllegalStateException("Unable to determine external IP address for vm " + this.name + " via network-get-interfaces\n\nIs the VM fully started up, has the network interface initialized, and is the QEMU guest agent running on the guest?");
                ErrorEvent.ErrorEventBuilder errorEventBuilder = ErrorEventFactory.fromThrowable((Throwable)object).expected().documentationLink(DocumentationLink.PROXMOX_NETWORKING);
                ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)errorEventBuilder);
                throw object;
            }
            a2.ip((String)((Optional)object).get());
            this.setState(((u.a)a2).build());
        }
        boolean bl = (Boolean)this.getCache("reachableCheck", Boolean.class, Boolean.FALSE) != false || g.b(shellControl, this.getEffectiveIp(), this.getPort() != null ? this.getPort() : 22);
        this.setCache("reachableCheck", bl);
        a2.reachable(bl);
        if (!bl) {
            FailableFunction<CommandBuilder, Boolean, Exception> failableFunction = this.guestExecPredicate(shellControl);
            OsType.Any any = f.a(failableFunction);
            a2.reachable(d.a(this, shellControl, any));
        }
        this.setState(((u.a)a2).build());
    }

    private void refreshRunningState(ShellControl object) {
        Object object2 = (u)this.getState();
        object2 = ((u)((Object)object2)).toBuilder();
        object = j.d(object, this.vmid);
        ((h.a)((Object)object2)).stateString((String)object);
        boolean bl = "running".equals(object);
        if (!bl) {
            this.setCache("reachableCheck", null);
        }
        ((h.a)((Object)object2)).running(bl);
        this.setState(((u.a)((Object)object2)).build());
    }

    public final void start() {
        ((l)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((l)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        String string = shellControl.command(CommandBuilder.of().add(new String[]{"qm", "status", "" + this.getVmid()})).elevated(j.cv()).readStdoutOrThrow();
        shellControl.command(CommandBuilder.of().add(new String[]{"qm", string.contains("paused") || string.contains("suspended") ? "resume" : "start", "" + this.getVmid()})).elevated(j.cv()).execute();
        this.refreshRunningState(shellControl);
    }

    public final void stop() {
        ((l)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((l)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"qm", "stop", "" + this.getVmid()})).elevated(j.cv()).execute();
        this.refreshRunningState(shellControl);
    }

    public final void pause() {
        ((l)this.getInstall().getStore()).checkLicenseOrThrow();
        ShellControl shellControl = ((ShellStore)((l)this.getInstall().getStore()).getHost().getStore()).getOrStartSession();
        shellControl.command(CommandBuilder.of().add(new String[]{"qm", "suspend", "" + this.getVmid()})).elevated(j.cv()).execute();
        this.refreshRunningState(shellControl);
    }

    @Generated
    protected s(a<?, ?> a2) {
        super(a2);
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof s)) {
            return false;
        }
        s s2 = (s)object;
        if (!s2.canEqual(this)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof s;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "ProxmoxVmStore(super=" + super.toString() + ")";
    }

    @Generated
    public static abstract class a<C extends s, B extends a<C, B>>
    extends i.a<u, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(s s2, a<?, ?> a2) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ProxmoxVmStore.ProxmoxVmStoreBuilder(super=" + super.toString() + ")";
        }
    }

    @JsonTypeName(value="proxmoxVm")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<s, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final s build() {
            return new s(this);
        }
    }
}

