/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.KeyValue;
import io.xpipe.ext.base.host.HostAddressSwitchStore;
import io.xpipe.ext.base.identity.IdentitySwitchStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.e;
import io.xpipe.ext.proc.ssh.g;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;

@JsonTypeName(value="ssh")
@JsonDeserialize(builder=b.class)
public final class A
extends e<ShellStoreState>
implements HostAddressSwitchStore {
    private final DataStoreEntryRef<NetworkTunnelStore> proxy;
    private final Boolean useGatewayWithProxyJump;
    private final HostAddress host;
    private final Integer port;
    private final IdentityValue identity;
    private final Boolean dontInteractWithSystem;
    private final Boolean forwardX11;
    private final String additionalOptions;

    public final Class<ShellStoreState> getStateClass() {
        return ShellStoreState.class;
    }

    public final void checkComplete() {
        Validators.nonNull(this.proxy);
        Validators.isType(this.proxy, NetworkTunnelStore.class);
        Validators.nonNull((Object)this.host);
        Validators.nonNull((Object)this.port);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompleteUser();
        this.identity.checkCompletePassword();
        this.identity.checkCompleteSshIdentity();
        this.proxy.checkComplete();
        g g2 = g.bd(this.additionalOptions);
        if (g2.dH().size() > 1) {
            throw new ValidationException("Additional option config contains multiple host entries");
        }
        this.checkValidGatewayChain();
    }

    public final boolean isPerUser() {
        return this.identity.isPerUser();
    }

    @Override
    public final g toConfigHost() {
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        arrayList.add(new KeyValue("HostName", this.host.get()));
        arrayList.add(new KeyValue("Port", String.valueOf(this.port)));
        arrayList.add(new KeyValue("User", ((e)this).getUser().retrieveUsername()));
        g g2 = this.getAdditionalOptions();
        if (g2 != null) {
            arrayList.addAll(g2.dF().dQ());
        }
        return new g(new g.a(this.distinctConfigHostName(), arrayList));
    }

    @Override
    protected final boolean dontInteractWithSystem() {
        if (this.dontInteractWithSystem != null) {
            return this.dontInteractWithSystem;
        }
        return false;
    }

    @Override
    protected final boolean hasX11Forward() {
        return this.forwardX11 != null && this.forwardX11 != false;
    }

    @Override
    public final SecretRetrievalStrategy getPassword() {
        SecretRetrievalStrategy secretRetrievalStrategy = this.identity.unwrap().getPassword();
        if (secretRetrievalStrategy != null) {
            return secretRetrievalStrategy;
        }
        return new SecretNoneStrategy();
    }

    @Override
    public final DataStoreEntryRef<NetworkTunnelStore> getTunnelGateway() {
        return this.proxy;
    }

    @Override
    public final boolean useGatewayWithProxyJump() {
        return this.useGatewayWithProxyJump != null && this.useGatewayWithProxyJump != false;
    }

    @Override
    public final HostAddress getHostAddress() {
        return this.host;
    }

    @Override
    public final UsernameStrategy getUser() {
        return this.identity.unwrap().getUsername();
    }

    @Override
    public final int getPort() {
        if (this.port != null) {
            return this.port;
        }
        return 22;
    }

    @Override
    public final CommandBuilder buildBaseCommand() {
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"-p", "" + this.getEffectivePort()}).addQuoted(((e)this).getUser().retrieveUsername() + "@" + this.getEffectiveHostName());
        return commandBuilder;
    }

    @Override
    public final SshIdentityStrategy getIdentityStrategy() {
        SshIdentityStrategy sshIdentityStrategy = this.identity.unwrap().getSshIdentity();
        if (sshIdentityStrategy != null) {
            return sshIdentityStrategy;
        }
        return new NoIdentityStrategy();
    }

    @Override
    protected final boolean hasTunnels() {
        return false;
    }

    @Override
    protected final g getAdditionalOptions() {
        if (this.additionalOptions != null) {
            g g2 = g.bd(this.additionalOptions);
            return g2;
        }
        return null;
    }

    public final Optional<HostAddressSwitchStore> withAddress(String string) {
        return Optional.of(((a)this.toBuilder().host(this.getHost().withValue(string))).build());
    }

    public final IdentitySwitchStore withIdentity(IdentityValue identityValue) {
        return ((a)this.toBuilder().identity(identityValue)).build();
    }

    @Generated
    protected A(a<?, ?> a2) {
        super(a2);
        this.proxy = a2.proxy;
        this.useGatewayWithProxyJump = a2.useGatewayWithProxyJump;
        this.host = a2.host;
        this.port = a2.port;
        this.identity = a2.identity;
        this.dontInteractWithSystem = a2.dontInteractWithSystem;
        this.forwardX11 = a2.forwardX11;
        this.additionalOptions = a2.additionalOptions;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<NetworkTunnelStore> getProxy() {
        return this.proxy;
    }

    @Generated
    public final Boolean getUseGatewayWithProxyJump() {
        return this.useGatewayWithProxyJump;
    }

    @Generated
    public final HostAddress getHost() {
        return this.host;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final Boolean getDontInteractWithSystem() {
        return this.dontInteractWithSystem;
    }

    @Generated
    public final Boolean getForwardX11() {
        return this.forwardX11;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof A)) {
            return false;
        }
        Object object2 = (A)object;
        if (!((A)object2).canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getUseGatewayWithProxyJump();
        HostAddress hostAddress = ((A)object2).getUseGatewayWithProxyJump();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        if (((e)this).getPort() != ((e)object2).getPort()) {
            return false;
        }
        object = this.getDontInteractWithSystem();
        hostAddress = ((A)object2).getDontInteractWithSystem();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getForwardX11();
        hostAddress = ((A)object2).getForwardX11();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getProxy();
        hostAddress = ((A)object2).getProxy();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getHost();
        hostAddress = ((A)object2).getHost();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getIdentity();
        hostAddress = ((A)object2).getIdentity();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getAdditionalOptions();
        object2 = ((A)object2).getAdditionalOptions();
        return !(object == null ? object2 != null : !object.equals(object2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof A;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getUseGatewayWithProxyJump();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        n2 = n2 * 59 + ((e)this).getPort();
        object = this.getDontInteractWithSystem();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getForwardX11();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getProxy();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getHost();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAdditionalOptions();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "SshStore(super=" + super.toString() + ", proxy=" + String.valueOf(this.getProxy()) + ", useGatewayWithProxyJump=" + this.getUseGatewayWithProxyJump() + ", host=" + String.valueOf(this.getHost()) + ", port=" + ((e)this).getPort() + ", identity=" + String.valueOf(this.getIdentity()) + ", dontInteractWithSystem=" + this.getDontInteractWithSystem() + ", forwardX11=" + this.getForwardX11() + ", additionalOptions=" + String.valueOf(this.getAdditionalOptions()) + ")";
    }

    @Generated
    public static abstract class a<C extends A, B extends a<C, B>>
    extends e.a<ShellStoreState, C, B> {
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> proxy;
        @Generated
        private Boolean useGatewayWithProxyJump;
        @Generated
        private HostAddress host;
        @Generated
        private Integer port;
        @Generated
        private IdentityValue identity;
        @Generated
        private Boolean dontInteractWithSystem;
        @Generated
        private Boolean forwardX11;
        @Generated
        private String additionalOptions;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(A a2, a<?, ?> a3) {
            a3.proxy(a2.proxy);
            a3.useGatewayWithProxyJump(a2.useGatewayWithProxyJump);
            a3.host(a2.host);
            a3.port(a2.port);
            a3.identity(a2.identity);
            a3.dontInteractWithSystem(a2.dontInteractWithSystem);
            a3.forwardX11(a2.forwardX11);
            a3.additionalOptions(a2.additionalOptions);
        }

        @Generated
        public B proxy(DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef) {
            this.proxy = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B useGatewayWithProxyJump(Boolean bl) {
            this.useGatewayWithProxyJump = bl;
            return (B)this.self();
        }

        @Generated
        public B host(HostAddress hostAddress) {
            this.host = hostAddress;
            return (B)this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Generated
        public B dontInteractWithSystem(Boolean bl) {
            this.dontInteractWithSystem = bl;
            return (B)this.self();
        }

        @Generated
        public B forwardX11(Boolean bl) {
            this.forwardX11 = bl;
            return (B)this.self();
        }

        @Generated
        public B additionalOptions(String string) {
            this.additionalOptions = string;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SshStore.SshStoreBuilder(super=" + super.toString() + ", proxy=" + String.valueOf(this.proxy) + ", useGatewayWithProxyJump=" + this.useGatewayWithProxyJump + ", host=" + String.valueOf(this.host) + ", port=" + this.port + ", identity=" + String.valueOf(this.identity) + ", dontInteractWithSystem=" + this.dontInteractWithSystem + ", forwardX11=" + this.forwardX11 + ", additionalOptions=" + this.additionalOptions + ")";
        }
    }

    @JsonTypeName(value="ssh")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<A, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final A build() {
            return new A(this);
        }
    }
}

