/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.hub.action.StoreAction;
import io.xpipe.app.hub.action.impl.InitHubLeafProvider;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.OsFileSystem;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.SecretQueryResult;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.WindowsRegistry;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.identity.ssh.InPlaceKeyStrategy;
import io.xpipe.ext.base.identity.ssh.KeyFileStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.e;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public final class J
extends InitHubLeafProvider<e<?>, Path> {
    protected final Path et() {
        if (OsType.ofLocal() != OsType.WINDOWS) {
            return null;
        }
        try (ShellControl shellControl = LocalShell.getShell().start();){
            Object object2 = shellControl.view().findProgram("WinSCP.exe");
            if (((Optional)object2).isPresent()) {
                Path path2 = ((FilePath)((Optional)object2).get()).asLocalPath();
                return path2;
            }
            Optional optional = WindowsRegistry.local().readStringValueIfPresent(-2147483647, "Software\\Classes\\WinSCP.Url\\DefaultIcon");
            if (optional.isEmpty()) {
                optional = WindowsRegistry.local().readStringValueIfPresent(-2147483646, "Software\\Classes\\WinSCP.Url\\DefaultIcon");
            }
            object2 = optional.flatMap(object -> {
                object = Pattern.compile("\"(.+)\",\\d+").matcher((CharSequence)object);
                if (((Matcher)object).matches()) {
                    return Optional.of(Paths.get(((Matcher)object).group(1), new String[0]));
                }
                return Optional.empty();
            }).filter(path -> Files.exists(path, new LinkOption[0])).orElse(null);
            return object2;
        }
    }

    public final ObservableValue<String> getName(DataStoreEntryRef<e<?>> dataStoreEntryRef) {
        return AppI18n.observable((String)"openWinScp", (Object[])new Object[0]);
    }

    public final LabelGraphic getIcon(DataStoreEntryRef<e<?>> dataStoreEntryRef) {
        return new LabelGraphic.IconGraphic("mdi2o-open-in-app");
    }

    public final Class<?> getApplicableClass() {
        return e.class;
    }

    public final String getId() {
        return "openSshWinScp";
    }

    public final boolean isApplicable(DataStoreEntryRef<e<?>> dataStoreEntryRef) {
        return ((e)dataStoreEntryRef.getStore()).isLocalClient();
    }

    protected final /* synthetic */ Object check() {
        return this.et();
    }

    @JsonDeserialize(builder=b.class)
    public static class io.xpipe.ext.proc.ssh.J$a
    extends StoreAction<e<?>> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void executeImpl() {
            Path path = (Path)((J)this.getProvider()).available;
            if (path == null) {
                return;
            }
            try (ShellControl shellControl = LocalShell.getShell().start();){
                String string;
                FilePath filePath;
                InPlaceKeyStrategy inPlaceKeyStrategy;
                e e2 = (e)this.getRef().getStore();
                e2.startGatewayTunnelIfNeeded();
                FilePath filePath2 = null;
                SecretValue secretValue = null;
                SshIdentityStrategy sshIdentityStrategy = e2.getIdentityStrategy();
                if (sshIdentityStrategy instanceof KeyFileStrategy) {
                    KeyFileStrategy keyFileStrategy = (KeyFileStrategy)sshIdentityStrategy;
                    filePath2 = keyFileStrategy.getFile().toAbsoluteFilePath(shellControl);
                    if (keyFileStrategy.getAskpassStrategy().expectsQuery() && !keyFileStrategy.getAskpassStrategy().query().requiresUserInteraction()) {
                        SecretQueryResult secretQueryResult = keyFileStrategy.getAskpassStrategy().query().query("Passphrase for key");
                        secretValue = secretQueryResult.getSecret();
                    }
                } else {
                    SshIdentityStrategy sshIdentityStrategy2 = e2.getIdentityStrategy();
                    if (sshIdentityStrategy2 instanceof InPlaceKeyStrategy) {
                        inPlaceKeyStrategy = (InPlaceKeyStrategy)sshIdentityStrategy2;
                        Path path2 = AppSystemInfo.ofCurrent().getUserHome().resolve(".ssh", new String[]{OsFileSystem.ofLocal().makeFileSystemCompatible(this.ref.get().getName())});
                        if (!Files.exists(path2, new LinkOption[0])) {
                            Files.writeString(path2, (CharSequence)inPlaceKeyStrategy.getKey().getSecretValue(), new OpenOption[0]);
                        }
                        filePath2 = FilePath.of((Path)path2);
                        if (inPlaceKeyStrategy.getAskpassStrategy().expectsQuery() && !inPlaceKeyStrategy.getAskpassStrategy().query().requiresUserInteraction()) {
                            secretValue = inPlaceKeyStrategy.getAskpassStrategy().query().query("Passphrase for key");
                            secretValue = secretValue.getSecret();
                        }
                    }
                }
                if ((filePath = filePath2 != null ? FilePath.of((String)(filePath2.getBaseName().toString() + ".ppk")) : null) != null && !Files.exists(filePath.asLocalPath(), new LinkOption[0])) {
                    inPlaceKeyStrategy = CommandBuilder.of().addFile(String.valueOf(FilePath.of((Path)path).getBaseName()) + ".com").add(new String[]{"/console"}).add(new String[]{"/keygen"}).addFile(filePath2).addQuotedKeyValue("/output", filePath.toString()).addQuotedKeyValue("/comment", filePath2.getFileName() + ", converted by XPipe from OpenSSH format");
                    if (secretValue != null) {
                        inPlaceKeyStrategy.addQuotedKeyValue("/passphrase", secretValue.getSecretValue());
                    }
                    shellControl.command((CommandBuilder)inPlaceKeyStrategy).sensitive().execute();
                }
                inPlaceKeyStrategy = CommandBuilder.of().addFile(path).addLiteral(e2.getEffectiveHostName() + ":" + e2.getEffectivePort());
                if (filePath != null) {
                    inPlaceKeyStrategy.addQuotedKeyValue("/privatekey", filePath.toString());
                    if (secretValue != null) {
                        inPlaceKeyStrategy.addQuotedKeyValue("/passphrase", secretValue.getSecretValue());
                    }
                }
                if ((string = e2.getUser().hasUser() ? e2.getUser().retrieveUsername() : null) != null) {
                    inPlaceKeyStrategy.addQuotedKeyValue("/username", string);
                }
                if (e2.getPassword().expectsQuery() && (secretValue = e2.getPassword().query().query("Password for " + (string != null ? string : "?"))).getSecret() != null) {
                    inPlaceKeyStrategy.addQuotedKeyValue("/password", secretValue.getSecret().getSecretValue());
                }
                secretValue = shellControl.command((CommandBuilder)inPlaceKeyStrategy);
                secretValue.sensitive();
                secretValue.execute();
                if (shellControl == null) return;
            }
        }

        @Generated
        protected io.xpipe.ext.proc.ssh.J$a(a<?, ?> a2) {
            super(a2);
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<io.xpipe.ext.proc.ssh.J$a, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final io.xpipe.ext.proc.ssh.J$a build() {
                return new io.xpipe.ext.proc.ssh.J$a(this);
            }
        }

        @Generated
        public static abstract class a<C extends io.xpipe.ext.proc.ssh.J$a, B extends a<C, B>>
        extends StoreAction.StoreActionBuilder<e<?>, C, B> {
            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "SshWinScpOpenActionProvider.Action.ActionBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

