/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import io.xpipe.app.ext.FileEntry;
import io.xpipe.app.ext.FileInfo;
import io.xpipe.app.ext.FileKind;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.issue.TrackEvent;
import io.xpipe.app.process.LocalProcessInputStream;
import io.xpipe.app.process.OsFileSystem;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.Year;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

public final class b
implements FileSystem {
    private final ShellControl fa;
    private final byte[] fb = new byte[16834];
    private OsType.Any osType;
    private String fc = "";
    private static final SimpleDateFormat fd = new SimpleDateFormat("MMM dd hh:mm yyyy", Locale.US);
    private static final SimpleDateFormat fe = new SimpleDateFormat("MMM dd yyyy", Locale.US);

    public b(ShellControl shellControl) {
        this.fa = shellControl;
    }

    public final boolean writeInstantIfPossible(FileSystem fileSystem, FilePath object, FilePath filePath) {
        if (fileSystem.getShell().map(shellControl -> shellControl.isLocal()).orElse(Boolean.FALSE).booleanValue()) {
            b b2 = this;
            boolean bl = false;
            object = "put -f " + b2.h(object.toUnix()) + " " + this.h(filePath);
            fileSystem = b2;
            b2.a((String)object, false, bl);
            return true;
        }
        return false;
    }

    public final boolean readInstantIfPossible(FilePath object, FileSystem object2, FilePath filePath) {
        if (object2.getShell().map(shellControl -> shellControl.isLocal()).orElse(Boolean.FALSE).booleanValue()) {
            b b2 = this;
            boolean bl = false;
            object2 = "get -f " + b2.h(object.toUnix()) + " " + this.h(filePath);
            object = b2;
            b2.a((String)object2, false, bl);
            return true;
        }
        return false;
    }

    public final String getSuffix() {
        return "SFTP";
    }

    private String e(boolean bl) {
        int n2;
        int n3;
        long l2 = System.currentTimeMillis();
        LocalProcessInputStream localProcessInputStream = this.fa.getStdout();
        for (n2 = 0; n2 < this.fb.length; n2 += n3) {
            if (bl && System.currentTimeMillis() - l2 > 5000L && !this.fc.isEmpty()) {
                this.fa.kill();
                ProcessOutputException processOutputException = ProcessOutputException.of((long)1L, (String[])new String[]{this.fc});
                this.fc = "";
                throw processOutputException;
            }
            n3 = Math.min(localProcessInputStream.available(), this.fb.length - n2);
            n3 = localProcessInputStream.read(this.fb, n2, n3 > 0 ? 1 : 0);
            if (n3 == -1) break;
            if (n3 <= 0 || this.fb[n2] != 13 && this.fb[n2] != 10) continue;
            if (this.fb[n2] != 13 || localProcessInputStream.available() <= 0 || (bl = localProcessInputStream.read()) != 10) break;
            ++n2;
            break;
        }
        String string = new String(this.fb, 0, n2, StandardCharsets.UTF_8).strip();
        return string;
    }

    private synchronized void dw() {
        String string;
        this.fa.writeLine("version", false);
        this.fa.writeLine("help", false);
        this.fa.writeLine("help", false);
        do {
            string = this.e(false);
            TrackEvent.trace((String)("sftp stdout: " + string));
        } while (!string.startsWith("SFTP protocol version"));
    }

    private String c(String string, boolean bl) {
        return this.a(string, false, bl);
    }

    private synchronized String a(String string, boolean bl, boolean bl2) {
        String string2;
        if (!this.fa.isRunning(true) || this.fa.isAnyStreamClosed()) {
            throw new IllegalStateException("Session is closed");
        }
        this.fa.writeLine(string);
        this.fa.writeLine("help", false);
        this.fa.writeLine("help", false);
        boolean bl3 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            string2 = this.e(bl2);
            if (this.fa.getExitUuids().stream().anyMatch(uUID -> string2.contains(uUID.toString()))) {
                ThreadHelper.sleep((long)1000L);
                this.fa.kill();
                ProcessOutputException processOutputException = ProcessOutputException.of((long)1L, (String[])new String[]{this.fc});
                this.fc = "";
                throw processOutputException;
            }
            if (!bl3 && string2.startsWith("sftp> " + string)) {
                bl3 = true;
                continue;
            }
            if (bl3 && string2.startsWith("sftp> help")) break;
            if (!bl3) continue;
            arrayList.add(string2);
        }
        string2 = String.join((CharSequence)"\n", arrayList);
        if (!arrayList.isEmpty()) {
            TrackEvent.trace((String)("sftp stdout:\n" + string2));
        }
        ThreadHelper.sleep((long)100L);
        String string3 = this.fc;
        this.fc = "";
        if (!bl && !string3.isEmpty()) {
            throw ProcessOutputException.of((String)string, (long)1L, (String[])new String[]{string3});
        }
        return string2;
    }

    public final boolean isRunning() {
        return this.fa.isRunning(true);
    }

    public final boolean supportsLinkCreation() {
        return this.osType != OsType.WINDOWS;
    }

    public final boolean supportsOwnerColumn() {
        return this.osType != OsType.WINDOWS;
    }

    public final boolean supportsModeColumn() {
        return this.osType != OsType.WINDOWS;
    }

    public final boolean supportsDirectorySizes() {
        return false;
    }

    public final boolean supportsChmod() {
        return this.osType != OsType.WINDOWS;
    }

    public final boolean supportsChown() {
        return this.osType != OsType.WINDOWS && this.osType != OsType.MACOS;
    }

    public final boolean supportsChgrp() {
        return this.osType != OsType.WINDOWS && this.osType != OsType.MACOS;
    }

    public final boolean supportsTerminalOpen() {
        return true;
    }

    public final boolean supportsTerminalWorkingDirectory() {
        return false;
    }

    public final Optional<ShellControl> getRawShellControl() {
        return Optional.of(this.fa);
    }

    public final ShellControl getTerminalShellControl() {
        return this.fa;
    }

    public final void chmod(FilePath object, String string, boolean bl) {
        boolean bl2 = true;
        String string2 = "chmod " + string + " " + this.h((FilePath)object);
        b b2 = this;
        b2.a(string2, false, bl2);
        if (bl && this.directoryExists((FilePath)object)) {
            b b3 = this;
            object = b3.listFilesRecursively(b3, (FilePath)object);
            object = object.iterator();
            while (object.hasNext()) {
                FileEntry fileEntry = (FileEntry)object.next();
                bl2 = true;
                string2 = "chmod " + string + " " + this.h(fileEntry.getPath());
                b2 = this;
                b2.a(string2, false, bl2);
            }
        }
    }

    public final void chown(FilePath object, String string, boolean bl) {
        boolean bl2 = true;
        String string2 = "chown " + string + " " + this.h((FilePath)object);
        b b2 = this;
        b2.a(string2, false, bl2);
        if (bl && this.directoryExists((FilePath)object)) {
            b b3 = this;
            object = b3.listFilesRecursively(b3, (FilePath)object);
            object = object.iterator();
            while (object.hasNext()) {
                FileEntry fileEntry = (FileEntry)object.next();
                bl2 = true;
                string2 = "chown " + string + " " + this.h(fileEntry.getPath());
                b2 = this;
                b2.a(string2, false, bl2);
            }
        }
    }

    public final void chgrp(FilePath object, String string, boolean bl) {
        boolean bl2 = true;
        String string2 = "chgrp " + string + " " + this.h((FilePath)object);
        b b2 = this;
        b2.a(string2, false, bl2);
        if (bl && this.directoryExists((FilePath)object)) {
            b b3 = this;
            object = b3.listFilesRecursively(b3, (FilePath)object);
            object = object.iterator();
            while (object.hasNext()) {
                FileEntry fileEntry = (FileEntry)object.next();
                bl2 = true;
                string2 = "chgrp " + string + " " + this.h(fileEntry.getPath());
                b2 = this;
                b2.a(string2, false, bl2);
            }
        }
    }

    public final void kill() {
        this.fa.kill();
    }

    public final void cd(FilePath object) {
        b b2 = this;
        boolean bl = true;
        String string = "cd " + b2.h((FilePath)object);
        object = b2;
        b2.a(string, false, bl);
    }

    public final boolean requiresReinit() {
        return !this.fa.isRunning(true) || this.fa.isAnyStreamClosed();
    }

    public final void reinitIfNeeded() {
        this.fa.start();
        if (this.fa.isAnyStreamClosed()) {
            this.fa.restart();
        }
    }

    public final String getFileSeparator() {
        return OsFileSystem.of((OsType.Any)this.osType).getFileSystemSeparator();
    }

    public final FilePath makeFileSystemCompatible(FilePath filePath) {
        return OsFileSystem.of((OsType.Any)this.osType).makeFileSystemCompatible(filePath);
    }

    public final Optional<FilePath> pwd() {
        boolean bl = true;
        String string = "pwd";
        Object object = this;
        object = ((b)object).a(string, false, bl);
        object = ((String)object).split(":", 2)[1].strip();
        return Optional.of(this.bc((String)object).toDirectory());
    }

    public final FileSystem createTransferOptimizedFileSystem() {
        return this;
    }

    public final long getFileSize(FilePath object) {
        object = this.getFileInfo((FilePath)object);
        return object.map(fileEntry -> fileEntry.getFileSizeLong().orElse(0L)).orElse(0L);
    }

    public final long getDirectorySize(FilePath filePath) {
        return 0L;
    }

    public final Optional<ShellControl> getShell() {
        return Optional.empty();
    }

    public final FileSystem open() {
        this.fa.start();
        b b2 = this;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        LocalProcessInputStream localProcessInputStream = b2.fa.getStderr();
        ThreadHelper.runFailableAsync(() -> {
            while (this.fa.isRunning(false)) {
                if (!localProcessInputStream.bufferedAvailable() && localProcessInputStream.available() == 0) {
                    ThreadHelper.sleep((long)10L);
                    continue;
                }
                int n2 = localProcessInputStream.read();
                if (n2 == -1) break;
                byteArrayOutputStream.write(n2);
                if (n2 != 10) continue;
                String string = byteArrayOutputStream.toString(StandardCharsets.UTF_8).strip();
                byteArrayOutputStream.reset();
                if (this.fa.getExitUuids().stream().anyMatch(uUID -> string.contains(uUID.toString()))) break;
                this.fc = this.fc + (this.fc.isEmpty() ? "" : "\n") + string;
            }
        });
        this.a("help", true, false);
        this.osType = this.dx();
        this.dw();
        this.fc = "";
        return this;
    }

    public final InputStream openInput(FilePath object) {
        Path path = Files.createTempFile(null, null, new FileAttribute[0]);
        b b2 = this;
        boolean bl = false;
        String string = "get -f " + b2.h((FilePath)object) + " " + this.h(FilePath.of((Path)path).toUnix());
        object = b2;
        b2.a(string, false, bl);
        return new BufferedInputStream(new FileInputStream(path.toFile()));
    }

    public final OutputStream openOutput(FilePath filePath, long l2) {
        Path path = Files.createTempFile(null, null, new FileAttribute[0]);
        return new FilterOutputStream(this, new BufferedOutputStream(new FileOutputStream(path.toFile())), path, filePath){
            private /* synthetic */ Path bb;
            private /* synthetic */ FilePath bc;
            private /* synthetic */ b ff;
            {
                this.bb = path;
                this.bc = filePath;
                b b3 = b2;
                Objects.requireNonNull(b3);
                this.ff = b3;
                super(outputStream);
            }

            @Override
            public final void close() {
                try {
                    super.close();
                    this.ff.c("put -f " + this.ff.h(FilePath.of((Path)this.bb).toUnix()) + " " + this.ff.h(this.bc), false);
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
            }
        };
    }

    public final boolean fileExists(FilePath filePath) {
        FilePath filePath2 = filePath;
        if (filePath2.equals((Object)filePath2.getRoot())) {
            return false;
        }
        b b2 = this;
        List<FileEntry> list = b2.listFiles(b2, filePath.getParent()).toList();
        return list.stream().filter(fileEntry -> fileEntry.getPath().equals((Object)filePath)).findFirst().map(fileEntry -> fileEntry.getKind() == FileKind.FILE).orElse(Boolean.FALSE);
    }

    public final void delete(FilePath object) {
        if (this.fileExists((FilePath)object)) {
            b b2 = this;
            boolean bl = true;
            String string = "rm " + b2.h((FilePath)object);
            object = b2;
            b2.a(string, false, bl);
            return;
        }
        if (this.directoryExists((FilePath)object)) {
            b b3 = this;
            for (FileEntry fileEntry : b3.listFiles(b3, (FilePath)object).toList()) {
                this.delete(fileEntry.getPath());
            }
            b b4 = this;
            boolean bl = true;
            String string = "rmdir " + b4.h((FilePath)object);
            object = b4;
            b4.a(string, false, bl);
        }
    }

    public final void copy(FilePath object, FilePath object2) {
        b b2 = this;
        boolean bl = false;
        object2 = "cp " + b2.h((FilePath)object) + " " + this.h((FilePath)object2);
        object = b2;
        b2.a((String)object2, false, bl);
    }

    public final void move(FilePath object, FilePath object2) {
        b b2 = this;
        boolean bl = false;
        object2 = "rename " + b2.h((FilePath)object) + " " + this.h((FilePath)object2);
        object = b2;
        b2.a((String)object2, false, bl);
    }

    public final void mkdirs(FilePath object) {
        b b2 = this;
        boolean bl = true;
        String string = "mkdir " + b2.h((FilePath)object);
        object = b2;
        b2.a(string, false, bl);
    }

    public final void touch(FilePath object) {
        Object object2 = Files.createTempFile(null, null, new FileAttribute[0]);
        b b2 = this;
        boolean bl = true;
        object2 = "put -f " + b2.h(FilePath.of((Path)object2).toUnix()) + " " + this.h((FilePath)object);
        object = b2;
        b2.a((String)object2, false, bl);
    }

    public final void symbolicLink(FilePath object, FilePath object2) {
        b b2 = this;
        boolean bl = true;
        object2 = "ln -s " + b2.h((FilePath)object) + " " + this.h((FilePath)object2);
        object = b2;
        b2.a((String)object2, false, bl);
    }

    public final boolean directoryExists(FilePath filePath) {
        FilePath filePath2 = filePath;
        if (filePath2.equals((Object)filePath2.getRoot())) {
            return true;
        }
        try {
            b b2 = this;
            List<FileEntry> list = b2.listFiles(b2, filePath.getParent()).toList();
            return list.stream().filter(fileEntry -> fileEntry.getPath().equals((Object)filePath)).findFirst().map(fileEntry -> fileEntry.getKind() == FileKind.DIRECTORY).orElse(Boolean.FALSE);
        }
        catch (ProcessOutputException processOutputException) {
            return true;
        }
    }

    public final void directoryAccessible(FilePath filePath) {
        if (!filePath.isAbsolute()) {
            throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException("File path " + String.valueOf(filePath) + " is not absolute"));
        }
    }

    public final Optional<FileEntry> getFileInfo(FilePath filePath) {
        FilePath filePath2 = filePath;
        if (filePath2.equals((Object)filePath2.getRoot())) {
            return Optional.of(new FileEntry((FileSystem)this, filePath, Instant.EPOCH, "0", (FileInfo)new FileInfo.Unix("rwxr-xr-xw", Integer.valueOf(0), "root", Integer.valueOf(0), "root"), FileKind.DIRECTORY));
        }
        b b2 = this;
        List<FileEntry> list = b2.listFiles(b2, filePath.getParent()).toList();
        return list.stream().filter(fileEntry -> fileEntry.getPath().equals((Object)filePath)).findFirst();
    }

    private String h(FilePath filePath) {
        filePath = this.osType == OsType.WINDOWS ? filePath.toWindows().toUnix() : filePath;
        if (filePath.toString().contains("'")) {
            return "\"" + String.valueOf(filePath) + "\"";
        }
        return "'" + String.valueOf(filePath) + "'";
    }

    public final Stream<FileEntry> listFiles(FileSystem fileSystem, FilePath filePath) {
        b b2 = this;
        boolean bl = true;
        Object object = "ls -al " + b2.h(filePath);
        Iterator<String> iterator = b2;
        iterator = b2.a((String)object, false, bl);
        object = new ArrayList();
        for (String stringArray : ((String)((Object)iterator)).lines().toList()) {
            String[] stringArray2;
            if (stringArray.isBlank() || (stringArray2 = stringArray.split("\\s+", 9)).length != 9) continue;
            String string = stringArray2[0];
            String string2 = stringArray2[2];
            String string3 = stringArray2[3];
            String string4 = stringArray2[4];
            String string5 = stringArray2[5];
            String string6 = stringArray2[6];
            String string7 = stringArray2[7];
            String string8 = stringArray2[8];
            FilePath filePath2 = string8.startsWith("/") ? this.bc(string8) : this.bc(filePath.join(new String[]{string8}).toString());
            if (filePath2.getFileName().equals(".") || filePath2.getFileName().equals("..")) continue;
            Instant instant = null;
            try {
                if (string7.contains(":")) {
                    int n2 = Year.now().getValue();
                    instant = fd.parse(string5 + " " + string6 + " " + string7 + " " + n2).toInstant();
                } else {
                    instant = fe.parse(string5 + " " + string6 + " " + string7).toInstant();
                }
            }
            catch (ParseException parseException) {}
            String string9 = this.osType != OsType.WINDOWS ? string.substring(1).replaceAll("\\*", "-") : null;
            string2 = new FileInfo.Unix(string9, null, string2.equals("-") ? null : string2, null, string3.equals("-") ? null : string3);
            char c2 = string.charAt(0);
            FileKind fileKind = switch (c2) {
                case 'd' -> FileKind.DIRECTORY;
                case 'p', 's' -> FileKind.OTHER;
                default -> FileKind.FILE;
            };
            string = fileKind;
            string3 = fileKind == FileKind.DIRECTORY ? null : string4;
            FileEntry fileEntry = new FileEntry(fileSystem, filePath2, instant, string3, (FileInfo)string2, (FileKind)string);
            ((ArrayList)object).add(fileEntry);
        }
        return object.stream();
    }

    private FilePath bc(String string) {
        if ((string = FilePath.of((String)string)).isRoot()) {
            return string;
        }
        if (this.osType == OsType.WINDOWS) {
            return string.toWindows();
        }
        return string;
    }

    public final List<FilePath> listRoots() {
        if (this.osType == OsType.WINDOWS) {
            b b2 = this;
            Stream<FileEntry> stream = b2.listFiles(b2, FilePath.of((String)"/"));
            return stream.map(fileEntry -> fileEntry.getPath().toWindows()).toList();
        }
        return List.of(FilePath.of((String)"/"));
    }

    public final List<FilePath> listCommonDirectories() {
        FilePath filePath = this.pwd().orElseThrow();
        if (filePath.isRoot()) {
            return List.of();
        }
        if (this.fa.getOsType() == OsType.WINDOWS) {
            FilePath filePath2 = filePath;
            return List.of(filePath2, filePath2.join(new String[]{"Documents"}), filePath.join(new String[]{"Downloads"}), filePath.join(new String[]{"Desktop"}));
        }
        if (this.fa.getOsType() == OsType.MACOS) {
            FilePath filePath3 = filePath;
            List<FilePath> list = List.of(filePath3, filePath3.join(new String[]{"Downloads"}), filePath.join(new String[]{"Documents"}), filePath.join(new String[]{"Desktop"}), FilePath.of((String)"/Applications"), FilePath.of((String)"/Library"), FilePath.of((String)"/System"), FilePath.of((String)"/etc"), FilePath.of((String)"/tmp"));
            return list;
        }
        FilePath filePath4 = filePath;
        ArrayList<FilePath> arrayList = new ArrayList<FilePath>(List.of(filePath4, filePath4.join(new String[]{"Downloads"}), filePath.join(new String[]{"Documents"}), FilePath.of((String)"/etc"), FilePath.of((String)"/tmp"), FilePath.of((String)"/var")));
        if ((filePath = filePath.getParent()) != null && !filePath.toString().equals("/")) {
            arrayList.add(3, filePath);
        }
        return arrayList;
    }

    private OsType.Any dx() {
        List<FileEntry> list;
        try {
            b b2 = this;
            list = b2.listFiles(b2, FilePath.of((String)"/")).toList();
        }
        catch (ProcessOutputException processOutputException) {
            return OsType.LINUX;
        }
        if (list.stream().anyMatch(fileEntry -> fileEntry.getPath().equals((Object)FilePath.of((String)"/C:")))) {
            return OsType.WINDOWS;
        }
        if (list.stream().anyMatch(fileEntry -> fileEntry.getPath().equals((Object)FilePath.of((String)"/Users")))) {
            return OsType.MACOS;
        }
        if (list.stream().anyMatch(fileEntry -> fileEntry.getPath().equals((Object)FilePath.of((String)"/platform")))) {
            return OsType.SOLARIS;
        }
        if (list.stream().anyMatch(fileEntry -> fileEntry.getPath().equals((Object)FilePath.of((String)"/smit.script")))) {
            return OsType.AIX;
        }
        if (list.stream().anyMatch(fileEntry -> fileEntry.getPath().equals((Object)FilePath.of((String)"/proc")))) {
            return OsType.LINUX;
        }
        return OsType.UNIX;
    }

    public final void close() {
        if (!this.fa.isRunning(true)) {
            return;
        }
        try {
            if (!this.fa.getStdin().isClosed()) {
                this.fa.writeLine("quit");
                Thread.sleep(100L);
            }
            this.fa.close();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).omit().expected().handle();
            return;
        }
    }

    @Generated
    public final ShellControl dy() {
        return this.fa;
    }

    @Generated
    public final byte[] dz() {
        return this.fb;
    }

    @Generated
    public final OsType.Any dA() {
        return this.osType;
    }

    @Generated
    public final String dB() {
        return this.fc;
    }
}

