/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.FixedHierarchyStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.ContextualFileReference;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.g;
import io.xpipe.ext.proc.ssh.i;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;

@JsonTypeName(value="sshConfig")
@JsonDeserialize(builder=b.class)
public final class k
implements FixedHierarchyStore,
SelfReferentialStore {
    private final DataStoreEntryRef<ShellStore> host;
    private final ContextualFileReference configFile;

    public final void checkComplete() {
        if (this.host != null) {
            Validators.isType(this.host, ShellStore.class);
        }
    }

    public final List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() {
        Object object3;
        ShellControl shellControl;
        ShellControl shellControl2 = shellControl = this.host != null ? ((ShellStore)this.host.getStore()).getOrStartSession() : LocalShell.getShell();
        if (this.configFile != null) {
            object3 = this.configFile.toAbsoluteFilePath(shellControl);
            if (shellControl.view().directoryExists((FilePath)object3)) {
                object3 = object3.join(new String[]{"config"});
            }
            if (!shellControl.view().fileExists((FilePath)object3)) {
                throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException("SSH config file " + String.valueOf(object3) + " does not exist"));
            }
        }
        object3 = g.b(shellControl, this.configFile != null ? this.configFile.toAbsoluteFilePath(shellControl) : null);
        LinkedHashMap<String, g.a> linkedHashMap = new LinkedHashMap<String, g.a>();
        for (g.a object4 : ((g)object3).dH()) {
            if (object4.dK()) continue;
            g.a a3 = g.a(shellControl, object4.dP(), this.configFile != null ? this.configFile.toAbsoluteFilePath(shellControl) : null);
            if (!object4.bh("IdentityFile")) {
                a3.dQ().removeIf(keyValue -> keyValue.getKey().equalsIgnoreCase("IdentityFile") && keyValue.getValue().contains("id_"));
            }
            linkedHashMap.put(object4.dP(), a3);
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        for (g.a a4 : ((g)object3).dH()) {
            if (linkedHashMap2.entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equals(a4.dP())) || linkedHashMap2.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).equals(a4.dQ()))) continue;
            linkedHashMap2.put(a4.dP(), a4.dQ());
        }
        boolean bl = ((g)object3).dH().stream().anyMatch(a2 -> a2.dK() && !a2.dQ().isEmpty());
        List<DataStoreEntryRef> list = linkedHashMap2.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains("!") && !((String)entry.getKey()).contains("*") && !((String)entry.getKey()).contains("?")).map(object -> {
            IdentityValue identityValue = IdentityValue.ofBreakout((DataStoreEntry)this.getSelfEntry());
            Object b2 = ((i.a)((i.a)i.builder().config((DataStoreEntryRef<k>)this.getSelfEntry().ref())).hostEntry(new g.a((String)object.getKey(), (List)object.getValue()))).identity(identityValue);
            if (identityValue == null) {
                linkedHashMap = (g.a)((LinkedHashMap)((Object)linkedHashMap)).get(object.getKey());
                object = ((g.a)((Object)linkedHashMap)).m("User", null);
                if ((linkedHashMap = g.a((g.a)((Object)linkedHashMap), shellControl.isLocal())).isPresent()) {
                    ((i.a)b2).identity((IdentityValue)IdentityValue.of((String)object, (SecretRetrievalStrategy)new SecretNoneStrategy(), (SshIdentityStrategy)linkedHashMap.get()));
                } else if (bl) {
                    ((i.a)b2).identity((IdentityValue)IdentityValue.none());
                }
            }
            linkedHashMap = ((i.a)b2).build();
            return DataStoreEntry.createNew((String)((i)((Object)linkedHashMap)).getHostEntry().dP(), (DataStore)linkedHashMap).ref();
        }).toList();
        return list;
    }

    @Generated
    protected k(a<?, ?> a2) {
        this.host = a2.host;
        this.configFile = a2.configFile;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public final ContextualFileReference getConfigFile() {
        return this.configFile;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof k)) {
            return false;
        }
        object = (k)object;
        ContextualFileReference contextualFileReference = this.getHost();
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = ((k)object).getHost();
        if (contextualFileReference == null ? dataStoreEntryRef != null : !contextualFileReference.equals(dataStoreEntryRef)) {
            return false;
        }
        contextualFileReference = this.getConfigFile();
        object = ((k)object).getConfigFile();
        return !(contextualFileReference == null ? object != null : !contextualFileReference.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = this.getHost();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        ContextualFileReference contextualFileReference = this.getConfigFile();
        n2 = n2 * 59 + (contextualFileReference == null ? 43 : contextualFileReference.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "SshConfigFileStore(host=" + String.valueOf(this.getHost()) + ", configFile=" + String.valueOf(this.getConfigFile()) + ")";
    }

    @Generated
    public static abstract class a<C extends k, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;
        @Generated
        private ContextualFileReference configFile;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.host = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B configFile(ContextualFileReference contextualFileReference) {
            this.configFile = contextualFileReference;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SshConfigFileStore.SshConfigFileStoreBuilder(host=" + String.valueOf(this.host) + ", configFile=" + String.valueOf(this.configFile) + ")";
        }
    }

    @JsonTypeName(value="sshConfig")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<k, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final k build() {
            return new k(this);
        }
    }
}

