/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.KeyValue;
import io.xpipe.ext.base.identity.IdentitySwitchStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.e;
import io.xpipe.ext.proc.ssh.g;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@JsonTypeName(value="sshConfigString")
@JsonDeserialize(builder=b.class)
public final class o
extends e<ShellStoreState>
implements SelfReferentialStore {
    private final DataStoreEntryRef<NetworkTunnelStore> gateway;
    private final Boolean useGatewayWithProxyJump;
    private final String content;
    private final IdentityValue identity;
    private final Boolean dontInteractWithSystem;

    public final IdentitySwitchStore withIdentity(IdentityValue identityValue) {
        return ((a)this.toBuilder().identity(identityValue)).build();
    }

    public final Class<ShellStoreState> getStateClass() {
        return ShellStoreState.class;
    }

    @Override
    public final g toConfigHost() {
        Object object;
        Object object2 = this.getConfig().dE();
        List<KeyValue> list = ((g)object2).dF().dQ();
        Object object3 = object = ((g)object2).dH().size() > 1 ? ((g)object2).dH().getFirst() : ((g)object2).dF();
        if (this.isGatewayTunnelSessionActive()) {
            object = ((g.a)object).dQ();
            object.removeIf(keyValue -> keyValue.getKey().equals("Port"));
            object.add(new KeyValue("Port", "" + this.getEffectivePort()));
            object.removeIf(keyValue -> keyValue.getKey().equals("HostName"));
            object.add(new KeyValue("HostName", this.getEffectiveHostName()));
        }
        if (((g)object2).dH().size() > 1) {
            return object2;
        }
        object = this.distinctConfigHostName();
        object2 = new g.a((String)object, list);
        return new g((g.a)object2);
    }

    @Override
    protected final boolean dontInteractWithSystem() {
        if (this.dontInteractWithSystem != null) {
            return this.dontInteractWithSystem;
        }
        return false;
    }

    @Override
    protected final boolean hasX11Forward() {
        return this.getHostEntry().bg("ForwardX11") || this.getHostEntry().bg("ForwardX11Trusted");
    }

    @Override
    public final SecretRetrievalStrategy getPassword() {
        SecretRetrievalStrategy secretRetrievalStrategy = this.getIdentity().unwrap().getPassword();
        if (secretRetrievalStrategy != null) {
            return secretRetrievalStrategy;
        }
        return new SecretNoneStrategy();
    }

    @Override
    public final DataStoreEntryRef<NetworkTunnelStore> getTunnelGateway() {
        return this.gateway;
    }

    @Override
    public final boolean useGatewayWithProxyJump() {
        return this.useGatewayWithProxyJump != null && this.useGatewayWithProxyJump != false;
    }

    @Override
    public final HostAddress getHostAddress() {
        return HostAddress.of((String)this.getHostEntry().m("Hostname", this.getHostEntry().m("HostName", "localhost")));
    }

    @Override
    public final UsernameStrategy getUser() {
        String string = this.getHostEntry().m("User", null);
        if (string != null) {
            return new UsernameStrategy.Fixed(string);
        }
        if (this.identity != null) {
            return this.identity.unwrap().getUsername();
        }
        return new UsernameStrategy.None();
    }

    @Override
    public final int getPort() {
        String string = this.getHostEntry().m("Port", "22");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 22;
        }
    }

    @Override
    protected final CommandBuilder buildBaseCommand() {
        Object object = this.getConfigEntryName();
        object = (String)(this.identity.unwrap().getUsername().hasUser() ? this.identity.unwrap().getUsername().retrieveUsername() + "@" : "") + (String)object;
        object = CommandBuilder.of().addQuoted((String)object);
        return object;
    }

    @Override
    protected final Optional<g> buildBaseConfig() {
        return Optional.of(((e)this).toConfigHost());
    }

    @Override
    protected final SshIdentityStrategy getIdentityStrategy() {
        SshIdentityStrategy sshIdentityStrategy = g.a(this.getHostEntry(), true);
        if (sshIdentityStrategy.isPresent()) {
            return sshIdentityStrategy.get();
        }
        sshIdentityStrategy = this.identity.unwrap().getSshIdentity();
        if (sshIdentityStrategy != null) {
            return sshIdentityStrategy;
        }
        return new NoIdentityStrategy();
    }

    @Override
    protected final boolean hasTunnels() {
        return this.getHostEntry().bh("LocalForward") || this.getHostEntry().bh("RemoteForward") || this.getHostEntry().bh("DynamicForward");
    }

    public final boolean isPerUser() {
        return this.identity.isPerUser();
    }

    private g getConfig() {
        try {
            return g.bd(this.content);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return new g(List.of(), List.of());
        }
    }

    private g.a getHostEntry() {
        return this.getConfig().dH().getFirst();
    }

    public final String getConfigEntryName() {
        g g2 = this.getConfig();
        if (g2.dH().size() > 1) {
            return this.getConfig().dH().getFirst().dP();
        }
        return this.distinctConfigHostName();
    }

    public final void checkComplete() {
        Validators.nonNull(this.gateway);
        Validators.isType(this.gateway, NetworkTunnelStore.class);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompletePassword();
        this.identity.checkCompleteSshIdentity();
        Validators.nonNull((Object)this.content);
        g.bd(this.content);
        this.checkValidGatewayChain();
    }

    @Generated
    protected o(a<?, ?> a2) {
        super(a2);
        this.gateway = a2.gateway;
        this.useGatewayWithProxyJump = a2.useGatewayWithProxyJump;
        this.content = a2.content;
        this.identity = a2.identity;
        this.dontInteractWithSystem = a2.dontInteractWithSystem;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<NetworkTunnelStore> getGateway() {
        return this.gateway;
    }

    @Generated
    public final Boolean getUseGatewayWithProxyJump() {
        return this.useGatewayWithProxyJump;
    }

    @Generated
    public final String getContent() {
        return this.content;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final Boolean getDontInteractWithSystem() {
        return this.dontInteractWithSystem;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof o)) {
            return false;
        }
        o o2 = (o)object;
        if (!o2.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getUseGatewayWithProxyJump();
        Object object2 = o2.getUseGatewayWithProxyJump();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getDontInteractWithSystem();
        object2 = o2.getDontInteractWithSystem();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getGateway();
        object2 = o2.getGateway();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getContent();
        object2 = o2.getContent();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getIdentity();
        o2 = o2.getIdentity();
        return !(object == null ? o2 != null : !object.equals(o2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof o;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getUseGatewayWithProxyJump();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getDontInteractWithSystem();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getGateway();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getContent();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "SshConfigStringStore(super=" + super.toString() + ", gateway=" + String.valueOf(this.getGateway()) + ", useGatewayWithProxyJump=" + this.getUseGatewayWithProxyJump() + ", content=" + this.getContent() + ", identity=" + String.valueOf(this.getIdentity()) + ", dontInteractWithSystem=" + this.getDontInteractWithSystem() + ")";
    }

    @Generated
    public static abstract class a<C extends o, B extends a<C, B>>
    extends e.a<ShellStoreState, C, B> {
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> gateway;
        @Generated
        private Boolean useGatewayWithProxyJump;
        @Generated
        private String content;
        @Generated
        private IdentityValue identity;
        @Generated
        private Boolean dontInteractWithSystem;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(o o2, a<?, ?> a2) {
            a2.gateway(o2.gateway);
            a2.useGatewayWithProxyJump(o2.useGatewayWithProxyJump);
            a2.content(o2.content);
            a2.identity(o2.identity);
            a2.dontInteractWithSystem(o2.dontInteractWithSystem);
        }

        @Generated
        public B gateway(DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef) {
            this.gateway = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B useGatewayWithProxyJump(Boolean bl) {
            this.useGatewayWithProxyJump = bl;
            return (B)this.self();
        }

        @Generated
        public B content(String string) {
            this.content = string;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Generated
        public B dontInteractWithSystem(Boolean bl) {
            this.dontInteractWithSystem = bl;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SshConfigStringStore.SshConfigStringStoreBuilder(super=" + super.toString() + ", gateway=" + String.valueOf(this.gateway) + ", useGatewayWithProxyJump=" + this.useGatewayWithProxyJump + ", content=" + this.content + ", identity=" + String.valueOf(this.identity) + ", dontInteractWithSystem=" + this.dontInteractWithSystem + ")";
        }
    }

    @JsonTypeName(value="sshConfigString")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<o, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final o build() {
            return new o(this);
        }
    }
}

