/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.tailscale;

import com.fasterxml.jackson.databind.JsonNode;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.LocalStore;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.CommandView;
import io.xpipe.app.process.CommandViewBase;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ProcessControl;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.terminal.TerminalLaunch;
import io.xpipe.app.update.AppDistributionType;
import io.xpipe.app.util.DataStoreFormatter;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.proc.cloud.b;
import io.xpipe.ext.proc.cloud.f;
import io.xpipe.ext.proc.tailscale.b;
import io.xpipe.ext.proc.tailscale.d;
import io.xpipe.ext.proc.tailscale.e;
import io.xpipe.ext.proc.tailscale.i;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class a
extends CommandViewBase {
    private static boolean eg;

    public a(ShellControl shellControl) {
        super(shellControl);
    }

    private static String f(String string) {
        return string;
    }

    static Throwable b(Throwable throwable) {
        if (throwable instanceof ProcessOutputException) {
            if ((throwable = (ProcessOutputException)throwable).getOutput().contains("Logged out")) {
                return throwable;
            }
            String string = "Failed to communicate with the tailscale daemon. Is it running? Original error";
            return ProcessOutputException.withPrefix((String)"Failed to communicate with the tailscale daemon. Is it running? Original error", (ProcessOutputException)throwable);
        }
        return throwable;
    }

    private static CommandBuilder Y() {
        CommandBuilder commandBuilder = CommandBuilder.of().add(shellControl -> {
            if (shellControl.getOsType() == OsType.MACOS) {
                return "/Applications/Tailscale.app/Contents/MacOS/Tailscale";
            }
            return "tailscale";
        });
        return commandBuilder;
    }

    protected CommandControl build(Consumer<CommandBuilder> consumer) {
        if (!eg && AppDistributionType.get() == AppDistributionType.WEBTOP) {
            boolean bl = LocalShell.getShell().command(CommandBuilder.of().add(new String[]{"test", "-e"}).addFile("/dev/net/tun")).executeAndCheck();
            if (!bl) {
                DocumentationLink.WEBTOP_TUN.open();
            } else {
                ShellControl shellControl = LocalShell.getShell().command(CommandBuilder.of().add(new String[]{"tailscale", "status"})).readStdoutAndStderr();
                if (shellControl[1].contains("failed to connect to local tailscaled")) {
                    shellControl = new LocalStore().shellFunction().control().subShell(ShellDialects.SH);
                    shellControl.elevated(ElevationFunction.elevated((String)"tailscale"));
                    shellControl = shellControl.start();
                    try {
                        CommandBuilder commandBuilder = shellControl.getShellDialect().launchAsync(CommandBuilder.of().add(new String[]{"tailscaled", "--state=tailscaled.state"}), false);
                        shellControl.command(commandBuilder).execute();
                        ThreadHelper.sleep((long)1000L);
                    }
                    finally {
                        if (shellControl != null) {
                            shellControl.close();
                        }
                    }
                }
            }
            eg = true;
        }
        CommandBuilder commandBuilder = a.Y();
        consumer.accept(commandBuilder);
        return this.shellControl.command(commandBuilder).withErrorFormatter(a::f).withExceptionConverter(a::b).elevated(ElevationFunction.ifNotRoot((ElevationFunction)ElevationFunction.elevated((String)"tailscale")));
    }

    public a eA() {
        this.shellControl.start();
        return this;
    }

    public boolean R() {
        return this.shellControl.command(a.Y().add(new String[]{"--help"})).withErrorFormatter(a::f).withExceptionConverter(a::b).executeAndCheck();
    }

    public String ab() {
        String string = this.shellControl.command(a.Y().add(new String[]{"version"})).withErrorFormatter(a::f).withExceptionConverter(a::b).readStdoutOrThrow();
        string = string.lines().findFirst().orElse("?");
        return "tailscale v" + string;
    }

    public boolean cE() {
        String[] stringArray = this.build(commandBuilder -> commandBuilder.add(new String[]{"status"})).readStdoutAndStderr();
        return stringArray[0].contains("Logged out");
    }

    public List<DataStoreEntryRef<i>> s(DataStoreEntryRef<e> commandControl) {
        Iterator iterator = this.build(commandBuilder -> commandBuilder.add(new String[]{"switch", "--list"})).readStdoutOrThrow();
        iterator = ((String)((Object)iterator)).lines().skip(1L).toList();
        ArrayList<DataStoreEntryRef<i>> arrayList = new ArrayList<DataStoreEntryRef<i>>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            DataStoreEntry dataStoreEntry = (String[])iterator.next();
            dataStoreEntry = dataStoreEntry.strip();
            if (((String[])(dataStoreEntry = dataStoreEntry.split("\\s+", 3))).length != 3) continue;
            String string = dataStoreEntry[1];
            dataStoreEntry = dataStoreEntry[2];
            boolean bl = false;
            if (dataStoreEntry.endsWith("*")) {
                dataStoreEntry = dataStoreEntry.substring(0, dataStoreEntry.length() - 1).strip();
                bl = true;
            }
            dataStoreEntry = ((i.b)((i.b)((i.b)i.builder().install((DataStoreEntryRef<e>)commandControl)).tailnet(string)).account((String)dataStoreEntry)).build();
            dataStoreEntry = DataStoreEntry.createNew((String)string, (DataStore)dataStoreEntry);
            dataStoreEntry.setStorePersistentState(((i.a.a)((Object)i.a.builder().active(bl))).build());
            arrayList.add((DataStoreEntryRef<i>)dataStoreEntry.ref());
        }
        if (arrayList.isEmpty() && AppDistributionType.get() == AppDistributionType.WEBTOP) {
            commandControl = this;
            commandControl = commandControl.build(commandBuilder -> commandBuilder.add(new String[]{"login"})).elevated(ElevationFunction.elevated((String)"tailscale"));
            TerminalLaunch.builder().command((ProcessControl)commandControl).logIfEnabled(false).preferTabs(false).title("Tailscale login").launch();
        }
        return arrayList;
    }

    public boolean bn(String string) {
        Iterator<String> iterator = this.build(commandBuilder -> commandBuilder.add(new String[]{"switch", "--list"})).readStdoutOrThrow();
        iterator = ((String)((Object)iterator)).lines().skip(1L).toList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = ((String)object).strip();
            if (((String[])(object = ((String)object).split("\\s+", 3))).length != 3) continue;
            object = object[2];
            boolean bl = false;
            if (((String)object).contains("*")) {
                bl = true;
                object = ((String)object).substring(0, ((String)object).length() - 1).strip();
            }
            if (string.equals(object) && bl) {
                return true;
            }
            if (!string.equals(object)) continue;
            this.build(commandBuilder -> commandBuilder.add(new String[]{"switch"}).addQuoted(string)).execute();
            return true;
        }
        this.build(commandBuilder -> commandBuilder.add(new String[]{"status"})).execute();
        TerminalLaunch.builder().title("Tailscale login").command((ProcessControl)this.build(commandBuilder -> commandBuilder.add(new String[]{"login"}))).launch();
        return false;
    }

    public List<DataStoreEntryRef<b>> t(DataStoreEntryRef<i> object) {
        Object object2 = this.build(commandBuilder -> commandBuilder.add(new String[]{"status", "--json"})).readStdoutOrThrow();
        object2 = JacksonMapper.getDefault().readTree((String)object2);
        JsonNode jsonNode2 = object2.required("Peer");
        if (jsonNode2.isNull()) {
            object = (object2 = object2.get("Health")) != null && object2.isArray() ? "\n\n" + StreamSupport.stream(object2.spliterator(), false).map(jsonNode -> jsonNode.asText()).collect(Collectors.joining(" ")) : "";
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Failed to communicate with tailscale daemon. Is it running?" + object));
        }
        object2 = new ArrayList();
        jsonNode2.iterator().forEachRemaining(arg_0 -> a.a(object, (ArrayList)object2, arg_0));
        return object2;
    }

    public Optional<d> a(b object) {
        Serializable serializable = this.build(commandBuilder -> commandBuilder.add(new String[]{"status", "--json"})).readStdoutOrThrow();
        serializable = JacksonMapper.getDefault().readTree((String)((Object)serializable));
        serializable = serializable.required("Peer");
        serializable = serializable.iterator();
        while (serializable.hasNext()) {
            JsonNode jsonNode = (JsonNode)serializable.next();
            Object object2 = jsonNode.required("ID").asText();
            if (!((b)object).getId().equals(object2)) continue;
            object = jsonNode.required("DNSName").asText();
            serializable = Pattern.compile("^(.+?)\\..+$");
            object = ((Pattern)serializable).matcher((CharSequence)object);
            object = ((Matcher)object).matches() ? ((Matcher)object).group(1) : jsonNode.required("HostName").asText();
            serializable = new ArrayList<Object>();
            serializable.add(object);
            object2 = jsonNode.get("TailscaleIPs");
            if (object2 != null && object2.isArray()) {
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    JsonNode jsonNode2 = (JsonNode)object2.next();
                    if (jsonNode2.asText().contains("/")) continue;
                    serializable.add(jsonNode2.asText());
                }
            }
            boolean bl = jsonNode.get("sshHostKeys") != null;
            boolean bl2 = jsonNode.required("ExitNode").asBoolean() || jsonNode.required("ExitNodeOption").asBoolean();
            boolean bl3 = jsonNode.required("Online").asBoolean();
            return Optional.ofNullable(((d.a)((Object)((d.a)((Object)((d.a)((Object)((f.a)((Object)((d.a)((Object)d.builder().address(HostAddress.of((String)object, serializable)))).ssh(bl))).state(bl3 ? "Online" : "Offline"))).online(bl3))).exitNode(bl2))).build());
        }
        return Optional.empty();
    }

    public /* synthetic */ CommandView start() {
        return this.eA();
    }

    private static /* synthetic */ void a(DataStoreEntryRef dataStoreEntryRef, ArrayList arrayList, JsonNode jsonNode) {
        Object object;
        Object object2 = jsonNode.get("Tags");
        if (object2 != null && object2.isArray()) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object = (JsonNode)object2.next();
                if (!object.asText().equals("tag:mullvad-exit-node")) continue;
                return;
            }
        }
        object2 = jsonNode.required("ID").asText();
        object = jsonNode.required("DNSName").asText();
        Serializable serializable = Pattern.compile("^(.+?)\\..+$");
        object = ((Pattern)serializable).matcher((CharSequence)object);
        object = ((Matcher)object).matches() ? ((Matcher)object).group(1) : jsonNode.required("HostName").asText();
        if (((String)object).isBlank()) {
            return;
        }
        serializable = new ArrayList<Object>();
        ((ArrayList)serializable).add(object);
        Object object3 = jsonNode.get("TailscaleIPs");
        if (object3 != null && object3.isArray()) {
            object3 = object3.iterator();
            while (object3.hasNext()) {
                JsonNode jsonNode2 = (JsonNode)object3.next();
                if (jsonNode2.asText().contains("/")) continue;
                ((ArrayList)serializable).add(jsonNode2.asText());
            }
        }
        boolean bl = jsonNode.get("sshHostKeys") != null;
        boolean bl2 = jsonNode.required("ExitNode").asBoolean() || jsonNode.required("ExitNodeOption").asBoolean();
        boolean bl3 = jsonNode.required("Online").asBoolean();
        String string = DataStoreFormatter.formatHostName((String)object, (int)Integer.MAX_VALUE);
        dataStoreEntryRef = DataStoreEntry.createNew((String)string, (DataStore)((b.a)((b.a)((b.a)((b.a)b.builder().parent(dataStoreEntryRef)).id((String)object2)).identity(IdentityValue.ofBreakout((DataStoreEntry)dataStoreEntryRef.get()))).gateway((DataStoreEntryRef<NetworkTunnelStore>)DataStorage.get().local().ref())).build());
        dataStoreEntryRef.setStorePersistentState((DataStoreState)((d.a)((Object)((d.a)((Object)((f.a)((Object)((d.a)((Object)((d.a)((Object)d.builder().address(HostAddress.of((String)object, (List)((Object)serializable))))).ssh(bl))).online(bl3))).state(bl3 ? "Online" : "Offline"))).exitNode(bl2))).build());
        arrayList.add(dataStoreEntryRef.ref());
    }
}

