/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.user;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.core.AppCache;
import io.xpipe.app.core.AppProperties;
import io.xpipe.app.core.AppRestart;
import io.xpipe.app.core.window.AppMainWindow;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.prefs.VaultAuthentication;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.EncryptionToken;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStorageGroupStrategy;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.JacksonMapper;
import io.xpipe.ext.proc.user.a;
import io.xpipe.ext.proc.user.c;
import io.xpipe.ext.proc.user.g;
import io.xpipe.ext.proc.user.i;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javax.crypto.SecretKey;
import lombok.Generated;

public final class f
implements DataStorageUserHandler {
    private Path cR;
    private a gb;
    private List<a> gd;
    private final List<a> ge = new ArrayList<a>();
    private boolean gf;
    private VaultAuthentication gg;

    public static f eK() {
        return (f)DataStorageUserHandler.getInstance();
    }

    public final int getUserCount() {
        return this.gd.size();
    }

    public final void init() {
        this.cR = DataStorage.getStorageDirectory();
        Path path = this.cR.resolve("users.json");
        boolean bl = Files.exists(path, new LinkOption[0]);
        Object object2 = AppPrefs.get().getLockCrypt();
        if (object2.get() != null && !((String)object2.get()).isBlank()) {
            EncryptionToken encryptionToken = EncryptionToken.builder().token((String)object2.get()).build();
            this.gd = new ArrayList<a>();
            this.gd.add(new a("legacy", c.a.builder().encryptedToken(encryptionToken).build(), null));
        } else if (!bl) {
            this.gd = new ArrayList<a>();
        } else {
            try {
                Object object3 = JacksonMapper.getDefault();
                object2 = new TypeReference<ArrayList<a>>(this){
                    {
                        Objects.requireNonNull(f2);
                    }
                };
                object3 = (ArrayList)object3.readValue(path.toFile(), (TypeReference)object2);
                if (object3 == null) {
                    throw new IOException("Unable to read users file json");
                }
                this.gd = new ArrayList<a>((Collection<a>)object3);
                if (this.gd.stream().anyMatch(a2 -> a2 == null)) {
                    throw new IOException("User list contains null entry");
                }
                if (this.gd.stream().anyMatch(object -> ((a)object).getAuthMethod() == null || (object = ((a)object).getAuthMethod()) instanceof c.a && ((c.a)(object = (c.a)object)).getEncryptedToken() == null)) {
                    throw new IOException("User list contains invalid authentication data");
                }
            }
            catch (IOException iOException) {
                throw new IOException("Unable to read vault users file " + String.valueOf(path) + ". Is it corrupted?", iOException);
            }
        }
        g.eP().h(false);
        if (this.gd.size() > 0) {
            boolean bl2 = this.gd.stream().anyMatch(a2 -> {
                if (a2.getGroupStrategy() == null) {
                    return false;
                }
                try {
                    ((DataStorageGroupStrategy)a2.getGroupStrategy().getValue()).checkComplete();
                }
                catch (Exception exception) {
                    return false;
                }
                return true;
            });
            this.gg = bl2 ? VaultAuthentication.GROUP : VaultAuthentication.USER;
        }
    }

    public final void save() {
        if (!this.gf) {
            return;
        }
        Object object = this.cR.resolve("users.json");
        if (this.gd.size() == 0 && !Files.exists((Path)object, new LinkOption[0])) {
            return;
        }
        ObjectMapper objectMapper = JacksonMapper.getDefault();
        try {
            Files.createDirectories(object.getParent(), new FileAttribute[0]);
            objectMapper.writeValue(object.toFile(), this.gd);
            this.gf = false;
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            ErrorEventFactory.fromThrowable((Throwable)iOException).handle();
            return;
        }
    }

    public final void login() {
        if (this.gd.size() == 0) {
            return;
        }
        if (this.gd.size() > 1 && !LicenseProvider.get().getFeature("team").isSupported()) {
            try {
                LicenseProvider.get().getFeature("team").throwIfUnsupported();
                return;
            }
            catch (LicenseRequiredException licenseRequiredException) {
                LicenseRequiredException licenseRequiredException2 = licenseRequiredException;
                ErrorEventFactory.fromThrowable((Throwable)licenseRequiredException).handle();
                return;
            }
        }
        String string = null;
        if (this.gd.size() == 1) {
            string = this.gd.getFirst().getName();
        } else {
            Object object = AppProperties.get().getLoginTarget();
            if (object != null && ((Optional)(object = this.gd.stream().filter(arg_0 -> f.d((String)object, arg_0)).findFirst())).isPresent()) {
                string = ((a)((Optional)object).get()).getName();
            }
            if (string == null) {
                string = (String)AppCache.getNonNull((String)"lastUser", String.class, () -> null);
            }
        }
        i.e(string, this.gd.size() > 1);
    }

    public final SecretKey getEncryptionKey() {
        if (this.gd.size() == 0) {
            return null;
        }
        if (this.gb == null) {
            return null;
        }
        SecretKey secretKey = this.gb.getAuthMethod().getEncryptionKey();
        return secretKey;
    }

    public final BaseRegionBuilder<?, ?> createOverview() {
        BaseRegionBuilder<?, ?> baseRegionBuilder = g.eP().eQ();
        return baseRegionBuilder;
    }

    public final OptionsBuilder createGroupStrategyOptions(ObjectProperty<DataStorageGroupStrategy> optionsBuilder) {
        optionsBuilder = g.eP().a((ObjectProperty<DataStorageGroupStrategy>)optionsBuilder);
        return optionsBuilder;
    }

    public final String getActiveUser() {
        if (this.gb != null) {
            return this.gb.getName();
        }
        return null;
    }

    public final VaultAuthentication getVaultAuthenticationType() {
        return this.gg;
    }

    public final void a(a a2) {
        this.gd.remove(a2);
        this.gf = true;
        if (this.ge.remove(a2)) {
            g.eP().h(true);
            return;
        }
        if (a2.equals(this.gb)) {
            this.gb = null;
        }
        if (a2.getName().equals("legacy")) {
            AppPrefs.get().getLockCrypt().set(null);
        }
        AppMainWindow.resetContent();
        DataStorage.get().forceRewrite();
        DataStorage.get().save(false);
        AppRestart.restart();
    }

    public final boolean eL() {
        return this.gd.size() == 1 && this.gd.getFirst().getName().equals("legacy");
    }

    public final boolean a(String string, InPlaceSecretValue inPlaceSecretValue) {
        c c2;
        Optional<a> optional = this.gd.stream().filter(a2 -> a2.getName().equals(string)).findFirst();
        if (optional.isEmpty()) {
            return false;
        }
        if (inPlaceSecretValue == null) {
            return false;
        }
        boolean bl = string.equals("legacy");
        if (bl && (c2 = optional.get().getAuthMethod()) instanceof c.a && ((c.a)(c2 = (c.a)c2)).unlockLegacy(inPlaceSecretValue)) {
            this.gb = optional.get();
            AppCache.update((String)"lastUser", (Object)this.gb.getName());
            return true;
        }
        c c3 = optional.get().getAuthMethod();
        if (c3 instanceof c.a && ((c.a)(c3 = (c.a)c3)).unlock(inPlaceSecretValue)) {
            this.gb = optional.get();
            AppCache.update((String)"lastUser", (Object)this.gb.getName());
            return true;
        }
        return false;
    }

    public final void a(String string, InPlaceSecretValue object, DataStorageGroupStrategy dataStorageGroupStrategy) {
        if (string == null || string.isBlank() || object == null || object.getSecret().length == 0) {
            return;
        }
        if (this.gd.stream().anyMatch(a2 -> a2.getName().equalsIgnoreCase(string))) {
            return;
        }
        object = new a(string, c.a.ofPassword(object), (EncryptedValue.VaultKey<DataStorageGroupStrategy>)EncryptedValue.VaultKey.of((Object)dataStorageGroupStrategy));
        this.gd.add((a)object);
        this.gf = true;
        if (this.gb == null) {
            this.gb = object;
        } else {
            this.ge.add((a)object);
        }
        g.eP().h(true);
        AppCache.update((String)"lastUser", (Object)string);
        this.save();
        if (this.gd.size() == 1 && AppPrefs.get().encryptAllVaultData().get()) {
            DataStorage.get().forceRewrite();
            DataStorage.get().save(false);
        }
        if (this.gd.size() == 2 && AppPrefs.get().encryptAllVaultData().get()) {
            DataStorage.get().forceRewrite();
            DataStorage.get().save(false);
        }
    }

    public final DataStorageGroupStrategy getGroupStrategy(String object) {
        if (object == null) {
            return null;
        }
        object = this.eN().stream().filter(arg_0 -> f.a((String)object, arg_0)).findFirst().orElse(null);
        if (object == null) {
            return null;
        }
        if ((object = object.getGroupStrategy()) == null) {
            return null;
        }
        try {
            ((DataStorageGroupStrategy)object.getValue()).checkComplete();
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).ignore().handle();
            return null;
        }
        return (DataStorageGroupStrategy)object.getValue();
    }

    public final void setCurrentGroupStrategy(DataStorageGroupStrategy dataStorageGroupStrategy) {
        if (this.gb == null) {
            return;
        }
        this.gb.setGroupStrategy((EncryptedValue.VaultKey<DataStorageGroupStrategy>)(this.gb.getGroupStrategy() != null ? this.gb.getGroupStrategy().withValue((Object)dataStorageGroupStrategy) : EncryptedValue.VaultKey.of((Object)dataStorageGroupStrategy)));
        this.gf = true;
    }

    public final void a(InPlaceSecretValue object) {
        if (this.gb == null) {
            return;
        }
        if (object == null) {
            return;
        }
        object = c.a.ofPassword(object);
        this.gb.setAuthMethod((c)object);
        this.gf = true;
        EncryptionToken.invalidateUserToken();
        if (DataStorage.get() != null) {
            DataStorage.get().forceRewrite();
            DataStorage.get().save(false);
        }
    }

    @Generated
    public final a eM() {
        return this.gb;
    }

    @Generated
    public final List<a> eN() {
        return this.gd;
    }

    private static /* synthetic */ boolean a(String string, a a2) {
        return a2.getName().equalsIgnoreCase(string);
    }

    private static /* synthetic */ boolean d(String string, a a2) {
        return a2.getName().equalsIgnoreCase(string);
    }
}

