/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.vm;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellSession;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableBiFunction;
import io.xpipe.core.FailableSupplier;
import io.xpipe.ext.base.desktop.DesktopApplicationStore;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.proc.d;
import io.xpipe.ext.proc.ssh.g;
import io.xpipe.ext.proc.ssh.y;
import io.xpipe.ext.proc.ssh.z;
import io.xpipe.ext.proc.tunnel.c;
import io.xpipe.ext.proc.tunnel.i;
import io.xpipe.ext.proc.tunnel.j;
import io.xpipe.ext.proc.tunnel.l;
import io.xpipe.ext.proc.vm.b;
import io.xpipe.ext.proc.vm.c;
import io.xpipe.ext.proc.vm.f;
import io.xpipe.ext.proc.vm.h;
import java.util.Optional;
import lombok.Generated;

public abstract class e<T extends h>
implements NetworkTunnelStore,
SelfReferentialStore,
UserScopeStore,
DesktopBaseStore,
d,
i,
b,
f<T> {
    protected final c customIp;
    protected final Integer port;
    protected final IdentityValue identity;
    protected final Boolean forwardX11;
    protected final String additionalOptions;
    protected final Boolean dontUseGateway;

    public void refreshHostAddressOrThrow() {
        ShellControl shellControl = ((ShellStore)this.getHypervisorHost().getStore()).getOrStartSession();
        shellControl = this.prepareHostShell(shellControl).onStartupFail(this.onFail()).start();
        try {
            this.updateGuestState(shellControl);
        }
        finally {
            if (shellControl != null) {
                shellControl.close();
            }
        }
        if (!Boolean.TRUE.equals(((h)this.getState()).getRunning())) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Target system " + this.getSelfEntry().getName() + " is not running"));
        }
        if (((h)this.getState()).getIp() == null) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Unable to determine IP address for system " + this.getSelfEntry().getName()));
        }
    }

    public boolean isLocallyTunnelable() {
        if (!this.isComplete()) {
            return false;
        }
        return f.super.isLocallyTunnelable();
    }

    @Override
    public void finalizeStore() {
        try {
            f.super.finalizeStore();
            return;
        }
        finally {
            d.super.finalizeStore();
        }
    }

    @Override
    public String getSftpUser() {
        return this.identity.unwrap().getUsername().getFixedUsername().orElse(null);
    }

    @Override
    public String getSftpHostAddress() {
        return this.getHostAddress().get();
    }

    @Override
    public int getSftpPort() {
        return this.getPort();
    }

    public HostAddress getHostAddress() {
        String string = this.getEffectiveIp();
        if (string != null) {
            return HostAddress.of((String)string);
        }
        return HostAddress.empty();
    }

    public boolean supportsDesktopAccess() {
        if (this.forwardX11 != null) {
            return this.forwardX11;
        }
        return false;
    }

    public void runDesktopApplication(String string, DesktopApplicationStore desktopApplicationStore) {
        this.startSessionIfNeeded();
        string = ((ShellSession)this.getSession()).getShellControl();
        string.executeSimpleCommand(desktopApplicationStore.getFullCommand());
    }

    public ShellDialect getUsedDesktopDialect() {
        if (((h)this.getState()).getShellDialect() != null) {
            return ((h)this.getState()).getShellDialect();
        }
        return ShellDialects.BASH;
    }

    public boolean isPerUser() {
        return this.identity.isPerUser();
    }

    @Override
    public void startGatewayTunnelIfNeeded() {
        if (this.usesGatewayTunnelSession()) {
            this.refreshHostAddressOrThrow();
        }
        d.super.startGatewayTunnelIfNeeded();
    }

    @Override
    public l createTunnelSession(j j2) {
        FailableSupplier failableSupplier = () -> {
            String string;
            this.startGatewayTunnelIfNeeded();
            String string3 = string = this.isGatewayTunnelSessionActive() ? "localhost" : this.getEffectiveIp();
            int n2 = this.isGatewayTunnelSessionActive() ? this.getLocalGatewayTunnelPort() : (this.getPort() != null ? this.getPort() : 22);
            j2 = this.createBaseSshConfig("ssh").ea().baseCommand((FailableBiFunction<String, Boolean, CommandBuilder, Exception>)((FailableBiFunction)(string2, bl) -> {
                CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"-p", "" + n2}).addQuoted(this.getIdentity().unwrap().getUsername().retrieveUsername() + "@" + string);
                return commandBuilder;
            })).tunnelArguments(((j)j2).toTunnelArguments()).build();
            if (!this.requiresLocalGatewayTunnel() || !this.shouldTunnelToGatewayHost()) {
                return y.a(ProcessControlProvider.get().createLocalProcessControl(true), (z)((Object)j2));
            }
            if (!this.canTunnelToGatewayHost()) {
                throw new UnsupportedOperationException("Intermediate system " + this.getTunnelGateway().get().getName() + " does not support tunneling");
            }
            return y.a(ProcessControlProvider.get().createLocalProcessControl(true), (z)((Object)j2));
        };
        return l.a(j2, (FailableSupplier<ShellControl>)failableSupplier);
    }

    public DataStoreEntryRef<?> getNetworkParent() {
        if (this.getHypervisorHost() != null) {
            return this.getHypervisorHost().asNeeded();
        }
        return null;
    }

    @Override
    public HostAddress getTunnelHostName() {
        String string = this.getEffectiveIp();
        if (string != null) {
            return HostAddress.of((String)string);
        }
        return HostAddress.empty();
    }

    public NetworkTunnelSession createTunnelSession(int n2, int n3, String string) {
        j j2 = ((c.a)((c.a)((c.a)io.xpipe.ext.proc.tunnel.c.builder().originPort(n2)).remotePort(n3)).remoteAddress(string)).build();
        return this.createTunnelSession(j2);
    }

    public String getEffectiveIp() {
        if (this.getCustomIp() != null && this.getCustomIp().use()) {
            return this.getCustomIp().getIp();
        }
        return ((h)this.getState()).getIp();
    }

    public void checkComplete() {
        Validators.nonNull((Object)this.getHypervisorHost());
        Validators.isType((DataStoreEntryRef)this.getHypervisorHost(), ShellStore.class);
        ((ShellStore)this.getHypervisorHost().getStore()).checkComplete();
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompleteUser();
        this.identity.checkCompletePassword();
        this.identity.checkCompleteSshIdentity();
        g g2 = g.bd(this.additionalOptions);
        if (g2.dH().size() > 1) {
            throw new ValidationException("Additional option config contains multiple host entries");
        }
    }

    @Override
    public ShellControl createGuestShell() {
        Optional optional;
        boolean bl2;
        z z2 = this.createBaseSshConfig("ssh");
        if (!this.usesGatewayTunnelSession()) {
            Object object = this.getEffectiveIp();
            boolean bl3 = (Boolean)this.getCache("reachableCheck", Boolean.class, Boolean.FALSE) != false || io.xpipe.ext.proc.network.g.b(LocalShell.getShell(), this.getEffectiveIp(), this.getPort() != null ? this.getPort() : 22);
            this.setCache("reachableCheck", bl3);
            if (!bl3) {
                throw (Exception)ErrorEventFactory.expected((Throwable)this.createReachableException());
            }
            object = z2.ea().baseCommand((FailableBiFunction<String, Boolean, CommandBuilder, Exception>)((FailableBiFunction)(arg_0, arg_1) -> this.lambda$createGuestShell$0((String)object, arg_0, arg_1))).build();
            object = y.a(ProcessControlProvider.get().createLocalProcessControl(true), (z)object);
            return object;
        }
        this.startGatewayTunnelIfNeeded();
        ShellControl shellControl = ((ShellStore)this.getHypervisorHost().getStore()).getOrStartSession();
        boolean bl4 = (Boolean)this.getCache("reachableCheck", Boolean.class, Boolean.FALSE) != false || io.xpipe.ext.proc.network.g.b(shellControl, this.getEffectiveIp(), this.getPort() != null ? this.getPort() : 22);
        this.setCache("reachableCheck", bl4);
        if (!bl4 && (this.dontUseGateway == null || !this.dontUseGateway.booleanValue()) && (bl2 = io.xpipe.ext.proc.network.g.b(LocalShell.getShell(), this.getEffectiveIp(), this.getPort())) && (optional = DataStorage.get().getStoreEntryInProgressIfPresent((DataStore)this)).isPresent()) {
            e<?> e2 = this.withUseGatewayOption(Boolean.TRUE);
            this.stopGatewayTunnelIfNeeded();
            DataStorage.get().updateEntryStore((DataStoreEntry)optional.get(), e2);
            bl4 = true;
            this.setCache("reachableCheck", Boolean.TRUE);
            this.startGatewayTunnelIfNeeded();
        }
        if (!bl4) {
            throw (Exception)ErrorEventFactory.expected((Throwable)this.createReachableException());
        }
        int n2 = this.getLocalGatewayTunnelPort();
        z z3 = z2.ea().baseCommand((FailableBiFunction<String, Boolean, CommandBuilder, Exception>)((FailableBiFunction)(string, bl) -> {
            CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"-p", "" + n2}).addQuoted(this.getIdentity().unwrap().getUsername().retrieveUsername() + "@localhost");
            return commandBuilder;
        })).build();
        y y2 = y.a(ProcessControlProvider.get().createLocalProcessControl(true), z3);
        return y2;
    }

    protected abstract e<?> withUseGatewayOption(Boolean var1);

    protected Exception createReachableException() {
        int n2 = this.getPort() != null ? this.getPort() : 22;
        String string = this.shouldTunnelToGatewayHost() ? "Unable to connect to tunneled VM interface at " + this.getEffectiveIp() + ":" + n2 + " on hypervisor gateway host " + this.getTunnelGateway().get().getName() : "Unable to directly connect to VM interface at " + this.getEffectiveIp() + ":" + n2;
        return new IllegalStateException(string + "\n\nPossible causes:- Is the VM started up and running correctly?\n" + (this.shouldTunnelToGatewayHost() ? "- Is the VM IP reachable from the hypervisor host?\n" : "") + "- Is the SSH server on the VM configured correctly and running?\n- Are you using a firewall setup that blocks tunnel connections, do you have separated VM networks, or have another network customization set up?\n\nYou can try to set a custom IP/hostname for this VM or attempt to adjust your networking setup.");
    }

    public z createBaseSshConfig(String object) {
        object = z.dZ().baseExecutable((String)object).displayHostName(this.getEffectiveIp()).password(this.identity.unwrap().getPassword()).identity(this.identity.unwrap().getSshIdentity()).checkLocalhostKey(false).forwardX11(this.forwardX11 != null ? this.forwardX11 : false).additionalOptions(g.bd(this.additionalOptions)).isForwardedToLocalhost(this.usesGatewayTunnelSession()).secretId(() -> this.getSelfEntry().getUuid()).sourceStore(this);
        return ((z.a)object).build();
    }

    @Override
    public DataStoreEntryRef<NetworkTunnelStore> getTunnelGateway() {
        if (this.getHypervisorHost() != null) {
            return this.getHypervisorHost().asNeeded();
        }
        return null;
    }

    @Override
    public String getGatewayTunnelTargetIp() {
        return this.getEffectiveIp();
    }

    @Override
    public int getGatewayTunnelTargetPort() {
        if (this.port != null) {
            return this.getPort();
        }
        return 22;
    }

    @Override
    public boolean shouldTunnelToGatewayHost() {
        return (Boolean)AppPrefs.get().developerDisableSshTunnelGateways().getValue() == false && (this.dontUseGateway == null || this.dontUseGateway == false);
    }

    @Override
    public FileSystem createSftpFileSystem() {
        this.startGatewayTunnelIfNeeded();
        Object object = this.createBaseSshConfig("sftp").ea().baseCommand((FailableBiFunction<String, Boolean, CommandBuilder, Exception>)((FailableBiFunction)(string, bl) -> {
            String string2 = string = !this.usesGatewayTunnelSession() ? this.getEffectiveIp() : "localhost";
            int n2 = !this.usesGatewayTunnelSession() ? (this.getPort() != null ? this.getPort() : 22) : this.getLocalGatewayTunnelPort();
            string = CommandBuilder.of().add(new String[]{"-p", "" + n2}).addQuoted(this.getIdentity().unwrap().getUsername().retrieveUsername() + "@" + string);
            return string;
        })).build();
        object = y.a(ProcessControlProvider.get().createLocalProcessControl(true), (z)object);
        return new io.xpipe.ext.proc.ssh.b((ShellControl)object);
    }

    @Generated
    protected e(a<T, ?, ?> a2) {
        this.customIp = a2.customIp;
        this.port = a2.port;
        this.identity = a2.identity;
        this.forwardX11 = a2.forwardX11;
        this.additionalOptions = a2.additionalOptions;
        this.dontUseGateway = a2.dontUseGateway;
    }

    @Generated
    public c getCustomIp() {
        return this.customIp;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public Boolean getForwardX11() {
        return this.forwardX11;
    }

    @Generated
    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    @Generated
    public Boolean getDontUseGateway() {
        return this.dontUseGateway;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof e)) {
            return false;
        }
        if (!((e)(object = (e)object)).canEqual(this)) {
            return false;
        }
        Object object2 = this.getPort();
        Object object3 = ((e)object).getPort();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getForwardX11();
        object3 = ((e)object).getForwardX11();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getDontUseGateway();
        object3 = ((e)object).getDontUseGateway();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getCustomIp();
        object3 = ((e)object).getCustomIp();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getIdentity();
        object3 = ((e)object).getIdentity();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getAdditionalOptions();
        object = ((e)object).getAdditionalOptions();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof e;
    }

    @Generated
    public int hashCode() {
        Integer n2 = this.getPort();
        int n3 = 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
        Object object = this.getForwardX11();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getDontUseGateway();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getCustomIp();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAdditionalOptions();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        return n3;
    }

    @Generated
    public String toString() {
        return "VmSshStore(customIp=" + String.valueOf(this.getCustomIp()) + ", port=" + this.getPort() + ", identity=" + String.valueOf(this.getIdentity()) + ", forwardX11=" + this.getForwardX11() + ", additionalOptions=" + this.getAdditionalOptions() + ", dontUseGateway=" + this.getDontUseGateway() + ")";
    }

    private /* synthetic */ CommandBuilder lambda$createGuestShell$0(String string, String string2, Boolean bl) {
        string = CommandBuilder.of().add(new String[]{"-p", "" + (this.getPort() != null ? this.getPort() : 22)}).addQuoted(this.getIdentity().unwrap().getUsername().retrieveUsername() + "@" + string);
        return string;
    }

    @Generated
    public static abstract class a<T extends h, C extends e<T>, B extends a<T, C, B>> {
        @Generated
        private c customIp;
        @Generated
        private Integer port;
        @Generated
        private IdentityValue identity;
        @Generated
        private Boolean forwardX11;
        @Generated
        private String additionalOptions;
        @Generated
        private Boolean dontUseGateway;

        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static <T extends h> void $fillValuesFromInstanceIntoBuilder(e<T> e2, a<T, ?, ?> a2) {
            a2.customIp(e2.customIp);
            a2.port(e2.port);
            a2.identity(e2.identity);
            a2.forwardX11(e2.forwardX11);
            a2.additionalOptions(e2.additionalOptions);
            a2.dontUseGateway(e2.dontUseGateway);
        }

        @Generated
        public B customIp(c c2) {
            this.customIp = c2;
            return this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return this.self();
        }

        @Generated
        public B forwardX11(Boolean bl) {
            this.forwardX11 = bl;
            return this.self();
        }

        @Generated
        public B additionalOptions(String string) {
            this.additionalOptions = string;
            return this.self();
        }

        @Generated
        public B dontUseGateway(Boolean bl) {
            this.dontUseGateway = bl;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VmSshStore.VmSshStoreBuilder(customIp=" + String.valueOf(this.customIp) + ", port=" + this.port + ", identity=" + String.valueOf(this.identity) + ", forwardX11=" + this.forwardX11 + ", additionalOptions=" + this.additionalOptions + ", dontUseGateway=" + this.dontUseGateway + ")";
        }
    }
}

