/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.vmware;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.FixedHierarchyStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.StubShellControl;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import io.xpipe.ext.proc.vmware.d;
import io.xpipe.ext.proc.vmware.g;
import java.util.List;
import lombok.Generated;

@JsonTypeName(value="vmwareInstallation")
@JsonDeserialize(builder=c.class)
public final class b
implements FixedHierarchyStore,
SelfReferentialStore,
StatefulDataStore<a> {
    private final DataStoreEntryRef<ShellStore> host;
    private final String dir;
    private final d installationType;

    public final void checkLicense() {
        LicenseProvider.get().getFeature("vmware").throwIfUnsupported();
    }

    public final FilePath getVmrun(ShellControl shellControl) {
        return this.getInstallationType().i(shellControl, this.dir);
    }

    public final void checkComplete() {
        Validators.nonNull((Object)((Object)this.installationType));
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
        ((ShellStore)this.host.getStore()).checkComplete();
    }

    public final List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() {
        ShellControl shellControl = ((ShellStore)this.getHost().getStore()).getOrStartSession();
        shellControl = shellControl.getOsType() == OsType.WINDOWS && !ShellDialects.isPowershell((ShellControl)shellControl) ? shellControl.subShell(ShellDialects.POWERSHELL).start() : new StubShellControl(shellControl);
        try {
            io.xpipe.ext.proc.vmware.a.a(shellControl, this);
            List<DataStoreEntryRef<g>> list = io.xpipe.ext.proc.vmware.a.a(shellControl, (DataStoreEntryRef<b>)this.getSelfEntry().ref());
            return list;
        }
        finally {
            if (shellControl != null) {
                shellControl.close();
            }
        }
    }

    @Generated
    protected b(b<?, ?> b2) {
        this.host = b2.host;
        this.dir = b2.dir;
        this.installationType = b2.installationType;
    }

    @Generated
    public static b<?, ?> builder() {
        return new c();
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public final String getDir() {
        return this.dir;
    }

    @Generated
    public final d getInstallationType() {
        return this.installationType;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof b)) {
            return false;
        }
        object = (b)object;
        Object object2 = this.getHost();
        Object object3 = ((b)object).getHost();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getDir();
        object3 = ((b)object).getDir();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getInstallationType();
        object = ((b)object).getInstallationType();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = this.getHost();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        Object object = this.getDir();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getInstallationType();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "VmwareInstallationStore(host=" + String.valueOf(this.getHost()) + ", dir=" + this.getDir() + ", installationType=" + String.valueOf((Object)this.getInstallationType()) + ")";
    }

    @Generated
    public static abstract class b<C extends b, B extends b<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;
        @Generated
        private String dir;
        @Generated
        private d installationType;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.host = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B dir(String string) {
            this.dir = string;
            return this.self();
        }

        @Generated
        public B installationType(d d2) {
            this.installationType = d2;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VmwareInstallationStore.VmwareInstallationStoreBuilder(host=" + String.valueOf(this.host) + ", dir=" + this.dir + ", installationType=" + String.valueOf((Object)this.installationType) + ")";
        }
    }

    @JsonTypeName(value="vmwareInstallation")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class c
    extends b<b, c> {
        @Generated
        private c() {
        }

        @Override
        @Generated
        public final b build() {
            return new b(this);
        }
    }

    @JsonDeserialize(builder=b.class)
    public static final class io.xpipe.ext.proc.vmware.b$a
    extends DataStoreState {
        private final String installationName;
        private final String installationVersion;
        private final boolean showNonRunning;

        @Generated
        protected io.xpipe.ext.proc.vmware.b$a(a<?, ?> a2) {
            super(a2);
            this.installationName = a2.installationName;
            this.installationVersion = a2.installationVersion;
            this.showNonRunning = a2.showNonRunning;
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @Generated
        public final a<?, ?> toBuilder() {
            return new b().$fillValuesFrom(this);
        }

        @Generated
        public final String getInstallationName() {
            return this.installationName;
        }

        @Generated
        public final String getInstallationVersion() {
            return this.installationVersion;
        }

        @Generated
        public final boolean isShowNonRunning() {
            return this.showNonRunning;
        }

        @Generated
        public final String toString() {
            return "VmwareInstallationStore.State(installationName=" + this.getInstallationName() + ", installationVersion=" + this.getInstallationVersion() + ", showNonRunning=" + this.isShowNonRunning() + ")";
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof io.xpipe.ext.proc.vmware.b$a)) {
                return false;
            }
            Object object2 = (io.xpipe.ext.proc.vmware.b$a)((Object)object);
            if (!object2.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.isShowNonRunning() != object2.isShowNonRunning()) {
                return false;
            }
            object = this.getInstallationName();
            String string = object2.getInstallationName();
            if (object == null ? string != null : !object.equals(string)) {
                return false;
            }
            object = this.getInstallationVersion();
            object2 = object2.getInstallationVersion();
            return !(object == null ? object2 != null : !object.equals(object2));
        }

        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof io.xpipe.ext.proc.vmware.b$a;
        }

        @Generated
        public final int hashCode() {
            int n2 = super.hashCode();
            n2 = n2 * 59 + (this.isShowNonRunning() ? 79 : 97);
            String string = this.getInstallationName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            string = this.getInstallationVersion();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        @Generated
        public static abstract class a<C extends io.xpipe.ext.proc.vmware.b$a, B extends a<C, B>>
        extends DataStoreState.DataStoreStateBuilder<C, B> {
            @Generated
            private String installationName;
            @Generated
            private String installationVersion;
            @Generated
            private boolean showNonRunning;

            @Generated
            protected B $fillValuesFrom(C c2) {
                super.$fillValuesFrom(c2);
                a.$fillValuesFromInstanceIntoBuilder(c2, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(io.xpipe.ext.proc.vmware.b$a a2, a<?, ?> a3) {
                a3.installationName(a2.installationName);
                a3.installationVersion(a2.installationVersion);
                a3.showNonRunning(a2.showNonRunning);
            }

            @Generated
            public B installationName(String string) {
                this.installationName = string;
                return (B)this.self();
            }

            @Generated
            public B installationVersion(String string) {
                this.installationVersion = string;
                return (B)this.self();
            }

            @Generated
            public B showNonRunning(boolean bl) {
                this.showNonRunning = bl;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "VmwareInstallationStore.State.StateBuilder(super=" + super.toString() + ", installationName=" + this.installationName + ", installationVersion=" + this.installationVersion + ", showNonRunning=" + this.showNonRunning + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<io.xpipe.ext.proc.vmware.b$a, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final io.xpipe.ext.proc.vmware.b$a build() {
                return new io.xpipe.ext.proc.vmware.b$a(this);
            }
        }
    }
}

