/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.incus;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.hub.comp.OsLogoComp;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.BindingsHelper;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.util.DataStoreFormatter;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.StoreStateFormat;
import io.xpipe.ext.base.identity.IdentityChoiceBuilder;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.store.ShellStoreProvider;
import io.xpipe.ext.system.incus.IncusContainerStore;
import io.xpipe.ext.system.incus.IncusInstallStore;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class IncusContainerStoreProvider
implements ShellStoreProvider {
    public BaseRegionBuilder<?, ?> stateDisplay(StoreEntryWrapper w) {
        return new OsLogoComp(w, (ObservableValue)BindingsHelper.map((ObservableValue)w.getPersistentState(), o -> {
            ContainerStoreState state = (ContainerStoreState)o;
            String cs = state.getContainerState();
            if (cs != null && cs.toLowerCase().contains("stopped")) {
                return SystemStateComp.State.FAILURE;
            }
            if (cs != null && cs.toLowerCase().contains("running")) {
                return SystemStateComp.State.SUCCESS;
            }
            return SystemStateComp.State.OTHER;
        }));
    }

    public ObservableValue<String> informationString(StoreSection section) {
        ContainerStoreState c = (ContainerStoreState)section.getWrapper().getPersistentState().getValue();
        String missing = c.getShellMissing() != null && c.getShellMissing() != false ? "No shell available" : null;
        return StoreStateFormat.shellStore((StoreSection)section, s -> new String[]{missing, DataStoreFormatter.capitalize((String)s.getContainerState())}, null);
    }

    public DocumentationLink getHelpLink() {
        return DocumentationLink.LXC;
    }

    public boolean shouldShow(StoreEntryWrapper w) {
        IncusContainerStore s = (IncusContainerStore)w.getEntry().getStore().asNeeded();
        ContainerStoreState state = (ContainerStoreState)s.getState();
        return Boolean.TRUE.equals(state.getRunning()) || ((IncusInstallStore.State)((IncusInstallStore)s.getInstall().getStore()).getState()).isShowNonRunning();
    }

    public boolean shouldShowScan() {
        return false;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        IncusContainerStore s = (IncusContainerStore)store.getStore().asNeeded();
        return s.getInstall().get();
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        IncusContainerStore st = (IncusContainerStore)store.getValue();
        SimpleObjectProperty identity = new SimpleObjectProperty((Object)st.getIdentity());
        GuiDialog q = new OptionsBuilder().name("host").description("lxdHostDescription").addComp((BaseRegionBuilder)new StoreChoiceComp(entry, (ObjectProperty)new ReadOnlyObjectWrapper(((IncusInstallStore)st.getInstall().getStore()).getHost()), ShellStore.class, null, StoreViewState.get().getAllConnectionsCategory())).disable().name("container").description("lxdContainerDescription").addStaticString((Object)st.getContainerName()).sub(IdentityChoiceBuilder.container((ObjectProperty)identity), (Property)identity).bind(() -> ((IncusContainerStore.IncusContainerStoreBuilder)((IncusContainerStore.IncusContainerStoreBuilder)((IncusContainerStore.IncusContainerStoreBuilder)IncusContainerStore.builder().containerName(st.getContainerName())).install(st.getInstall())).identity((IdentityValue)identity.getValue())).build(), new Property[]{store}).buildDialog();
        return q;
    }

    public String getDisplayIconFileName(DataStore store) {
        return "system:lxd_icon.svg";
    }

    public String getId() {
        return "incusContainer";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(IncusContainerStore.class);
    }
}

