/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.podman;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.FixedHierarchyStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandSupport;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.system.podman.PodmanCommandView;
import io.xpipe.ext.system.podman.PodmanContainerStore;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

@JsonTypeName(value="podmanCmd")
@JsonDeserialize(builder=PodmanCmdStoreBuilderImpl.class)
public final class PodmanCmdStore
implements FixedHierarchyStore,
StatefulDataStore<State>,
SelfReferentialStore {
    private final DataStoreEntryRef<ShellStore> host;

    public PodmanCmdStore(DataStoreEntryRef<ShellStore> host) {
        this.host = host;
    }

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
        this.host.checkComplete();
    }

    private List<DataStoreEntryRef<PodmanContainerStore>> listContainers(ShellControl sc) throws Exception {
        PodmanCommandView view = new PodmanCommandView(sc);
        List<PodmanCommandView.Container.ContainerEntry> l = view.container().listContainersAndStates();
        return l.stream().map(s -> {
            boolean running = s.getStatus().startsWith("running") || s.getStatus().startsWith("up") || s.getStatus().startsWith("Up");
            Object c = ((PodmanContainerStore.PodmanContainerStoreBuilder)((PodmanContainerStore.PodmanContainerStoreBuilder)PodmanContainerStore.builder().cmd((DataStoreEntryRef<PodmanCmdStore>)this.getSelfEntry().ref())).containerName(s.getName())).build();
            DataStoreEntry entry = DataStoreEntry.createNew((String)s.getName(), c);
            entry.setStorePersistentState((DataStoreState)((ContainerStoreState.ContainerStoreStateBuilder)ContainerStoreState.builder().containerState(s.getStatus()).imageName(s.getImage()).running(Boolean.valueOf(running))).build());
            return entry.ref();
        }).toList();
    }

    private void updateState(ShellControl host) throws Exception {
        String out = new PodmanCommandView(host).version();
        Pattern namePattern = Pattern.compile("Server:\\s+(.+)");
        Matcher nameMatcher = namePattern.matcher(out);
        String name = nameMatcher.find() ? nameMatcher.group(1) : null;
        Pattern versionPattern = Pattern.compile("Version:\\s+(.+)");
        Matcher versionMatcher = versionPattern.matcher(out);
        String version = versionMatcher.find() ? versionMatcher.group(1) : null;
        this.setState(((State.StateBuilder)((Object)((State.StateBuilder)((Object)((State.StateBuilder)((Object)((State)this.getState()).toBuilder().running(true))).serverName(name))).version(version))).build());
    }

    public List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() throws Exception {
        ShellControl sc = ((ShellStore)this.getHost().getStore()).getOrStartSession();
        PodmanCommandView view = new PodmanCommandView(sc);
        CommandSupport.isSupported(() -> view.isSupported(), (String)"Podman CLI", (DataStoreEntry)this.host.get());
        boolean running = view.isDaemonRunning();
        if (!running) {
            this.setState(((State.StateBuilder)((Object)((State)this.getState()).toBuilder().running(false))).build());
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Podman daemon is not running"));
        }
        this.updateState(sc);
        return this.listContainers(sc);
    }

    @Generated
    protected PodmanCmdStore(PodmanCmdStoreBuilder<?, ?> b) {
        this.host = b.host;
    }

    @Generated
    public static PodmanCmdStoreBuilder<?, ?> builder() {
        return new PodmanCmdStoreBuilderImpl();
    }

    @Generated
    public DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PodmanCmdStore)) {
            return false;
        }
        PodmanCmdStore other = (PodmanCmdStore)o;
        DataStoreEntryRef<ShellStore> this$host = this.getHost();
        DataStoreEntryRef<ShellStore> other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<ShellStore> $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PodmanCmdStore(host=" + String.valueOf(this.getHost()) + ")";
    }

    @JsonDeserialize(builder=StateBuilderImpl.class)
    public static final class State
    extends DataStoreState {
        private final String serverName;
        private final String version;
        private final boolean running;
        private final boolean showNonRunning;

        @Generated
        protected State(StateBuilder<?, ?> b) {
            super(b);
            this.serverName = b.serverName;
            this.version = b.version;
            this.running = b.running;
            this.showNonRunning = b.showNonRunning;
        }

        @Generated
        public static StateBuilder<?, ?> builder() {
            return new StateBuilderImpl();
        }

        @Generated
        public StateBuilder<?, ?> toBuilder() {
            return new StateBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getServerName() {
            return this.serverName;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean isRunning() {
            return this.running;
        }

        @Generated
        public boolean isShowNonRunning() {
            return this.showNonRunning;
        }

        @Generated
        public String toString() {
            return "PodmanCmdStore.State(serverName=" + this.getServerName() + ", version=" + this.getVersion() + ", running=" + this.isRunning() + ", showNonRunning=" + this.isShowNonRunning() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isRunning() != other.isRunning()) {
                return false;
            }
            if (this.isShowNonRunning() != other.isShowNonRunning()) {
                return false;
            }
            String this$serverName = this.getServerName();
            String other$serverName = other.getServerName();
            if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof State;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isRunning() ? 79 : 97);
            result = result * 59 + (this.isShowNonRunning() ? 79 : 97);
            String $serverName = this.getServerName();
            result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public static abstract class StateBuilder<C extends State, B extends StateBuilder<C, B>>
        extends DataStoreState.DataStoreStateBuilder<C, B> {
            @Generated
            private String serverName;
            @Generated
            private String version;
            @Generated
            private boolean running;
            @Generated
            private boolean showNonRunning;

            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                StateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(State instance, StateBuilder<?, ?> b) {
                b.serverName(instance.serverName);
                b.version(instance.version);
                b.running(instance.running);
                b.showNonRunning(instance.showNonRunning);
            }

            @Generated
            public B serverName(String serverName) {
                this.serverName = serverName;
                return (B)this.self();
            }

            @Generated
            public B version(String version) {
                this.version = version;
                return (B)this.self();
            }

            @Generated
            public B running(boolean running) {
                this.running = running;
                return (B)this.self();
            }

            @Generated
            public B showNonRunning(boolean showNonRunning) {
                this.showNonRunning = showNonRunning;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "PodmanCmdStore.State.StateBuilder(super=" + super.toString() + ", serverName=" + this.serverName + ", version=" + this.version + ", running=" + this.running + ", showNonRunning=" + this.showNonRunning + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class StateBuilderImpl
        extends StateBuilder<State, StateBuilderImpl> {
            @Generated
            private StateBuilderImpl() {
            }

            @Override
            @Generated
            protected StateBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public State build() {
                return new State(this);
            }
        }
    }

    @Generated
    public static abstract class PodmanCmdStoreBuilder<C extends PodmanCmdStore, B extends PodmanCmdStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> host) {
            this.host = host;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PodmanCmdStore.PodmanCmdStoreBuilder(host=" + String.valueOf(this.host) + ")";
        }
    }

    @JsonTypeName(value="podmanCmd")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class PodmanCmdStoreBuilderImpl
    extends PodmanCmdStoreBuilder<PodmanCmdStore, PodmanCmdStoreBuilderImpl> {
        @Generated
        private PodmanCmdStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected PodmanCmdStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PodmanCmdStore build() {
            return new PodmanCmdStore(this);
        }
    }
}

