/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.podman;

import io.xpipe.app.comp.BaseRegionBuilder;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.hub.comp.OsLogoComp;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.BindingsHelper;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.StoreStateFormat;
import io.xpipe.ext.base.service.FixedServiceGroupStore;
import io.xpipe.ext.base.store.ShellStoreProvider;
import io.xpipe.ext.system.podman.PodmanCmdStore;
import io.xpipe.ext.system.podman.PodmanContainerStore;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;

public class PodmanContainerStoreProvider
implements ShellStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.PODMAN;
    }

    public boolean shouldShow(StoreEntryWrapper w) {
        PodmanContainerStore s = (PodmanContainerStore)w.getEntry().getStore().asNeeded();
        ContainerStoreState state = (ContainerStoreState)s.getState();
        return Boolean.TRUE.equals(state.getRunning()) || ((PodmanCmdStore.State)((PodmanCmdStore)s.getCmd().getStore()).getState()).isShowNonRunning();
    }

    public void onParentRefresh(DataStoreEntry entry) {
        FixedServiceGroupStore services = ((FixedServiceGroupStore.FixedServiceGroupStoreBuilder)FixedServiceGroupStore.builder().parent(entry.ref())).build();
        Optional servicesEntry = DataStorage.get().getStoreEntryIfPresent((DataStore)services, false);
        if (servicesEntry.isPresent()) {
            DataStorage.get().refreshChildren((DataStoreEntry)servicesEntry.get());
        }
    }

    public boolean shouldShowScan() {
        return false;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        PodmanContainerStore s = (PodmanContainerStore)store.getStore().asNeeded();
        return s.getCmd().get();
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        PodmanContainerStore st = (PodmanContainerStore)store.getValue();
        return new OptionsBuilder().name("host").description("podmanHostDescription").addComp((BaseRegionBuilder)new StoreChoiceComp(entry, (ObjectProperty)new ReadOnlyObjectWrapper(st.getCmd() != null ? ((PodmanCmdStore)st.getCmd().getStore()).getHost() : null), ShellStore.class, null, StoreViewState.get().getAllConnectionsCategory())).disable().name("container").description("podmanContainerDescription").addStaticString((Object)st.getContainerName()).buildDialog();
    }

    public String getDisplayIconFileName(DataStore store) {
        return "system:podman_icon.svg";
    }

    public String getId() {
        return "podman";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(PodmanContainerStore.class);
    }

    public BaseRegionBuilder<?, ?> stateDisplay(StoreEntryWrapper w) {
        return new OsLogoComp(w, (ObservableValue)BindingsHelper.map((ObservableValue)w.getPersistentState(), o -> {
            ContainerStoreState state = (ContainerStoreState)o;
            String cs = state.getContainerState();
            if (cs != null && cs.toLowerCase().contains("exited")) {
                return SystemStateComp.State.FAILURE;
            }
            if (cs != null && cs.toLowerCase().contains("up")) {
                return SystemStateComp.State.SUCCESS;
            }
            return SystemStateComp.State.OTHER;
        }));
    }

    public ObservableValue<String> informationString(StoreSection section) {
        ContainerStoreState c = (ContainerStoreState)section.getWrapper().getPersistentState().getValue();
        String missing = c.getShellMissing() != null && c.getShellMissing() != false ? "No shell available" : null;
        return StoreStateFormat.shellStore((StoreSection)section, s -> new String[]{missing, s.getContainerState()}, null);
    }
}

